/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.databaselist;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import pilotdb.PilotDBDatabase;
import pilotdb.ui.Application;
import pilotdb.ui.databaselist.DbPropertiesModel;
import pilotdb.ui.images.Images;
import pilotdb.ui.util.FlatJButton;
import pilotdb.ui.util.FlatTableCellRenderer;

public class DatabasePropertiesPanel
extends JPanel
implements ActionListener {
    public static final int RESPONSE_OK = 0;
    public static final int RESPONSE_CANCEL = 1;
    private transient Vector actionListeners;
    JButton jbOk;
    JButton jbCancel;
    JButton jbHelp;
    JLabel jlDbProperties;
    DbPropertiesModel tableModel = new DbPropertiesModel();
    JTable jtblDbProperties;
    JScrollPane jspDbProperties;
    FlatTableCellRenderer ftcr = new FlatTableCellRenderer();
    PilotDBDatabase database = null;
    Application application = null;

    public DatabasePropertiesPanel(Application application) {
        this.application = application;
        this.uiInit();
    }

    public void setDatabase(PilotDBDatabase db) {
        this.database = db;
        this.tableModel.setDatabase(db);
    }

    private void uiInit() {
        this.jlDbProperties = new JLabel();
        this.jlDbProperties.setText("database properties");
        this.jtblDbProperties = new JTable(this.tableModel);
        this.jtblDbProperties.getTableHeader().setDefaultRenderer(this.ftcr);
        this.jspDbProperties = new JScrollPane(this.jtblDbProperties);
        this.jbOk = new FlatJButton();
        this.jbCancel = new FlatJButton();
        try {
            this.jbHelp = new FlatJButton();
            this.jbHelp.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(this.application.getHelpBroker()));
            CSH.setHelpIDString((Component)this.jbHelp, (String)"dbprops");
            this.jbHelp.setIcon(Images.QUESTION_ICON);
            this.jbHelp.setBounds(60, 150, 75, 25);
            this.jbHelp.setText("help");
        }
        catch (Throwable t) {
            this.jbHelp = null;
        }
        this.jbOk.addActionListener(this);
        this.jbCancel.addActionListener(this);
        this.jbOk.setIcon(Images.OK_ICON);
        this.jbCancel.setIcon(Images.CANCEL_ICON);
        this.jbOk.setText("ok");
        this.jbCancel.setText("cancel");
        this.jspDbProperties.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.setLayout(null);
        if (this.jbHelp != null) {
            this.add(this.jbHelp);
        }
        this.add(this.jspDbProperties);
        this.add(this.jlDbProperties);
        this.add(this.jbOk);
        this.add(this.jbCancel);
        this.jlDbProperties.setBounds(5, 5, 290, 20);
        this.jspDbProperties.setBounds(15, 30, 275, 100);
        this.jbOk.setBounds(140, 150, 75, 25);
        this.jbCancel.setBounds(220, 150, 75, 25);
        this.setPreferredSize(new Dimension(305, 185));
        this.ftcr.setBackground(Color.black);
        this.ftcr.setForeground(Color.white);
    }

    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.jbCancel) {
            this.onCancel(ae);
        } else if (source == this.jbOk) {
            this.onOk(ae);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCancel(ActionEvent evt) {
        if (this.actionListeners != null) {
            Vector vector = this.actionListeners;
            synchronized (vector) {
                int i = 0;
                while (i < this.actionListeners.size()) {
                    ActionListener al = (ActionListener)this.actionListeners.get(i);
                    ActionEvent ae = new ActionEvent(this, 1, "cancel");
                    al.actionPerformed(ae);
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onOk(ActionEvent evt) {
        if (this.actionListeners != null) {
            Vector vector = this.actionListeners;
            synchronized (vector) {
                int i = 0;
                while (i < this.actionListeners.size()) {
                    ActionListener al = (ActionListener)this.actionListeners.get(i);
                    ActionEvent ae = new ActionEvent(this, 0, "ok");
                    al.actionPerformed(ae);
                    ++i;
                }
            }
        }
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (this.actionListeners != null && this.actionListeners.contains(l)) {
            Vector v = (Vector)this.actionListeners.clone();
            v.removeElement(l);
            this.actionListeners = v;
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        Vector v;
        Vector vector = v = this.actionListeners == null ? new Vector(2) : (Vector)this.actionListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.actionListeners = v;
        }
    }
}

