/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.databaselist;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBEnvironment;
import pilotdb.PilotDBRecord;
import pilotdb.ui.Application;
import pilotdb.ui.command.Command;
import pilotdb.ui.command.handler.CommandHandler;
import pilotdb.ui.command.handler.CommandHandlerSupport;
import pilotdb.ui.databaselist.DBListTableModel;
import pilotdb.ui.util.FlatTableCellRenderer;
import pilotdb.ui.util.UIBanner;

public class DBListPanel
extends JPanel
implements CommandHandler,
MouseListener,
ActionListener {
    Application application = null;
    CommandHandlerSupport support = new CommandHandlerSupport();
    DBListTableModel tableModel = new DBListTableModel();
    private transient Vector propertyChangeListeners;
    UIBanner uibanner = new UIBanner("Database Browser", 100, null);
    JScrollPane jspDatabaseList = new JScrollPane();
    JTable jtblDatabaseList = new JTable();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout1 = new BorderLayout(0, 0);
    FlatTableCellRenderer ftcr2;
    JPopupMenu jpm;
    JMenuItem jmiSaveDatabase;
    JMenuItem jmiAddDatabase;
    JMenuItem jmiDeleteDatabase;
    JMenuItem jmiOpenDatabase;
    JMenuItem jmiInstallDatabase;
    JMenuItem jmiDbProps;
    FlowLayout flowLayout1 = new FlowLayout(0, 0, 0);
    static /* synthetic */ Class class$0;

    public DBListPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JPopupMenu getPopupMenu() {
        if (this.jpm == null) {
            this.jpm = new JPopupMenu();
            this.jmiAddDatabase = new JMenuItem();
            this.jmiDeleteDatabase = new JMenuItem();
            this.jmiSaveDatabase = new JMenuItem();
            this.jmiOpenDatabase = new JMenuItem();
            this.jmiDbProps = new JMenuItem();
            this.jmiInstallDatabase = new JMenuItem();
            this.jmiAddDatabase.setText("create new");
            this.jmiDeleteDatabase.setText("delete database");
            this.jmiSaveDatabase.setText("commit database");
            this.jmiOpenDatabase.setText("open database");
            this.jmiDbProps.setText("properties");
            this.jmiInstallDatabase.setText("install");
            this.jpm.add(this.jmiOpenDatabase);
            this.jpm.add(this.jmiSaveDatabase);
            this.jpm.add(this.jmiInstallDatabase);
            this.jpm.add(this.jmiDeleteDatabase);
            this.jpm.add(this.jmiDbProps);
            this.jpm.addSeparator();
            this.jpm.add(this.jmiAddDatabase);
            this.jmiOpenDatabase.addActionListener(this);
            this.jmiSaveDatabase.addActionListener(this);
            this.jmiAddDatabase.addActionListener(this);
            this.jmiInstallDatabase.addActionListener(this);
            this.jmiDeleteDatabase.addActionListener(this);
            this.jmiDbProps.addActionListener(this);
        }
        return this.jpm;
    }

    public void setApplication(Application bridge) {
        this.application = bridge;
        this.support.setBridge(bridge);
        bridge.addToChain(this);
    }

    public Application getBridge() {
        return this.application;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jtblDatabaseList.setAutoResizeMode(0);
        this.jtblDatabaseList.setModel(this.tableModel);
        this.jtblDatabaseList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                DBListPanel.this.tableClickedOn(e);
            }
        });
        this.jtblDatabaseList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent lse) {
                if (!lse.getValueIsAdjusting()) {
                    DBListPanel.this.tableRowSelected();
                }
            }
        });
        this.jtblDatabaseList.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.jtblDatabaseList.getColumnModel().getColumn(1).setPreferredWidth(75);
        this.jtblDatabaseList.getColumnModel().getColumn(2).setPreferredWidth(20);
        this.jtblDatabaseList.getColumnModel().getColumn(3).setPreferredWidth(20);
        this.jtblDatabaseList.addMouseListener(this);
        this.flowLayout1.setAlignment(0);
        this.flowLayout1.setVgap(0);
        this.setPreferredSize(new Dimension(300, 200));
        this.add((Component)this.jspDatabaseList, "Center");
        this.jspDatabaseList.getViewport().add((Component)this.jtblDatabaseList, null);
        this.add((Component)this.uibanner, "North");
        FlatTableCellRenderer ftcr = new FlatTableCellRenderer();
        ftcr.setBackground(SystemColor.controlDkShadow);
        ftcr.setForeground(SystemColor.controlLtHighlight);
        ftcr.setHorizontalAlignment(2);
        this.jtblDatabaseList.getTableHeader().setDefaultRenderer(ftcr);
        this.jspDatabaseList.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jspDatabaseList.addMouseListener(this);
        this.ftcr2 = new FlatTableCellRenderer();
        this.ftcr2.setBackground(SystemColor.controlLtHighlight);
        this.ftcr2.setForeground(SystemColor.controlText);
        this.ftcr2.setAlternateBackground(SystemColor.control);
        this.ftcr2.setAlternateForeground(SystemColor.controlText);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.jtblDatabaseList.setDefaultRenderer(clazz, this.ftcr2);
    }

    public void rescanDatabases() {
        this.tableModel.reloadDatabases(this);
    }

    public PilotDBDatabase[] getSelectedDatabases() {
        int[] rows = this.jtblDatabaseList.getSelectedRows();
        LinkedList<PilotDBDatabase> l = new LinkedList<PilotDBDatabase>();
        int i = 0;
        while (i < rows.length) {
            if (rows[i] >= 0) {
                l.add(this.tableModel.getDatabase(rows[i]));
            }
            ++i;
        }
        return l.toArray(new PilotDBDatabase[0]);
    }

    public File getEnvironment() {
        return this.tableModel.getEnvironment();
    }

    void tableRowSelected() {
        int selectedRow = this.jtblDatabaseList.getSelectedRow();
        if (selectedRow < 0) {
            return;
        }
        PilotDBDatabase db = this.tableModel.getDatabase(selectedRow);
        Command ce = new Command(this, "msg-selected-database", db);
        this.application.postEvent(ce);
        Command c = new Command(this, "msg-windowstate-changed", this);
        this.application.postEvent(c);
    }

    void tableClickedOn(MouseEvent e) {
        if (this.application == null) {
            return;
        }
        if (e.getClickCount() > 1) {
            PilotDBDatabase[] dbs = this.getSelectedDatabases();
            int i = 0;
            while (i < dbs.length) {
                this.application.postEvent(new Command(this, "cmd-open-database", dbs[i]));
                ++i;
            }
        }
    }

    public void handle(Command evt) {
        if (evt.equals("msg-committed-database")) {
            PilotDBDatabase db = (PilotDBDatabase)evt.getAttachedObject();
            int rows = this.tableModel.getRowCount();
            int i = 0;
            while (i < rows) {
                if (this.tableModel.getDatabase(i) == db) {
                    this.tableModel.fireTableRowsUpdated(i, i + 1);
                }
                ++i;
            }
        } else if (evt.equals("msg-changed-record")) {
            PilotDBRecord record = (PilotDBRecord)evt.getAttachedObject();
            PilotDBDatabase db = record.getDb();
            int rows = this.tableModel.getRowCount();
            int i = 0;
            while (i < rows) {
                if (this.tableModel.getDatabase(i) == db) {
                    this.tableModel.fireTableRowsUpdated(i, i + 1);
                }
                ++i;
            }
        } else if (evt.equals("msg-opened-directory")) {
            File f = (File)evt.getAttachedObject();
            try {
                this.tableModel.setEnvironment(this, f);
            }
            catch (Exception e) {
                Command ce = new Command(this, "cmd-log-exception", e);
                this.application.postEvent(ce);
            }
        } else if (evt.equals("cmd-delete-database")) {
            PilotDBDatabase db = (PilotDBDatabase)evt.getAttachedObject();
            PilotDBDatabase[] dbs = null;
            dbs = db == null ? this.getSelectedDatabases() : new PilotDBDatabase[]{db};
            if (dbs == null || dbs.length == 0) {
                JOptionPane.showMessageDialog(this, "No database is selected", "Error", -1);
                return;
            }
            int i = 0;
            while (i < dbs.length) {
                PilotDBEnvironment env = PilotDBEnvironment.getEnvironment(dbs[i]);
                Command ce = new Command(this, "cmd-close-database", dbs[i]);
                try {
                    this.application.postEventAndWait(ce);
                    boolean deleted = env.deleteDatabase(dbs[i]);
                    if (!deleted) {
                        JOptionPane.showMessageDialog(this, "Unable to delete database", "Error", 0);
                    }
                    ce = new Command(this, "msg-deleted-database", dbs[i]);
                    this.application.postEvent(ce);
                }
                catch (Exception e) {
                    Command ce2 = new Command(this, "cmd-log-exception", e);
                    this.application.postEvent(ce2);
                }
                ++i;
            }
        } else if (evt.equals("msg-created-database")) {
            this.tableModel.reloadDatabases(this);
        } else if (evt.equals("msg-deleted-database")) {
            this.tableModel.reloadDatabases(this);
        }
        if (this.getSuccessor() != null) {
            this.getSuccessor().handle(evt);
        }
    }

    public void setSuccessor(CommandHandler handler) {
        this.support.setSuccessor(handler);
    }

    public CommandHandler getSuccessor() {
        return this.support.getSuccessor();
    }

    public boolean isTail() {
        return this.support.isTail();
    }

    public void addToChain(CommandHandler handler) {
        this.support.addToChain(handler);
    }

    public void mouseClicked(MouseEvent arg0) {
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent arg0) {
        this.maybeShowPopup(arg0);
    }

    public void mouseReleased(MouseEvent arg0) {
        this.maybeShowPopup(arg0);
    }

    private void maybeShowPopup(MouseEvent me) {
        if (me.isPopupTrigger()) {
            this.enablePopupMenus();
            this.getPopupMenu().show(this, me.getX(), me.getY());
        }
    }

    private void enablePopupMenus() {
        PilotDBDatabase[] db = this.getSelectedDatabases();
        this.getPopupMenu();
        this.jmiOpenDatabase.setEnabled(db.length > 0);
        this.jmiSaveDatabase.setEnabled(db.length > 0);
        this.jmiDeleteDatabase.setEnabled(db.length > 0);
    }

    public void actionPerformed(ActionEvent arg0) {
        block6: {
            Command command;
            Object source;
            block10: {
                block9: {
                    block8: {
                        block7: {
                            block5: {
                                source = arg0.getSource();
                                command = null;
                                if (source != this.jmiAddDatabase) break block5;
                                command = new Command(this, "mnu-show-tablemakergui", null);
                                this.application.postEvent(command);
                                break block6;
                            }
                            if (source != this.jmiDeleteDatabase) break block7;
                            PilotDBDatabase[] selectedDbs = this.getSelectedDatabases();
                            int i = 0;
                            while (i < selectedDbs.length) {
                                command = new Command(this, "cmd-delete-database", selectedDbs[i]);
                                this.application.postEvent(command);
                                ++i;
                            }
                            break block6;
                        }
                        if (source != this.jmiSaveDatabase) break block8;
                        PilotDBDatabase[] selectedDbs = this.getSelectedDatabases();
                        int i = 0;
                        while (i < selectedDbs.length) {
                            command = new Command(this, "cmd-commit-database", selectedDbs[i]);
                            this.application.postEvent(command);
                            ++i;
                        }
                        break block6;
                    }
                    if (source != this.jmiOpenDatabase) break block9;
                    PilotDBDatabase[] selectedDbs = this.getSelectedDatabases();
                    int i = 0;
                    while (i < selectedDbs.length) {
                        command = new Command(this, "cmd-open-database", selectedDbs[i]);
                        this.application.postEvent(command);
                        ++i;
                    }
                    break block6;
                }
                if (source != this.jmiDbProps) break block10;
                PilotDBDatabase[] selectedDbs = this.getSelectedDatabases();
                int i = 0;
                while (i < selectedDbs.length) {
                    command = new Command(this, "cmd-show-dbprops", selectedDbs[i]);
                    this.application.postEvent(command);
                    ++i;
                }
                break block6;
            }
            if (source != this.jmiInstallDatabase) break block6;
            PilotDBDatabase[] selectedDbs = this.getSelectedDatabases();
            int i = 0;
            while (i < selectedDbs.length) {
                command = new Command(this, "cmd-install-database", selectedDbs[i]);
                this.application.postEvent(command);
                ++i;
            }
        }
    }

    public void sizeColumns() {
        int[] columnMaxWidths = this.getColumnWidths();
        TableColumnModel model = this.jtblDatabaseList.getColumnModel();
        int i = 0;
        while (i < columnMaxWidths.length) {
            model.getColumn(i).setPreferredWidth(columnMaxWidths[i] + 20);
            ++i;
        }
    }

    private int[] getColumnWidths() {
        FontMetrics fm = this.getFontMetrics(this.ftcr2.getFont());
        int rows = this.tableModel.getRowCount();
        int cols = this.tableModel.getColumnCount();
        int[] widths = new int[cols];
        int c = 0;
        while (c < cols) {
            int r = 0;
            while (r < rows) {
                widths[c] = Math.max(widths[c], fm.stringWidth(String.valueOf(this.tableModel.getValueAt(r, c))));
                ++r;
            }
            ++c;
        }
        return widths;
    }
}

