/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.command.handler;

import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import javax.swing.JInternalFrame;
import pilotdb.PilotDBDatabase;
import pilotdb.ui.Application;
import pilotdb.ui.UserPreferences;
import pilotdb.ui.command.Command;
import pilotdb.ui.command.handler.AbstractCommandHandler;
import pilotdb.ui.recordsetview.RecordsetList;

public class OpenDbHandler
extends AbstractCommandHandler {
    public OpenDbHandler(Application bridge) {
        super(bridge);
    }

    public void handle(Command evt) {
        Object attached;
        if (evt.equals("cmd-open-database") && (attached = evt.getAttachedObject()) != null && attached instanceof PilotDBDatabase) {
            PilotDBDatabase db = (PilotDBDatabase)attached;
            if (this.getBridge().getMainWindow().internalFrameExists(db.getTitle())) {
                File f = this.getBridge().getCurrentEnvironment().getFile(db);
                JInternalFrame jif = this.getBridge().getMainWindow().getInternalFrame(f.getName());
                this.getBridge().getMainWindow().getDesktop().moveToFront(jif);
                return;
            }
            RecordsetList recordsetList = new RecordsetList(this.getBridge());
            recordsetList.setDatabase(db);
            Rectangle r = this.getBridge().getUserPreferences().getRecordsListLocation();
            if (r != null && r.x != -1) {
                recordsetList.setBounds(r);
            }
            recordsetList.addComponentListener(new ComponentListener(){

                public void componentResized(ComponentEvent arg0) {
                    RecordsetList jif = (RecordsetList)arg0.getSource();
                    UserPreferences up = OpenDbHandler.this.getBridge().getUserPreferences();
                    up.setRecordsListLocation(jif.getBounds());
                    try {
                        Application.savePreferences(up);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public void componentMoved(ComponentEvent arg0) {
                    RecordsetList jif = (RecordsetList)arg0.getSource();
                    UserPreferences up = OpenDbHandler.this.getBridge().getUserPreferences();
                    up.setRecordsListLocation(jif.getBounds());
                    try {
                        Application.savePreferences(up);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public void componentShown(ComponentEvent arg0) {
                    RecordsetList jif = (RecordsetList)arg0.getSource();
                    OpenDbHandler.this.getBridge().postEvent(new Command(this, "msg-selected-record", jif.getSelectedRecord()));
                }

                public void componentHidden(ComponentEvent arg0) {
                    OpenDbHandler.this.getBridge().postEvent(new Command(this, "msg-selected-record", null));
                }
            });
        }
        super.handle(evt);
    }
}

