/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.command.handler;

import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBRecord;
import pilotdb.ui.Application;
import pilotdb.ui.command.Command;
import pilotdb.ui.command.handler.AbstractCommandHandler;
import pilotdb.ui.recordsetview.DynamicForm;
import pilotdb.ui.recordsetview.RecordsetList;

public class InternalFrameHandler
extends AbstractCommandHandler {
    public InternalFrameHandler(Application bridge) {
        super(bridge);
    }

    public void handle(Command evt) {
        if (evt.equals("cmd-close-database")) {
            PilotDBDatabase db = (PilotDBDatabase)evt.getAttachedObject();
            this.closeWindowsFor(db);
        } else if (evt.equals("msg-deleted-record")) {
            PilotDBRecord record = (PilotDBRecord)evt.getAttachedObject();
            this.refreshRecordList((PilotDBDatabase)record.getDatabase());
        } else if (evt.equals("msg-added-record")) {
            PilotDBRecord record = (PilotDBRecord)evt.getAttachedObject();
            this.refreshRecordList((PilotDBDatabase)record.getDatabase());
        } else if (evt.equals("msg-changed-record")) {
            PilotDBRecord record = (PilotDBRecord)evt.getAttachedObject();
            this.refreshRecordList((PilotDBDatabase)record.getDatabase());
        }
        super.handle(evt);
    }

    private void refreshRecordList(PilotDBDatabase db) {
        JDesktopPane desktop = this.getBridge().getMainWindow().getDesktop();
        JInternalFrame[] jifs = desktop.getAllFrames();
        int i = 0;
        while (i < jifs.length) {
            RecordsetList rl;
            if (jifs[i] instanceof RecordsetList && (rl = (RecordsetList)jifs[i]).getDatabase() == db) {
                rl.refreshTableData();
            }
            ++i;
        }
    }

    private void closeWindowsFor(PilotDBDatabase db) {
        JDesktopPane desktop = this.getBridge().getMainWindow().getDesktop();
        JInternalFrame[] jifs = desktop.getAllFrames();
        int i = 0;
        while (i < jifs.length) {
            JInternalFrame rl;
            if (jifs[i] instanceof DynamicForm) {
                rl = (DynamicForm)jifs[i];
                if (((DynamicForm)rl).getRecord().getDatabase() == db) {
                    rl.setVisible(false);
                    rl.dispose();
                }
            } else if (jifs[i] instanceof RecordsetList && ((RecordsetList)(rl = (RecordsetList)jifs[i])).getDatabase() == db) {
                rl.setVisible(false);
                rl.dispose();
            }
            ++i;
        }
    }
}

