/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.command.handler;

import palmdb.PalmDbException;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBField;
import pilotdb.PilotDBRecord;
import pilotdb.ui.Application;
import pilotdb.ui.command.Command;
import pilotdb.ui.command.handler.AbstractCommandHandler;
import pilotdb.ui.tablemaker.SchemaEditModel;
import pilotdb.ui.tablemaker.TableMakerInternalFrame;

public class EditSchemaHandler
extends AbstractCommandHandler {
    public EditSchemaHandler(Application app) {
        super(app);
    }

    public void handle(Command event) {
        if (event.equals("cmd-show-editschema")) {
            PilotDBDatabase db = (PilotDBDatabase)event.getAttachedObject();
            if (db == null) {
                db = this.getBridge().getSelectedDatabase();
            }
            TableMakerInternalFrame tmif = new TableMakerInternalFrame(this.getBridge(), db);
            tmif.pack();
            tmif.setVisible(true);
        } else if (event.equals("cmd-create-tablefromedited")) {
            SchemaEditModel model = (SchemaEditModel)event.getAttachedObject();
            try {
                this.doMigrateData(model);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.handle(event);
    }

    private void doMigrateData(SchemaEditModel sem) throws Exception {
        PilotDBDatabase db = new PilotDBDatabase(sem.getName(), "DB00", "DBOS", sem.getSchema());
        PilotDBDatabase oldDb = sem.getOriginalDatabase();
        int i = 0;
        while (i < oldDb.getRecordCount()) {
            PilotDBRecord newRecord = db.createRecord();
            PilotDBRecord oldRecord = (PilotDBRecord)oldDb.getRecord(i);
            newRecord.setId(oldRecord.getId());
            int si = 0;
            while (si < sem.getFieldCount()) {
                PilotDBField newField = sem.getField(si);
                if (!this.newfield(newField, sem)) {
                    if (this.moved(newField, sem)) {
                        int oldidx = this.oldpos(newField, sem);
                        this.migrateData(newRecord, si, oldRecord, oldidx);
                    } else {
                        this.migrateData(newRecord, si, oldRecord, si);
                    }
                }
                ++si;
            }
            ++i;
        }
        db.setViews(oldDb.getViews());
        Command c = new Command(this, "cmd-delete-database", oldDb);
        this.getBridge().postEventAndWait(c);
        this.getBridge().getCurrentEnvironment().add(db);
        db = this.getBridge().getCurrentEnvironment().getDatabaseByTitle(db.getTitle());
        db.recalculate();
        this.getBridge().getCurrentEnvironment().commit(db);
    }

    private void migrateData(PilotDBRecord newRec, int newFieldIdx, PilotDBRecord oldRec, int oldFieldIdx) throws PalmDbException {
        int origType = oldRec.getSchema().getField(oldFieldIdx).getType();
        int newType = newRec.getSchema().getField(newFieldIdx).getType();
        switch (newType) {
            case 1: {
                this.migrateToBoolean(newRec, newFieldIdx, oldRec, oldFieldIdx, origType);
                break;
            }
            case 9: {
                this.migrateToCalculated(newRec, newFieldIdx, oldRec, oldFieldIdx, origType);
                break;
            }
            case 3: {
                this.migrateToDate(newRec, newFieldIdx, oldRec, oldFieldIdx, origType);
                break;
            }
            case 8: {
                this.migrateToFloat(newRec, newFieldIdx, oldRec, oldFieldIdx, origType);
                break;
            }
            case 2: {
                this.migrateToInteger(newRec, newFieldIdx, oldRec, oldFieldIdx, origType);
                break;
            }
            case 7: {
                this.migrateToLink(newRec, newFieldIdx, oldRec, oldFieldIdx, origType);
                break;
            }
            case 10: {
                this.migrateToLinked(newRec, newFieldIdx, oldRec, oldFieldIdx, origType);
                break;
            }
            case 6: {
                this.migrateToList(newRec, newFieldIdx, oldRec, oldFieldIdx, origType);
                break;
            }
            case 5: {
                this.migrateToNote(newRec, newFieldIdx, oldRec, oldFieldIdx, origType);
                break;
            }
            case 0: {
                this.migrateToString(newRec, newFieldIdx, oldRec, oldFieldIdx, origType);
                break;
            }
            case 4: {
                this.migrateToTime(newRec, newFieldIdx, oldRec, oldFieldIdx, origType);
            }
        }
    }

    private void migrateToBoolean(PilotDBRecord newRec, int newFieldIdx, PilotDBRecord oldRec, int oldFieldIdx, int oldType) throws PalmDbException {
        switch (oldType) {
            case 1: {
                newRec.setBoolean(newFieldIdx, oldRec.getBoolean(oldFieldIdx));
                break;
            }
            case 8: {
                newRec.setBoolean(newFieldIdx, oldRec.getFloat(oldFieldIdx) != 0.0);
                break;
            }
            case 2: {
                newRec.setBoolean(newFieldIdx, oldRec.getInteger(oldFieldIdx) != 0);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                newRec.setBoolean(newFieldIdx, oldRec.getNote(oldFieldIdx) != null);
                break;
            }
            case 0: {
                newRec.setBoolean(newFieldIdx, oldRec.getString(oldFieldIdx) != null);
            }
        }
    }

    private void migrateToCalculated(PilotDBRecord newRec, int newFieldIdx, PilotDBRecord oldRec, int oldFieldIdx, int oldType) throws PalmDbException {
        switch (oldType) {
            default: 
        }
    }

    private void migrateToDate(PilotDBRecord newRec, int newFieldIdx, PilotDBRecord oldRec, int oldFieldIdx, int oldType) throws PalmDbException {
        switch (oldType) {
            default: 
        }
    }

    private void migrateToFloat(PilotDBRecord newRec, int newFieldIdx, PilotDBRecord oldRec, int oldFieldIdx, int oldType) throws PalmDbException {
        switch (oldType) {
            default: 
        }
    }

    private void migrateToInteger(PilotDBRecord newRec, int newFieldIdx, PilotDBRecord oldRec, int oldFieldIdx, int oldType) throws PalmDbException {
        switch (oldType) {
            case 1: {
                boolean b = oldRec.getBoolean(oldFieldIdx);
                int value = b ? 1 : 0;
                newRec.setInteger(newFieldIdx, value);
                break;
            }
            case 9: {
                try {
                    String s = oldRec.getCalculatedText(oldFieldIdx);
                    newRec.setInteger(newFieldIdx, Integer.parseInt(s));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            case 8: {
                newRec.setInteger(newFieldIdx, (int)oldRec.getFloat(oldFieldIdx));
                break;
            }
            case 2: {
                newRec.setInteger(newFieldIdx, oldRec.getInteger(oldFieldIdx));
                break;
            }
            case 6: {
                newRec.setInteger(newFieldIdx, oldRec.getList(oldFieldIdx));
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: {
                break;
            }
            case 0: 
            case 5: {
                try {
                    newRec.setInteger(newFieldIdx, Integer.parseInt(oldRec.getObject(oldFieldIdx).toString()));
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void migrateToLink(PilotDBRecord newRec, int newFieldIdx, PilotDBRecord oldRec, int oldFieldIdx, int oldType) {
    }

    private void migrateToLinked(PilotDBRecord newRec, int newFieldIdx, PilotDBRecord oldRec, int oldFieldIdx, int oldType) {
    }

    private void migrateToList(PilotDBRecord newRec, int newFieldIdx, PilotDBRecord oldRec, int oldFieldIdx, int oldType) {
    }

    private void migrateToNote(PilotDBRecord newRec, int newFieldIdx, PilotDBRecord oldRec, int oldFieldIdx, int oldType) throws PalmDbException {
        newRec.setNote(newFieldIdx, String.valueOf(oldRec.getObject(oldFieldIdx)));
        newRec.setNoteTitle(newFieldIdx, String.valueOf(oldRec.getObject(oldFieldIdx)));
    }

    private void migrateToString(PilotDBRecord newRec, int newFieldIdx, PilotDBRecord oldRec, int oldFieldIdx, int oldType) throws PalmDbException {
        newRec.setString(newFieldIdx, String.valueOf(oldRec.getObject(oldFieldIdx)));
    }

    private void migrateToTime(PilotDBRecord newRec, int newFieldIdx, PilotDBRecord oldRec, int oldFieldIdx, int oldType) throws PalmDbException {
    }

    private int oldpos(PilotDBField field, SchemaEditModel sem) {
        return sem.getOriginalPosition(field);
    }

    private boolean newfield(PilotDBField field, SchemaEditModel sem) {
        return sem.getOriginalPosition(field) == -1;
    }

    private boolean moved(PilotDBField field, SchemaEditModel sem) {
        int curpos = sem.indexOf(field);
        int oldpos = sem.getOriginalPosition(field);
        return oldpos != -1 && oldpos != curpos;
    }
}

