/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.command.handler;

import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import javax.swing.JInternalFrame;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBRecord;
import pilotdb.ui.Application;
import pilotdb.ui.UserPreferences;
import pilotdb.ui.command.Command;
import pilotdb.ui.command.handler.AbstractCommandHandler;
import pilotdb.ui.recordsetview.DynamicForm;

public class AddEditRecordHandler
extends AbstractCommandHandler {
    public AddEditRecordHandler(Application bridge) {
        super(bridge);
    }

    public AddEditRecordHandler() {
    }

    public void handle(Command command) {
        if (command.getActionCommand().equals("cmd-show-record")) {
            PilotDBRecord record = (PilotDBRecord)command.getAttachedObject();
            if (record == null) {
                return;
            }
            File f = this.getBridge().getCurrentEnvironment().getFile((PilotDBDatabase)record.getDatabase());
            String frameName = "edit-record-" + f.getName();
            if (this.getBridge().getMainWindow().internalFrameExists(frameName)) {
                JInternalFrame jif = this.getBridge().getMainWindow().getInternalFrame(frameName);
                this.getBridge().getMainWindow().getDesktop().moveToFront(jif);
                DynamicForm dynamicForm = (DynamicForm)jif;
                if (dynamicForm.isEditing()) {
                    return;
                }
                dynamicForm.setRecord(record);
                return;
            }
            DynamicForm dynamicForm = new DynamicForm(this.getBridge());
            dynamicForm.setName(frameName);
            dynamicForm.setRecord(record);
            Rectangle r = this.getBridge().getUserPreferences().getDynamicFormLocation();
            if (r != null && r.x != -1) {
                dynamicForm.setBounds(r);
            }
            dynamicForm.addComponentListener(new ComponentListener(){

                public void componentResized(ComponentEvent arg0) {
                    DynamicForm jif = (DynamicForm)arg0.getSource();
                    UserPreferences up = AddEditRecordHandler.this.getBridge().getUserPreferences();
                    up.setDynamicFormLocation(jif.getBounds());
                    try {
                        Application.savePreferences(up);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public void componentMoved(ComponentEvent arg0) {
                    DynamicForm jif = (DynamicForm)arg0.getSource();
                    UserPreferences up = AddEditRecordHandler.this.getBridge().getUserPreferences();
                    up.setDynamicFormLocation(jif.getBounds());
                    try {
                        Application.savePreferences(up);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public void componentShown(ComponentEvent arg0) {
                }

                public void componentHidden(ComponentEvent arg0) {
                }
            });
        } else if (command.getActionCommand().equals("cmd-edit-record")) {
            PilotDBRecord record = (PilotDBRecord)command.getAttachedObject();
            if (record == null) {
                return;
            }
            File f = this.getBridge().getCurrentEnvironment().getFile((PilotDBDatabase)record.getDatabase());
            String frameName = "edit-record-" + f.getName();
            if (this.getBridge().getMainWindow().internalFrameExists(frameName)) {
                JInternalFrame jif = this.getBridge().getMainWindow().getInternalFrame(frameName);
                this.getBridge().getMainWindow().getDesktop().moveToFront(jif);
                DynamicForm dynamicForm = (DynamicForm)jif;
                if (dynamicForm.isEditing()) {
                    Command c = new Command(this, "cmd-show-error", "The form is already in edit mode.  Save the record first before attempting to edit another record.");
                    this.getBridge().postEvent(c);
                }
                dynamicForm.setRecord(record);
                dynamicForm.edit();
                return;
            }
            Rectangle r = this.getBridge().getUserPreferences().getDynamicFormLocation();
            DynamicForm dynamicForm = new DynamicForm(this.getBridge());
            if (r != null && r.x != -1) {
                dynamicForm.setBounds(r);
            }
            dynamicForm.setName(frameName);
            dynamicForm.setRecord(record);
            dynamicForm.edit();
            dynamicForm.addComponentListener(new ComponentListener(){

                public void componentResized(ComponentEvent arg0) {
                    DynamicForm jif = (DynamicForm)arg0.getSource();
                    UserPreferences up = AddEditRecordHandler.this.getBridge().getUserPreferences();
                    up.setDynamicFormLocation(jif.getBounds());
                    try {
                        Application.savePreferences(up);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public void componentMoved(ComponentEvent arg0) {
                    DynamicForm jif = (DynamicForm)arg0.getSource();
                    UserPreferences up = AddEditRecordHandler.this.getBridge().getUserPreferences();
                    up.setDynamicFormLocation(jif.getBounds());
                    try {
                        Application.savePreferences(up);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public void componentShown(ComponentEvent arg0) {
                }

                public void componentHidden(ComponentEvent arg0) {
                }
            });
        } else if (command.getActionCommand().equals("cmd-add-record")) {
            try {
                PilotDBRecord record = this.getBridge().getSelectedDatabase().createRecord();
                if (record == null) {
                    return;
                }
                String frameName = "edit-record-" + record.getDatabase().getTitle();
                if (this.getBridge().getMainWindow().internalFrameExists(frameName)) {
                    JInternalFrame jif = this.getBridge().getMainWindow().getInternalFrame(frameName);
                    this.getBridge().getMainWindow().getDesktop().moveToFront(jif);
                    DynamicForm dynamicForm = (DynamicForm)jif;
                    if (dynamicForm.isEditing()) {
                        return;
                    }
                    dynamicForm.setRecord(record);
                    dynamicForm.edit();
                    return;
                }
                Rectangle r = this.getBridge().getUserPreferences().getDynamicFormLocation();
                DynamicForm dynamicForm = new DynamicForm(this.getBridge());
                if (r != null && r.x != -1) {
                    dynamicForm.setBounds(r);
                }
                dynamicForm.setName(frameName);
                dynamicForm.setRecord(record);
                dynamicForm.edit();
                dynamicForm.addComponentListener(new ComponentListener(){

                    public void componentResized(ComponentEvent arg0) {
                        DynamicForm jif = (DynamicForm)arg0.getSource();
                        UserPreferences up = AddEditRecordHandler.this.getBridge().getUserPreferences();
                        up.setDynamicFormLocation(jif.getBounds());
                        try {
                            Application.savePreferences(up);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    public void componentMoved(ComponentEvent arg0) {
                        DynamicForm jif = (DynamicForm)arg0.getSource();
                        UserPreferences up = AddEditRecordHandler.this.getBridge().getUserPreferences();
                        up.setDynamicFormLocation(jif.getBounds());
                        try {
                            Application.savePreferences(up);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    public void componentShown(ComponentEvent arg0) {
                    }

                    public void componentHidden(ComponentEvent arg0) {
                    }
                });
            }
            catch (Exception ioe) {
                Command c = new Command(this, "cmd-show-error", ioe);
                this.getBridge().postEvent(c);
            }
        }
        super.handle(command);
    }
}

