/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.command.handler;

import pilotdb.ui.Application;
import pilotdb.ui.command.Command;
import pilotdb.ui.command.handler.CommandHandler;

public abstract class AbstractCommandHandler
implements CommandHandler {
    protected CommandHandler successor;
    protected Application bridge;

    public AbstractCommandHandler(Application bridge) {
        this.bridge = bridge;
    }

    public AbstractCommandHandler() {
    }

    public void setSuccessor(CommandHandler handler) {
        this.successor = handler;
    }

    public void handle(Command evt) {
        if (this.successor != null) {
            this.successor.handle(evt);
        }
    }

    public CommandHandler getSuccessor() {
        return this.successor;
    }

    public boolean isTail() {
        return this.successor == null;
    }

    public void setApplication(Application bridge) {
        this.bridge = bridge;
    }

    public void addToChain(CommandHandler c) {
        CommandHandler ch = this;
        while (ch.getSuccessor() != null) {
            ch = ch.getSuccessor();
        }
        ch.setSuccessor(c);
    }

    public Application getBridge() {
        return this.bridge;
    }
}

