/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui.command.handler;

import javax.swing.JDialog;
import javax.swing.JOptionPane;
import palmdb.VersionInfo;
import pilotdb.ui.Application;
import pilotdb.ui.UserPreferences;
import pilotdb.ui.command.Command;
import pilotdb.ui.command.handler.AbstractCommandHandler;
import pilotdb.ui.util.AboutBoxPanel;
import pilotdb.ui.util.BrowserLauncher;
import pilotdb.ui.util.Feedback;
import pilotdb.ui.util.FeedbackPanel;

public class AboutBoxCommandHandler
extends AbstractCommandHandler {
    public AboutBoxCommandHandler(Application bridge) {
        super(bridge);
    }

    public void handle(Command evt) {
        if (evt.equals("cmd-show-aboutbox")) {
            JOptionPane.showMessageDialog(this.getBridge().getMainComponent(), new AboutBoxPanel(), "About JPilot-DB", -1);
        } else if (evt.equals("cmd-checkforupdates")) {
            VersionInfo current = VersionInfo.instance();
            VersionInfo latest = VersionInfo.latestAvailable();
            if (current == null) {
                JOptionPane.showMessageDialog(this.getBridge().getMainComponent(), "Unable to load local version information.", "Error", 64);
            } else if (latest == null) {
                JOptionPane.showMessageDialog(this.getBridge().getMainComponent(), "Unable to load version information from remote server.", "Error", 64);
            } else if (latest.newerThan(current)) {
                int result = JOptionPane.showConfirmDialog(this.getBridge().getMainComponent(), "You do not have the latest build available (" + current + " < " + latest + ")\nDo you wish to download the newest release\nfrom http://www.chickenshick.com/jpilot-db/download ?", "Download Latest", 0);
                if (result == 0) {
                    try {
                        BrowserLauncher.openURL("http://www.chickenshick.com/jpilot-db/download/");
                    }
                    catch (Exception e) {
                        Command c = new Command(this, "cmd-show-error", e);
                        this.getBridge().postEvent(c);
                    }
                }
            } else {
                JOptionPane.showMessageDialog(this.getBridge().getMainComponent(), "You have the latest build.");
            }
        } else if (evt.equals("cmd-showfeedbackapplet")) {
            UserPreferences up = this.getBridge().getUserPreferences();
            FeedbackPanel fp = new FeedbackPanel();
            String message = (String)evt.getAttachedObject();
            if (message != null) {
                fp.getJtaComments().setText("Automatic Message : \n" + message);
                fp.getJtaComments().moveCaretPosition(0);
                fp.getJcbType().setSelectedItem("Problem");
            }
            fp.getJtfEmail().setText(up.getFeedbackEmail());
            fp.getJtfFirstName().setText(up.getFeedbackFirstName());
            fp.getJtfLastName().setText(up.getFeedbackLastName());
            JOptionPane jop = new JOptionPane(fp, -1, 2);
            JDialog jd = jop.createDialog(this.getBridge().getMainWindow(), "Feedback");
            jd.setModal(true);
            jd.setVisible(true);
            if (jop.getValue() == null) {
                return;
            }
            Integer value = (Integer)jop.getValue();
            if (value == 0) {
                final Feedback fb = fp.getUserFeedback();
                up.setFeedbackFirstName(fb.getFirstName());
                up.setFeedbackLastName(fb.getLastName());
                up.setFeedbackEmail(fb.getEmail());
                try {
                    Application.savePreferences(up);
                }
                catch (Exception e) {
                    Command c = new Command(this, "cmd-log-exception", e);
                    this.getBridge().postEvent(c);
                }
                Runnable r = new Runnable(){

                    public void run() {
                        try {
                            String output = fb.send();
                            JOptionPane.showMessageDialog(AboutBoxCommandHandler.this.getBridge().getMainWindow(), "<html><body><b>" + output, "Feedback Received", 1);
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(AboutBoxCommandHandler.this.getBridge().getMainWindow(), "An error occured : " + e, "Error", 0);
                        }
                    }
                };
                Thread t = new Thread(r);
                t.start();
            }
        }
        super.handle(evt);
    }
}

