/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui;

import java.awt.Font;
import java.awt.Rectangle;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import palmdb.PalmPreferences;
import pilotdb.ui.util.Style;
import pilotdb.ui.util.StyleSheet;

public class UserPreferences {
    private File preferencesFile = null;
    private Font defaultFont = new Font("Dialog", 0, 11);
    private File defaultWorkingDirectory = new File(System.getProperty("user.home"));
    private String logLevel = "debug";
    private String logType = "file";
    private String logFile;
    private String lastPath = null;
    private String lookAndFeelClassName = "javax.swing.plaf.metal.MetalLookAndFeel";
    private String installArgs = null;
    private Map dbprefs = new HashMap();
    private String feedbackFirstName;
    private String feedbackLastName;
    private String feedbackEmail;
    private String installExecutablePath = null;
    private boolean installOnCommit = false;
    private Rectangle applicationWindowLocation = null;
    private Rectangle databaseListLocation = null;
    private Rectangle recordsListLocation = null;
    private Rectangle dynamicFormLocation = null;
    public static final String[] LOG_TYPES = new String[]{"file", "console"};
    public static final String[] LOG_LEVELS = new String[]{"debug", "info", "warn"};

    public String getFeedbackEmail() {
        return this.feedbackEmail;
    }

    public void setFeedbackEmail(String feedbackEmail) {
        this.feedbackEmail = feedbackEmail;
    }

    public String getFeedbackFirstName() {
        return this.feedbackFirstName;
    }

    public void setFeedbackFirstName(String feedbackFirstName) {
        this.feedbackFirstName = feedbackFirstName;
    }

    public String getFeedbackLastName() {
        return this.feedbackLastName;
    }

    public void setFeedbackLastName(String feedBackLastName) {
        this.feedbackLastName = feedBackLastName;
    }

    public String getInstallArgs() {
        return this.installArgs;
    }

    public void setInstallArgs(String installArgs) {
        this.installArgs = installArgs;
    }

    public UserPreferences() {
        File userHome = new File(System.getProperty("user.home"));
        File logF = new File(userHome, "pilot-db.log");
        this.logFile = logF.getAbsolutePath();
    }

    private Rectangle readRectangle(Style style) {
        int x = style.getValue("x", -1);
        int y = style.getValue("y", -1);
        int height = style.getValue("height", -1);
        int width = style.getValue("width", -1);
        Rectangle r = new Rectangle(x, y, width, height);
        return r;
    }

    private void writeRectangle(Style style, Rectangle r) {
        style.addValue("x", r.x);
        style.addValue("y", r.y);
        style.addValue("width", r.width);
        style.addValue("height", r.height);
    }

    private Font readFont(Style style) {
        String name = style.getValue("name", "Dialog");
        int size = style.getValue("size", 11);
        String[] choices = new String[]{"normal", "bold"};
        int[] nArray = new int[2];
        nArray[1] = 1;
        int[] values = nArray;
        int fontStyle = values[style.getValue("style", choices, 0)];
        return new Font(name, fontStyle, size);
    }

    public void setDefaultWorkingDirectory(File f) {
        if (f.exists() && f.canRead()) {
            this.defaultWorkingDirectory = f;
        }
    }

    public File getDefaultWorkingDirectory() {
        return this.defaultWorkingDirectory;
    }

    public void loadFrom(StyleSheet ss) {
        Style feedback;
        Style s;
        Style formats;
        Style style = ss.getStyleById("defaultFont");
        this.setDefaultFont(this.readFont(style));
        Style laf = ss.getStyleById("lookandfeel");
        this.setLookAndFeelClassName(laf.getValue("classname", this.lookAndFeelClassName));
        Style executables = ss.getStyleById("executables");
        this.installExecutablePath = executables.getValue("install-executable-path", null);
        this.installArgs = executables.getValue("install-args", "{0}");
        this.installOnCommit = executables.getValue("install-on-commit", false);
        Style rect = ss.getStyleById("app-window-location");
        this.applicationWindowLocation = this.readRectangle(rect);
        rect = ss.getStyleById("db-window-location");
        this.databaseListLocation = this.readRectangle(rect);
        rect = ss.getStyleById("record-window-location");
        this.recordsListLocation = this.readRectangle(rect);
        rect = ss.getStyleById("dynamic-window-location");
        this.dynamicFormLocation = this.readRectangle(rect);
        Style basic_prefs = ss.getStyleById("basic");
        this.setDefaultWorkingDirectory(new File(basic_prefs.getValue("defaultWorkingDirectory", new File(System.getProperty("user.home")).getAbsolutePath())));
        this.setLastPath(basic_prefs.getValue("lastPath", this.defaultWorkingDirectory.getAbsolutePath()));
        Style logStyle = ss.getStyleById("log");
        if (logStyle != null) {
            this.logLevel = logStyle.getValue("level", "debug");
            this.logType = logStyle.getValue("type", "file");
            File userHome = new File(System.getProperty("user.home"));
            File logF = new File(userHome, "pilot-db.log");
            this.logFile = logStyle.getValue("file", logF.getAbsolutePath());
        }
        if ((formats = ss.getStyleById("formats")) != null) {
            PalmPreferences pp = PalmPreferences.getInstance();
            String defaultPalmDateFormat = pp.getPalmDateFormat().getPalmDateFormat();
            String palmDateFormat = formats.getValue("date", defaultPalmDateFormat);
            PalmPreferences.getInstance().setPalmDateFormat(palmDateFormat);
            String defaultPalmTimeFormat = pp.getPalmTimeFormat().getPalmTimeFormat();
            String palmTimeFormat = formats.getValue("time", defaultPalmTimeFormat);
            PalmPreferences.getInstance().setPalmTimeFormat(palmTimeFormat);
        }
        if ((s = ss.getStyleById("dbpref.names")) != null) {
            String names = s.getValue("names", "");
            StringTokenizer st = new StringTokenizer(names, ",");
            while (st.hasMoreTokens()) {
                String name = st.nextToken();
                DbPrefs pref = new DbPrefs();
                pref.dbname = name;
                Style dbprefstyle = ss.getStyleById(String.valueOf(name) + ".prefs");
                if (dbprefstyle == null) continue;
                int count = dbprefstyle.getValue("column-count", 0);
                int i = 0;
                while (i < count) {
                    Column c = new Column();
                    c.name = dbprefstyle.getValue("column" + i + "name", "__DEFAULT__");
                    c.width = dbprefstyle.getValue("column" + i + "width", 100);
                    pref.addColumn(c);
                    ++i;
                }
                this.setDatabasePrefs(pref);
            }
        }
        if ((feedback = ss.getStyleById("feedback")) != null) {
            this.feedbackFirstName = feedback.getValue("first-name", null);
            this.feedbackLastName = feedback.getValue("last-name", null);
            this.feedbackEmail = feedback.getValue("email", null);
        }
    }

    public void saveTo(StyleSheet ss) {
        Style s = new Style();
        s.setId("defaultFont");
        s.addValue("name", this.defaultFont.getName());
        s.addValue("size", String.valueOf(this.defaultFont.getSize()));
        int fontStyle = this.defaultFont.getStyle();
        s.addValue("style", fontStyle == 1 ? "bold" : "normal");
        ss.registerStyle(s);
        s = new Style();
        s.setId("executables");
        s.addValue("install-executable-path", this.installExecutablePath);
        s.addValue("install-args", this.installArgs);
        s.addValue("install-on-commit", this.installOnCommit);
        ss.registerStyle(s);
        s = new Style();
        s.setId("lookandfeel");
        s.addValue("classname", this.lookAndFeelClassName);
        ss.registerStyle(s);
        s = new Style();
        s.setId("log");
        s.addValue("level", this.logLevel);
        s.addValue("type", this.logType);
        s.addValue("file", this.logFile);
        ss.registerStyle(s);
        s = new Style();
        s.setId("feedback");
        s.addValue("first-name", this.feedbackFirstName);
        s.addValue("last-name", this.feedbackLastName);
        s.addValue("email", this.feedbackEmail);
        ss.registerStyle(s);
        s = new Style();
        s.setId("basic");
        s.addValue("defaultWorkingDirectory", this.defaultWorkingDirectory.getAbsolutePath());
        s.addValue("lastPath", this.lastPath);
        ss.registerStyle(s);
        if (this.applicationWindowLocation != null) {
            s = new Style();
            s.setId("app-window-location");
            this.writeRectangle(s, this.applicationWindowLocation);
            ss.registerStyle(s);
        }
        if (this.databaseListLocation != null) {
            s = new Style();
            s.setId("db-window-location");
            this.writeRectangle(s, this.databaseListLocation);
            ss.registerStyle(s);
        }
        if (this.recordsListLocation != null) {
            s = new Style();
            s.setId("record-window-location");
            this.writeRectangle(s, this.recordsListLocation);
            ss.registerStyle(s);
        }
        if (this.dynamicFormLocation != null) {
            s = new Style();
            s.setId("dynamic-window-location");
            this.writeRectangle(s, this.dynamicFormLocation);
            ss.registerStyle(s);
        }
        PalmPreferences pp = PalmPreferences.getInstance();
        s = new Style();
        s.setId("formats");
        s.addValue("date", pp.getPalmDateFormat().getPalmDateFormat());
        s.addValue("time", pp.getPalmTimeFormat().getPalmTimeFormat());
        ss.registerStyle(s);
        Iterator dbprefkeys = this.dbprefs.keySet().iterator();
        s = new Style();
        s.setId("dbpref.names");
        StringBuffer sb = new StringBuffer();
        while (dbprefkeys.hasNext()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(dbprefkeys.next());
        }
        s.addValue("names", sb.toString());
        ss.registerStyle(s);
        Iterator dbprefss = this.dbprefs.values().iterator();
        while (dbprefss.hasNext()) {
            DbPrefs dbp = (DbPrefs)dbprefss.next();
            s = new Style();
            s.setId(String.valueOf(dbp.dbname) + ".prefs");
            s.addValue("column-count", dbp.cols.size());
            int i = 0;
            while (i < dbp.cols.size()) {
                s.addValue("column" + i + "name", ((Column)dbp.cols.get((int)i)).name);
                s.addValue("column" + i + "width", ((Column)dbp.cols.get((int)i)).width);
                ++i;
            }
            ss.registerStyle(s);
        }
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(Font defaultFont) {
        this.defaultFont = defaultFont;
    }

    public File getPreferencesFile() {
        return this.preferencesFile;
    }

    public void setPreferencesFile(File preferencesFile) {
        this.preferencesFile = preferencesFile;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public String getLogType() {
        return this.logType;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public void setLogType(String string) {
        this.logType = string;
    }

    public String getLastPath() {
        return this.lastPath;
    }

    public void setLastPath(String lastPath) {
        this.lastPath = lastPath;
    }

    public String getLookAndFeelClassName() {
        return this.lookAndFeelClassName;
    }

    public void setLookAndFeelClassName(String lookAndFeelClassName) {
        this.lookAndFeelClassName = lookAndFeelClassName;
    }

    public Rectangle getApplicationWindowLocation() {
        return this.applicationWindowLocation;
    }

    public Rectangle getDatabaseListLocation() {
        return this.databaseListLocation;
    }

    public Rectangle getDynamicFormLocation() {
        return this.dynamicFormLocation;
    }

    public Rectangle getRecordsListLocation() {
        return this.recordsListLocation;
    }

    public void setApplicationWindowLocation(Rectangle rectangle) {
        this.applicationWindowLocation = rectangle;
    }

    public void setDatabaseListLocation(Rectangle rectangle) {
        this.databaseListLocation = rectangle;
    }

    public void setDynamicFormLocation(Rectangle rectangle) {
        this.dynamicFormLocation = rectangle;
    }

    public void setRecordsListLocation(Rectangle rectangle) {
        this.recordsListLocation = rectangle;
    }

    public String getInstallExecutablePath() {
        return this.installExecutablePath;
    }

    public void setInstallExecutablePath(String string) {
        this.installExecutablePath = string;
    }

    public boolean isInstallOnCommit() {
        return this.installOnCommit;
    }

    public void setInstallOnCommit(boolean b) {
        this.installOnCommit = b;
    }

    public void setDatabasePrefs(DbPrefs db) {
        this.dbprefs.put(db.dbname, db);
    }

    public DbPrefs getDatabasePrefs(String name) {
        return (DbPrefs)this.dbprefs.get(name);
    }

    public static class DbPrefs {
        public String dbname;
        List cols = new LinkedList();

        public void addColumn(Column c) {
            this.cols.add(c);
        }

        public Column getColumn(String name) {
            int i = 0;
            while (i < this.cols.size()) {
                Column c = (Column)this.cols.get(i);
                if (c.name.equals(name)) {
                    return c;
                }
                ++i;
            }
            return null;
        }
    }

    public static class Column {
        public String name;
        public int width;
    }
}

