/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import palmdb.PalmPreferences;
import pilotdb.ui.Application;
import pilotdb.ui.Messages;
import pilotdb.ui.UserPreferences;
import pilotdb.ui.command.Command;
import pilotdb.ui.images.Images;
import pilotdb.ui.util.FlatJButton;
import pilotdb.ui.util.UIBanner;

public class PreferencesPanel
extends JPanel
implements ActionListener,
ItemListener {
    public static final int RESPONSE_OK = 0;
    public static final int RESPONSE_CANCEL = 1;
    private transient Vector actionListeners;
    JButton jbOk;
    JButton jbCancel;
    JButton jbWorkingDirectory;
    JButton jbLogFile;
    JButton jbHelp;
    JButton jbInstallPath;
    JComboBox jcbFontFace;
    JComboBox jcbFontSize;
    JComboBox jcbLogType;
    JComboBox jcbLogLevel;
    JComboBox jcbLookAndFeel;
    JComboBox jcbDateFormat;
    JComboBox jcbTimeFormat;
    JLabel jlWorkingDirectory;
    JLabel jlDefaultFont;
    JLabel jlFontFace;
    JLabel jlFontSize;
    JLabel jlLogging;
    JLabel jlLogType;
    JLabel jlLogLevel;
    JLabel jlLogFile;
    JLabel jlLookAndFeel;
    JLabel jlFormats;
    JLabel jlDateFormat;
    JLabel jlTimeFormat;
    JLabel jlInstallPath;
    JLabel jlInstallArgs;
    JTextField jtfWorkingDirectory;
    JTextField jtfLogFile;
    JTextField jtfInstallPath;
    JTextField jtfInstallArgs;
    JCheckBox jchkInstallOnCommit;
    Application application = null;

    public PreferencesPanel(Application app) {
        this.application = app;
        this.uiInit();
    }

    private void uiInit() {
        this.jlDefaultFont = new JLabel();
        this.jlFontFace = new JLabel();
        this.jlFontSize = new JLabel();
        this.jlWorkingDirectory = new JLabel();
        this.jlLogFile = new JLabel();
        this.jlLogLevel = new JLabel();
        this.jlLogType = new JLabel();
        this.jlLogging = new JLabel();
        this.jlLookAndFeel = new JLabel();
        this.jlDateFormat = new JLabel();
        this.jlTimeFormat = new JLabel();
        this.jlFormats = new JLabel();
        this.jlInstallPath = new JLabel();
        this.jlInstallArgs = new JLabel();
        this.jchkInstallOnCommit = new JCheckBox(Messages.getString("PreferencesPanel.InstallOnCommit"));
        this.jlDefaultFont.setText(Messages.getString("PreferencesPanel.DefaultFont"));
        this.jlFontFace.setText(Messages.getString("PreferencesPanel.Family"));
        this.jlFontSize.setText(Messages.getString("PreferencesPanel.Size"));
        this.jlWorkingDirectory.setText(Messages.getString("PreferencesPanel.WorkingDirectory"));
        this.jlLookAndFeel.setText(Messages.getString("PreferencesPanel.LookAndFeel"));
        this.jlFormats.setText(Messages.getString("PreferencesPanel.Formats"));
        this.jlInstallPath.setText(Messages.getString("PreferencesPanel.InstallExecutable"));
        this.jlInstallArgs.setText(Messages.getString("PreferencesPanel.InstallArgs"));
        this.jlLogging.setText(Messages.getString("PreferencesPanel.Logging"));
        this.jlLogFile.setText(Messages.getString("PreferencesPanel.LogFile"));
        this.jlLogLevel.setText(Messages.getString("PreferencesPanel.LogLevel"));
        this.jlLogType.setText(Messages.getString("PreferencesPanel.LogType"));
        this.jlDateFormat.setText(Messages.getString("PreferencesPanel.DateFormat"));
        this.jlTimeFormat.setText(Messages.getString("PreferencesPanel.TimeFormat"));
        this.jchkInstallOnCommit.setSelectedIcon(Images.CHECKBOX_CHECKED_ICON);
        this.jchkInstallOnCommit.setIcon(Images.CHECKBOX_UNCHECKED_ICON);
        this.jtfLogFile = new JTextField();
        this.jtfLogFile.setEnabled(false);
        this.jtfWorkingDirectory = new JTextField();
        this.jtfWorkingDirectory.setEnabled(false);
        this.jtfInstallPath = new JTextField();
        this.jtfInstallPath.setEnabled(false);
        this.jtfInstallArgs = new JTextField();
        this.jtfInstallArgs.setEnabled(true);
        Vector<String> lafs = new Vector<String>();
        int i = 0;
        while (i < UIManager.getInstalledLookAndFeels().length) {
            lafs.add(UIManager.getInstalledLookAndFeels()[i].getName());
            ++i;
        }
        this.jcbLookAndFeel = new JComboBox(lafs);
        this.jcbLookAndFeel.setSelectedItem(UIManager.getLookAndFeel().getName());
        try {
            String[] fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            this.jcbFontFace = new JComboBox<String>(fontList);
            Integer[] fontSizes = new Integer[]{new Integer(8), new Integer(9), new Integer(10), new Integer(11), new Integer(12), new Integer(13), new Integer(14)};
            this.jcbFontSize = new JComboBox<Integer>(fontSizes);
        }
        catch (Exception e) {
            this.jcbFontFace = new JComboBox<String>(new String[]{"Dialog"});
            this.jcbFontSize = new JComboBox<Integer>(new Integer[]{new Integer(10)});
        }
        this.jcbLogLevel = new JComboBox<String>(UserPreferences.LOG_LEVELS);
        this.jcbLogType = new JComboBox<String>(UserPreferences.LOG_TYPES);
        this.jcbDateFormat = new JComboBox<PalmPreferences.PalmDateFormat>(PalmPreferences.PALM_DATE_FORMATS);
        this.jcbTimeFormat = new JComboBox<PalmPreferences.PalmTimeFormat>(PalmPreferences.PALM_TIME_FORMATS);
        this.jcbLogType.addItemListener(this);
        this.jbOk = new FlatJButton();
        this.jbCancel = new FlatJButton();
        this.jbWorkingDirectory = new FlatJButton();
        this.jbLogFile = new FlatJButton();
        this.jbInstallPath = new FlatJButton();
        this.jbInstallPath.addActionListener(this);
        try {
            this.jbHelp = new FlatJButton();
            CSH.setHelpIDString((Component)this.jbHelp, (String)"prefs");
            this.jbHelp.setIcon(Images.QUESTION_ICON);
            this.jbHelp.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(this.application.getHelpBroker()));
            this.jbHelp.setText(Messages.getString("PreferencesPanel.Help"));
            this.jbHelp.setBounds(60, 355, 75, 25);
        }
        catch (Throwable t) {
            this.jbHelp = null;
        }
        this.jbOk.addActionListener(this);
        this.jbCancel.addActionListener(this);
        this.jbWorkingDirectory.addActionListener(this);
        this.jbLogFile.addActionListener(this);
        this.jbLogFile.setIcon(Images.OPEN_ICON);
        this.jbOk.setIcon(Images.OK_ICON);
        this.jbCancel.setIcon(Images.CANCEL_ICON);
        this.jbWorkingDirectory.setIcon(Images.OPEN_ICON);
        this.jbInstallPath.setIcon(Images.OPEN_ICON);
        this.jbOk.setText(Messages.getString("PreferencesPanel.OK"));
        this.jbCancel.setText(Messages.getString("PreferencesPanel.Cancel"));
        UIBanner banner = new UIBanner(Messages.getString("PreferencesPanel.Preferences"), 550, null);
        this.jtfWorkingDirectory.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jtfInstallPath.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jtfInstallArgs.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jtfLogFile.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jcbFontFace.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jcbFontSize.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jcbLogLevel.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jcbLogType.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jlLookAndFeel.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jlFormats.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jlInstallPath.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jlInstallArgs.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jcbLookAndFeel.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jcbDateFormat.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jcbTimeFormat.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jlDefaultFont.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jlWorkingDirectory.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.jlLogging.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.setLayout(null);
        if (this.jbHelp != null) {
            this.add(this.jbHelp);
        }
        this.add(banner);
        this.add(this.jlLookAndFeel);
        this.add(this.jcbLookAndFeel);
        this.add(this.jbLogFile);
        this.add(this.jbOk);
        this.add(this.jbCancel);
        this.add(this.jbWorkingDirectory);
        this.add(this.jlLogFile);
        this.add(this.jlLogging);
        this.add(this.jlLogLevel);
        this.add(this.jlLogType);
        this.add(this.jlDefaultFont);
        this.add(this.jlFontFace);
        this.add(this.jlFontSize);
        this.add(this.jlDateFormat);
        this.add(this.jlTimeFormat);
        this.add(this.jlFormats);
        this.add(this.jcbDateFormat);
        this.add(this.jcbTimeFormat);
        this.add(this.jlWorkingDirectory);
        this.add(this.jtfWorkingDirectory);
        this.add(this.jtfLogFile);
        this.add(this.jlInstallPath);
        this.add(this.jtfInstallPath);
        this.add(this.jbInstallPath);
        this.add(this.jcbFontFace);
        this.add(this.jcbFontSize);
        this.add(this.jcbLogLevel);
        this.add(this.jcbLogType);
        this.add(this.jchkInstallOnCommit);
        this.add(this.jlInstallArgs);
        this.add(this.jtfInstallArgs);
        this.jlDefaultFont.setBounds(5, 5, 290, 20);
        this.jlInstallPath.setBounds(300, 5, 290, 20);
        this.jlFontFace.setBounds(15, 30, 50, 20);
        this.jcbFontFace.setBounds(65, 30, 125, 20);
        this.jtfInstallPath.setBounds(310, 30, 250, 20);
        this.jbInstallPath.setBounds(565, 30, 20, 20);
        this.jlFontSize.setBounds(205, 30, 35, 20);
        this.jcbFontSize.setBounds(240, 30, 50, 20);
        this.jlWorkingDirectory.setBounds(5, 70, 290, 20);
        this.jlInstallArgs.setBounds(300, 70, 290, 20);
        this.jtfWorkingDirectory.setBounds(15, 95, 250, 20);
        this.jtfInstallArgs.setBounds(310, 95, 250, 20);
        this.jbWorkingDirectory.setBounds(270, 95, 20, 20);
        this.jlLogging.setBounds(5, 135, 290, 20);
        this.jchkInstallOnCommit.setBounds(310, 135, 290, 20);
        this.jlLogType.setBounds(15, 160, 50, 20);
        this.jcbLogType.setBounds(65, 160, 85, 20);
        this.jlLogLevel.setBounds(160, 160, 50, 20);
        this.jcbLogLevel.setBounds(205, 160, 85, 20);
        this.jlLogFile.setBounds(15, 185, 40, 20);
        this.jtfLogFile.setBounds(65, 185, 200, 20);
        this.jbLogFile.setBounds(270, 185, 20, 20);
        this.jlLookAndFeel.setBounds(5, 225, 290, 20);
        this.jcbLookAndFeel.setBounds(15, 250, 275, 20);
        this.jlFormats.setBounds(5, 290, 290, 20);
        this.jlDateFormat.setBounds(15, 315, 50, 20);
        this.jcbDateFormat.setBounds(65, 315, 65, 20);
        this.jlTimeFormat.setBounds(140, 315, 40, 20);
        this.jcbTimeFormat.setBounds(180, 315, 100, 20);
        this.jcbTimeFormat.setLightWeightPopupEnabled(false);
        this.jcbDateFormat.setLightWeightPopupEnabled(false);
        this.jbOk.setBounds(140, 355, 75, 25);
        this.jbCancel.setBounds(220, 355, 75, 25);
        this.setPreferredSize(new Dimension(610, 390));
        this.jcbLogType.setSelectedItem(this.application.getUserPreferences().getLogType());
        this.jcbLogLevel.setSelectedItem(this.application.getUserPreferences().getLogLevel());
        this.jtfLogFile.setText(this.application.getUserPreferences().getLogFile());
        this.jcbFontFace.setSelectedItem(this.application.getUserPreferences().getDefaultFont().getName());
        this.jcbFontSize.setSelectedItem(new Integer(this.application.getUserPreferences().getDefaultFont().getSize()));
        this.jtfWorkingDirectory.setText(this.application.getUserPreferences().getDefaultWorkingDirectory().getAbsolutePath());
        this.jcbDateFormat.setSelectedItem(PalmPreferences.getInstance().getPalmDateFormat());
        this.jcbTimeFormat.setSelectedItem(PalmPreferences.getInstance().getPalmTimeFormat());
        this.jtfInstallPath.setText(this.application.getUserPreferences().getInstallExecutablePath());
        this.jtfInstallArgs.setText(this.application.getUserPreferences().getInstallArgs());
        this.jchkInstallOnCommit.setSelected(this.application.getUserPreferences().isInstallOnCommit());
    }

    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.jbCancel) {
            this.onCancel(ae);
        } else if (source == this.jbOk) {
            this.onOk(ae);
        } else if (source == this.jbWorkingDirectory) {
            this.onWorkingDirectory();
        } else if (source == this.jbLogFile) {
            this.onLogFile();
        } else if (source == this.jbInstallPath) {
            this.onInstallPath();
        }
    }

    void onWorkingDirectory() {
        JFileChooser chooser = new JFileChooser();
        chooser.setApproveButtonText(Messages.getString("PreferencesPanel.Select"));
        chooser.setDialogTitle(Messages.getString("PreferencesPanel.SelectADirectory"));
        chooser.setFileHidingEnabled(false);
        chooser.setFileSelectionMode(1);
        int val = chooser.showOpenDialog(this);
        if (val == 0) {
            File f = chooser.getSelectedFile();
            if (f.isDirectory() && f.canRead() && f.canWrite()) {
                this.jtfWorkingDirectory.setText(f.getAbsolutePath());
            } else {
                Command c = new Command(this, "cmd-show-error", Messages.getString("PreferencesPanel.UnableToUseDirectory"));
                this.application.postEvent(c);
            }
        }
    }

    void onInstallPath() {
        JFileChooser chooser = new JFileChooser();
        chooser.setApproveButtonText(Messages.getString("PreferencesPanel.Select"));
        chooser.setDialogTitle(Messages.getString("PreferencesPanel.SelectThePalmInstaller"));
        chooser.setFileHidingEnabled(false);
        chooser.setFileSelectionMode(0);
        int val = chooser.showOpenDialog(this);
        chooser.setApproveButtonText(Messages.getString("PreferencesPanel.Select"));
        if (val == 0) {
            File f = chooser.getSelectedFile();
            this.jtfInstallPath.setText(f.getAbsolutePath());
        }
    }

    void onLogFile() {
        JFileChooser chooser = new JFileChooser();
        chooser.setApproveButtonText(Messages.getString("PreferencesPanel.Select"));
        chooser.setDialogTitle(Messages.getString("PreferencesPanel.SelectALogFile"));
        chooser.setFileHidingEnabled(false);
        chooser.setFileSelectionMode(0);
        int val = chooser.showSaveDialog(this);
        if (val == 0) {
            File f = chooser.getSelectedFile();
            this.jtfLogFile.setText(f.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCancel(ActionEvent evt) {
        if (this.actionListeners != null) {
            Vector vector = this.actionListeners;
            synchronized (vector) {
                int i = 0;
                while (i < this.actionListeners.size()) {
                    ActionListener al = (ActionListener)this.actionListeners.get(i);
                    ActionEvent ae = new ActionEvent(this, 1, Messages.getString("PreferencesPanel.Cancel"));
                    al.actionPerformed(ae);
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onOk(ActionEvent evt) {
        try {
            UserPreferences up = this.application.getUserPreferences();
            String fontFamily = this.jcbFontFace.getSelectedItem().toString();
            int fontSize = (Integer)this.jcbFontSize.getSelectedItem();
            String wd = this.jtfWorkingDirectory.getText();
            up.setDefaultWorkingDirectory(new File(wd));
            up.setDefaultFont(new Font(fontFamily, 0, fontSize));
            up.setLogFile(this.jtfLogFile.getText());
            up.setLogLevel((String)this.jcbLogLevel.getSelectedItem());
            up.setLogType((String)this.jcbLogType.getSelectedItem());
            up.setInstallExecutablePath(this.jtfInstallPath.getText());
            up.setInstallArgs(this.jtfInstallArgs.getText());
            up.setInstallOnCommit(this.jchkInstallOnCommit.isSelected());
            int selectedLafIndex = this.jcbLookAndFeel.getSelectedIndex();
            String lafClass = UIManager.getInstalledLookAndFeels()[selectedLafIndex].getClassName();
            up.setLookAndFeelClassName(lafClass);
            PalmPreferences pp = PalmPreferences.getInstance();
            pp.setPalmDateFormat(this.jcbDateFormat.getSelectedItem().toString());
            pp.setPalmTimeFormat(this.jcbTimeFormat.getSelectedItem().toString());
            Application.savePreferences(this.application.getUserPreferences());
            Command c = new Command(this, "cmd-show-msg", Messages.getString("PreferencesPanel.TakeEffectUponRestarting"));
            this.application.postEvent(c);
        }
        catch (Exception e) {
            Command c = new Command(this, "cmd-log-exception", e);
            Command c2 = new Command(this, "cmd-show-error", String.valueOf(Messages.getString("PreferencesPanel.UnableToSavePrefs")) + e.getMessage() + "]");
            this.application.postEvent(c);
            this.application.postEvent(c2);
        }
        if (this.actionListeners != null) {
            Vector vector = this.actionListeners;
            synchronized (vector) {
                int i = 0;
                while (i < this.actionListeners.size()) {
                    ActionListener al = (ActionListener)this.actionListeners.get(i);
                    ActionEvent ae = new ActionEvent(this, 0, Messages.getString("PreferencesPanel.OK"));
                    al.actionPerformed(ae);
                    ++i;
                }
            }
        }
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (this.actionListeners != null && this.actionListeners.contains(l)) {
            Vector v = (Vector)this.actionListeners.clone();
            v.removeElement(l);
            this.actionListeners = v;
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        Vector v;
        Vector vector = v = this.actionListeners == null ? new Vector(2) : (Vector)this.actionListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.actionListeners = v;
        }
    }

    public void itemStateChanged(ItemEvent arg0) {
        String logType = (String)arg0.getItem();
        if (logType.equalsIgnoreCase("file")) {
            this.jbLogFile.setEnabled(true);
        } else {
            this.jbLogFile.setEnabled(false);
        }
    }
}

