/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.CompoundBorder;
import pilotdb.PilotDBDatabase;
import pilotdb.tools.PluginMonitor;
import pilotdb.ui.Application;
import pilotdb.ui.MainMenuBar;
import pilotdb.ui.MainToolBar;
import pilotdb.ui.Messages;
import pilotdb.ui.UserPreferences;
import pilotdb.ui.command.Command;
import pilotdb.ui.command.handler.CommandHandler;
import pilotdb.ui.databaselist.DatabaseList;
import pilotdb.ui.util.BGJDesktopPane;

public class MainWindow
extends JFrame
implements CommandHandler,
PluginMonitor {
    CommandHandler successor = null;
    BGJDesktopPane desktop = new BGJDesktopPane();
    MainMenuBar menuBar = new MainMenuBar();
    MainToolBar toolBar = new MainToolBar();
    DatabaseList databaseList = new DatabaseList();
    Application bridge = null;
    JPanel southernpanel = new JPanel();
    JLabel jlStatusRight = new JLabel();
    JLabel jlStatusCenter = new JLabel();
    JProgressBar jlStatusLeft = new JProgressBar();
    BorderLayout borderLayout1 = new BorderLayout();
    static /* synthetic */ Class class$0;

    public MainWindow() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DatabaseList getDatabaseListFrame() {
        return this.databaseList;
    }

    public JInternalFrame getInternalFrame(String frameName) {
        JInternalFrame[] jifs = this.desktop.getAllFrames();
        int i = 0;
        while (i < jifs.length) {
            if (jifs[i].getName() != null && jifs[i].getName().equals(frameName)) {
                return jifs[i];
            }
            ++i;
        }
        return null;
    }

    public boolean internalFrameExists(String frameName) {
        JInternalFrame[] jifs = this.desktop.getAllFrames();
        int i = 0;
        while (i < jifs.length) {
            if (jifs[i].getName() != null && jifs[i].getName().equals(frameName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setApplication(Application a) {
        this.bridge = a;
        this.databaseList.setApplication(a);
        this.menuBar.setApplication(a);
        this.toolBar.setApplication(a);
    }

    public Application getBridge() {
        return this.bridge;
    }

    public JDesktopPane getDesktop() {
        return this.desktop;
    }

    private void jbInit() throws Exception {
        this.setTitle(Messages.getString("MainWindow.AppName"));
        this.setJMenuBar(this.menuBar);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("pilotdb.ui.images.Images");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setIconImage(toolkit.getImage(clazz.getResource(Messages.getString("MainWindow.WindowIcon"))));
        this.desktop.setDragMode(1);
        this.desktop.setBackground(SystemColor.inactiveCaption);
        CompoundBorder b = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createLineBorder(Color.lightGray));
        this.desktop.add(this.databaseList);
        this.jlStatusRight.setBorder(b);
        this.jlStatusRight.setPreferredSize(new Dimension(200, 25));
        this.jlStatusRight.setText(Messages.getString("MainWindow.Environment"));
        this.jlStatusCenter.setBorder(b);
        this.jlStatusCenter.setText(Messages.getString("MainWindow.Modified"));
        this.jlStatusLeft.setBorder(b);
        this.jlStatusLeft.setPreferredSize(new Dimension(300, 25));
        this.jlStatusLeft.setStringPainted(true);
        this.jlStatusLeft.setAlignmentX(2.0f);
        this.southernpanel.setLayout(this.borderLayout1);
        this.desktop.setPreferredSize(new Dimension(10, 10));
        JPanel toolBarPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.getContentPane().add((Component)toolBarPanel, "North");
        toolBarPanel.add(this.toolBar);
        this.getContentPane().add((Component)this.desktop, "Center");
        this.getContentPane().add((Component)this.southernpanel, "South");
        this.southernpanel.add((Component)this.jlStatusLeft, "West");
        this.southernpanel.add((Component)this.jlStatusCenter, "Center");
        this.southernpanel.add((Component)this.jlStatusRight, "East");
    }

    public PilotDBDatabase[] getSelectedDatabases() {
        return this.databaseList.getSelectedDatabases();
    }

    public void handle(Command evt) {
        if (evt.equals("cmd-show-status")) {
            this.jlStatusLeft.setString(evt.getAttachedObject().toString());
        } else if (evt.equals("cmd-view-statusbar")) {
            Boolean val = (Boolean)evt.getAttachedObject();
            this.southernpanel.setVisible(val);
        } else if (evt.equals("cmd-view-toolbar")) {
            Boolean val = (Boolean)evt.getAttachedObject();
            this.toolBar.setVisible(val);
        } else if (evt.equals("msg-selected-database")) {
            PilotDBDatabase db = (PilotDBDatabase)evt.getAttachedObject();
            this.jlStatusCenter.setText(String.valueOf(Messages.getString("MainWindow.SelectedDatabase")) + " : " + db.getTitle());
        } else if (evt.equals("msg-opened-directory")) {
            File f = (File)evt.getAttachedObject();
            this.jlStatusRight.setText(f.getAbsolutePath());
            this.setTitle(String.valueOf(Messages.getString("MainWindow.AppName")) + " - " + f.getAbsolutePath());
        }
        if (this.successor != null) {
            this.successor.handle(evt);
        }
    }

    public void setSuccessor(CommandHandler handler) {
        this.successor = handler;
    }

    public CommandHandler getSuccessor() {
        return this.successor;
    }

    public boolean isTail() {
        return this.successor == null;
    }

    public void addToChain(CommandHandler handler) {
        if (this.successor == null) {
            this.successor = handler;
        } else {
            this.successor.addToChain(handler);
        }
    }

    public void start() {
        try {
            Rectangle r = this.getBridge().getUserPreferences().getDatabaseListLocation();
            if (r != null && r.x != -1) {
                this.databaseList.setBounds(r);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.databaseList.addComponentListener(new ComponentListener(){
            UserPreferences up;
            {
                this.up = MainWindow.this.getBridge().getUserPreferences();
            }

            public void componentResized(ComponentEvent arg0) {
                DatabaseList jif = (DatabaseList)arg0.getSource();
                Rectangle r = new Rectangle(jif.getLocation().x, jif.getLocation().y, jif.getSize().width, jif.getSize().height);
                this.up.setDatabaseListLocation(r);
                try {
                    Application.savePreferences(this.up);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void componentMoved(ComponentEvent arg0) {
                DatabaseList jif = (DatabaseList)arg0.getSource();
                Rectangle r = new Rectangle(jif.getLocation().x, jif.getLocation().y, jif.getSize().width, jif.getSize().height);
                this.up.setDatabaseListLocation(r);
                try {
                    Application.savePreferences(this.up);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void componentShown(ComponentEvent arg0) {
            }

            public void componentHidden(ComponentEvent arg0) {
            }
        });
        this.jlStatusLeft.setStringPainted(false);
    }

    public void done() {
        this.jlStatusLeft.setValue(0);
        this.jlStatusLeft.setMaximum(0);
        this.jlStatusLeft.setStringPainted(true);
        this.jlStatusLeft.setString(Messages.getString("MainWindow.Done"));
    }

    public void setError(String error) {
        this.jlStatusLeft.setStringPainted(error != null);
        this.jlStatusLeft.setString(error);
    }

    public void setMessage(String message) {
        this.jlStatusLeft.setStringPainted(message != null);
        this.jlStatusLeft.setString(message);
    }

    public void setStep(int step, String message) {
        this.jlStatusLeft.setStringPainted(message != null);
        this.jlStatusLeft.setString(message);
        this.jlStatusLeft.setValue(step);
    }

    public void setStep(int step) {
        this.jlStatusLeft.setValue(step);
    }

    public void setSteps(int totalSteps) {
        this.jlStatusLeft.setMaximum(totalSteps);
    }
}

