/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.help.CSH;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBRecord;
import pilotdb.ui.Application;
import pilotdb.ui.Messages;
import pilotdb.ui.command.Command;
import pilotdb.ui.databaselist.DatabaseList;
import pilotdb.ui.images.Images;
import pilotdb.ui.recordsetview.DynamicForm;
import pilotdb.ui.recordsetview.RecordsetList;

public class MainMenuBar
extends JMenuBar
implements ActionListener {
    Application application;
    JMenu jmDatabase = new JMenu();
    JMenuItem jmiNewDatabase = new JMenuItem();
    JMenuItem jmiNewView = new JMenuItem();
    JMenuItem jmiViews = new JMenuItem();
    JMenuItem jmiSortDatabase = new JMenuItem();
    JMenuItem jmiInstallDatabase = new JMenuItem();
    JMenuItem jmiExit = new JMenuItem();
    JMenu jmHelp = new JMenu();
    JMenuItem jmiOpenDirectory = new JMenuItem();
    JMenuItem jmiHelpContents = new JMenuItem();
    JMenuItem jmiCheckForUpdates = new JMenuItem();
    JMenuItem jmiSendFeedback = new JMenuItem();
    JMenuItem jmiAbout = new JMenuItem();
    JMenuItem jmiCommitDatabases = new JMenuItem();
    JMenuItem jmiCommitDatabase = new JMenuItem();
    JMenuItem jmHelpGettingStarted = new JMenuItem();
    JMenuItem jmDatabaseDelete = new JMenuItem();
    JMenu jmView = new JMenu();
    JMenu jmExport = new JMenu();
    JMenu jmImport = new JMenu();
    JCheckBoxMenuItem jcbmiStatusBar = new JCheckBoxMenuItem();
    JCheckBoxMenuItem jcbmiToolbar = new JCheckBoxMenuItem();
    JMenu jmRecord = new JMenu();
    JMenuItem jmiDatabaseEditSchema = new JMenuItem();
    JMenuItem jmiRecordEdit = new JMenuItem();
    JMenuItem jmiRecordDelete = new JMenuItem();
    JMenuItem jmiRecordCopy = new JMenuItem();
    JMenuItem jmiRecordSave = new JMenuItem();
    JMenuItem jmiRecordUndo = new JMenuItem();
    JMenuItem jmiViewPrefs = new JMenuItem();
    JMenuItem jmiViewResizeColumns = new JMenuItem();
    JMenuItem jmiExportXml = new JMenuItem();
    JMenuItem jmiExportCsv = new JMenuItem();
    JMenuItem jmiExportRtf = new JMenuItem();
    JMenuItem jmiExportPdf = new JMenuItem();
    JMenuItem jmiExportXls = new JMenuItem();
    JMenuItem jmiExportHtml = new JMenuItem();
    JMenuItem jmiImportCsv = new JMenuItem();
    JMenuItem jmiImportHtml = new JMenuItem();
    JMenuItem jmiImportXml = new JMenuItem();
    JMenuItem jmiImportDirMp3 = new JMenuItem();
    JMenuItem jmiDbProps = new JMenuItem();
    JMenu jmWindow = new JMenu();
    JMenuItem jmiWindowCascade = new JMenuItem();
    JMenuItem jmiWindowCycleWindows = new JMenuItem();
    JMenuItem jmiWindowMinimizeAll = new JMenuItem();
    JMenuItem jmiWindowShowDatabaseList = new JMenuItem();

    public MainMenuBar() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.jmDatabase.setMnemonic('D');
        this.jmDatabase.setText(Messages.getString("MainMenuBar.Database"));
        this.jmDatabaseDelete.setActionCommand("mnu-delete-database");
        this.jmDatabaseDelete.setMnemonic('D');
        this.jmDatabaseDelete.setText(Messages.getString("MainMenuBar.DeleteDatabase"));
        this.jmDatabaseDelete.setIcon(Images.DELETEDB_ICON);
        this.jmiDatabaseEditSchema.setText(Messages.getString("MainMenuBar.EditSchema"));
        this.jmiDatabaseEditSchema.setActionCommand("mnu-show-editschema");
        this.jmiSortDatabase.setText(Messages.getString("MainMenuBar.SortDatabase"));
        this.jmiSortDatabase.setActionCommand("mnu-show-sort-dialog");
        this.jmiSortDatabase.setEnabled(false);
        this.jmiInstallDatabase.setText(Messages.getString("MainMenuBar.InstallDatabase"));
        this.jmiInstallDatabase.setActionCommand("mnu-install-database");
        this.jmiInstallDatabase.setEnabled(false);
        this.jmiNewDatabase.setActionCommand("mnu-show-tablemakergui");
        this.jmiNewDatabase.setMnemonic('C');
        this.jmiNewDatabase.setText(Messages.getString("MainMenuBar.CreateNewDatabase"));
        this.jmiNewDatabase.setAccelerator(KeyStroke.getKeyStroke(84, 10, false));
        this.jmiNewView.setActionCommand("mnu-show-view-maker-gui");
        this.jmiNewView.setMnemonic('V');
        this.jmiNewView.setText(Messages.getString("MainMenuBar.CreateNewView"));
        this.jmiNewView.setAccelerator(KeyStroke.getKeyStroke(86, 10, false));
        this.jmiViews.setActionCommand("mnu-showviewlistgui");
        this.jmiViews.setMnemonic('l');
        this.jmiViews.setText(Messages.getString("MainMenuBar.ViewList"));
        this.jmiOpenDirectory.setActionCommand("mnu-open-directory");
        this.jmiOpenDirectory.setMnemonic('O');
        this.jmiOpenDirectory.setText(Messages.getString("MainMenuBar.OpenWorkingDirectory"));
        this.jmiOpenDirectory.setAccelerator(KeyStroke.getKeyStroke(79, 2, false));
        this.jmiOpenDirectory.setIcon(Images.OPEN_ICON);
        this.jmiCommitDatabases.setActionCommand("mnu-commit-databases");
        this.jmiCommitDatabases.setMnemonic('A');
        this.jmiCommitDatabases.setText(Messages.getString("MainMenuBar.CommitAllDatabases"));
        this.jmiCommitDatabases.setAccelerator(KeyStroke.getKeyStroke(65, 2, false));
        this.jmiCommitDatabases.setIcon(Images.COMMITDBS_ICON);
        this.jmiCommitDatabase.setActionCommand("mnu-commit-database");
        this.jmiCommitDatabase.setMnemonic('v');
        this.jmiCommitDatabase.setText(Messages.getString("MainMenuBar.CommitDatabase"));
        this.jmiCommitDatabase.setAccelerator(KeyStroke.getKeyStroke(83, 2, false));
        this.jmiCommitDatabase.setIcon(Images.COMMITDB_ICON);
        this.jmiDbProps.setActionCommand("mnu-show-dbprops");
        this.jmiDbProps.setMnemonic('p');
        this.jmiDbProps.setText(Messages.getString("MainMenuBar.Properties"));
        this.jmImport.setText(Messages.getString("MainMenuBar.Import"));
        this.jmiImportXml.setText(Messages.getString("MainMenuBar.XML"));
        this.jmiImportXml.setActionCommand("mnu-import-xml");
        this.jmiImportDirMp3.setText(Messages.getString("MainMenuBar.MP3"));
        this.jmiImportDirMp3.setActionCommand("mnu-import-mp3");
        this.jmiImportCsv.setText(Messages.getString("MainMenuBar.CSV"));
        this.jmiImportCsv.setActionCommand("mnu-import-csv");
        this.jmiImportHtml.setText(Messages.getString("MainMenuBar.HTML"));
        this.jmiImportHtml.setActionCommand("mnu-import-html");
        this.jmExport.setText(Messages.getString("MainMenuBar.Export"));
        this.jmiExportXml.setText(Messages.getString("MainMenuBar.XML"));
        this.jmiExportXml.setActionCommand("mnu-export-xml");
        this.jmiExportCsv.setText(Messages.getString("MainMenuBar.CSV"));
        this.jmiExportCsv.setActionCommand("mnu-export-csv");
        this.jmiExportRtf.setActionCommand("mnu-export-rtf");
        this.jmiExportRtf.setText(Messages.getString("MainMenuBar.RTF"));
        this.jmiExportPdf.setActionCommand("mnu-export-pdf");
        this.jmiExportPdf.setText(Messages.getString("MainMenuBar.PDF"));
        this.jmiExportXls.setActionCommand("mnu-export-xls");
        this.jmiExportXls.setText(Messages.getString("MainMenuBar.Excel"));
        this.jmiExportHtml.setActionCommand("mnu-export-html");
        this.jmiExportHtml.setText(Messages.getString("MainMenuBar.HTML"));
        this.jmiExit.setActionCommand("mnu-exit");
        this.jmiExit.setMnemonic('X');
        this.jmiExit.setText(Messages.getString("MainMenuBar.Exit"));
        this.jmiExit.setAccelerator(KeyStroke.getKeyStroke(88, 2, false));
        this.jmRecord.setText(Messages.getString("MainMenuBar.Record"));
        this.jmRecord.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent arg0) {
                MainMenuBar.this.onRecordMenuSelected();
            }

            public void menuDeselected(MenuEvent arg0) {
            }

            public void menuCanceled(MenuEvent arg0) {
            }
        });
        this.jmRecord.setMnemonic('R');
        this.jmiRecordCopy.setActionCommand("mnu-copy-record");
        this.jmiRecordCopy.setMnemonic('C');
        this.jmiRecordCopy.setText(Messages.getString("MainMenuBar.CopyRecord"));
        this.jmiRecordCopy.setAccelerator(KeyStroke.getKeyStroke(67, 2, false));
        this.jmiRecordCopy.setIcon(Images.COPY_ICON);
        this.jmiRecordEdit.setActionCommand("mnu-edit-record");
        this.jmiRecordEdit.setMnemonic('E');
        this.jmiRecordEdit.setText(Messages.getString("MainMenuBar.EditRecord"));
        this.jmiRecordEdit.setAccelerator(KeyStroke.getKeyStroke(69, 2, false));
        this.jmiRecordEdit.setIcon(Images.EDIT_ICON);
        this.jmiRecordDelete.setActionCommand("mnu-delete-record");
        this.jmiRecordDelete.setMnemonic('D');
        this.jmiRecordDelete.setText(Messages.getString("MainMenuBar.DeleteRecord"));
        this.jmiRecordDelete.setAccelerator(KeyStroke.getKeyStroke(68, 2, false));
        this.jmiRecordDelete.setIcon(Images.DELETERECORD_ICON);
        this.jmiRecordSave.setActionCommand("mnu-save-record");
        this.jmiRecordSave.setMnemonic('v');
        this.jmiRecordSave.setText(Messages.getString("MainMenuBar.SaveRecord"));
        this.jmiRecordSave.setAccelerator(KeyStroke.getKeyStroke(83, 2, false));
        this.jmiRecordSave.setIcon(Images.SAVE_RECORD_ICON);
        this.jmiRecordUndo.setActionCommand("mnu-undo-record");
        this.jmiRecordUndo.setMnemonic('U');
        this.jmiRecordUndo.setText(Messages.getString("MainMenuBar.UndoChanges"));
        this.jmiRecordUndo.setAccelerator(KeyStroke.getKeyStroke(85, 2, false));
        this.jmiRecordUndo.setIcon(Images.UNDO_ICON);
        this.jmHelp.setMnemonic('H');
        this.jmHelp.setText(Messages.getString("MainMenuBar.Help"));
        this.jmiCheckForUpdates.setText(Messages.getString("MainMenuBar.CheckForUpdates"));
        this.jmiCheckForUpdates.setActionCommand("mnu-checkforupdates");
        this.jmiSendFeedback.setText(Messages.getString("MainMenuBar.SendFeedback"));
        this.jmiSendFeedback.setActionCommand("mnu-showfeedbackapplet");
        try {
            this.jmHelpGettingStarted.setActionCommand("mnu-help-contents");
            this.jmHelpGettingStarted.setText(Messages.getString("MainMenuBar.GettingStarted"));
            CSH.setHelpIDString((Component)this.jmHelpGettingStarted, (String)"gettingstarted");
            this.jmiHelpContents.setActionCommand("mnu-help-contents");
            this.jmiHelpContents.setMnemonic('C');
            this.jmiHelpContents.setText(Messages.getString("MainMenuBar.Contents"));
            this.jmiHelpContents.setAccelerator(KeyStroke.getKeyStroke(112, 0, false));
            this.jmiHelpContents.setIcon(Images.QUESTION_ICON);
        }
        catch (Throwable e) {
            this.jmiHelpContents = null;
            this.jmHelpGettingStarted = null;
        }
        this.jmiAbout.setActionCommand("mnu-show-aboutbox");
        this.jmiAbout.setMnemonic('B');
        this.jmiAbout.setText(Messages.getString("MainMenuBar.About"));
        this.jmiAbout.setAccelerator(KeyStroke.getKeyStroke(112, 1, false));
        this.jmWindow.setMnemonic('W');
        this.jmWindow.setText(Messages.getString("MainMenuBar.Window"));
        this.jmiWindowCascade.setText(Messages.getString("MainMenuBar.CascadeAll"));
        this.jmiWindowCycleWindows.setText(Messages.getString("MainMenuBar.CycleWindows"));
        this.jmiWindowMinimizeAll.setText(Messages.getString("MainMenuBar.MinimizeAllWindows"));
        this.jmiWindowShowDatabaseList.setText(Messages.getString("MainMenuBar.DatabaseList"));
        this.jmiWindowCascade.setActionCommand("mnu-cascade-windows");
        this.jmiWindowCycleWindows.setActionCommand("mnu-goto-previouswindow");
        this.jmiWindowMinimizeAll.setActionCommand("mnu-minimize-allwindows");
        this.jmiWindowShowDatabaseList.setActionCommand("Database List");
        this.jmiWindowShowDatabaseList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                MainMenuBar.this.showWindow((JMenuItem)arg0.getSource());
            }
        });
        this.jmiWindowCycleWindows.setAccelerator(KeyStroke.getKeyStroke(67, 10, false));
        this.jmView.setMnemonic('V');
        this.jmView.setText(Messages.getString("MainMenuBar.View"));
        this.jcbmiStatusBar.setText(Messages.getString("MainMenuBar.StatusBar"));
        this.jcbmiStatusBar.setSelected(true);
        this.jcbmiStatusBar.setMnemonic('S');
        this.jcbmiStatusBar.setActionCommand("mnu-view-statusbar");
        this.jcbmiToolbar.setText(Messages.getString("MainMenuBar.Toolbar"));
        this.jcbmiToolbar.setSelected(true);
        this.jcbmiToolbar.setMnemonic('T');
        this.jcbmiToolbar.setActionCommand("mnu-view-toolbar");
        this.jmiViewPrefs.setText(Messages.getString("MainMenuBar.Preferences"));
        this.jmiViewPrefs.setMnemonic('P');
        this.jmiViewPrefs.setActionCommand("mnu-show-preferences");
        this.jmiViewResizeColumns.setText(Messages.getString("MainMenuBar.AutosizeColumns"));
        this.jmiViewResizeColumns.setIcon(Images.RESIZECOLUMNS_ICON);
        this.jmiViewResizeColumns.setMnemonic('z');
        this.jmiViewResizeColumns.setActionCommand("mnu-autosizecolumns");
        this.jmDatabase.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent arg0) {
                MainMenuBar.this.onDatabaseMenuSelected();
            }

            public void menuDeselected(MenuEvent arg0) {
            }

            public void menuCanceled(MenuEvent arg0) {
            }
        });
        this.add(this.jmDatabase);
        this.add(this.jmRecord);
        this.add(this.jmView);
        this.add(this.jmWindow);
        this.add(this.jmHelp);
        this.jmDatabase.add(this.jmiOpenDirectory);
        this.jmDatabase.addSeparator();
        this.jmDatabase.add(this.jmiNewDatabase);
        this.jmDatabase.add(this.jmiNewView);
        this.jmDatabase.add(this.jmiViews);
        this.jmDatabase.add(this.jmiDatabaseEditSchema);
        this.jmDatabase.add(this.jmiSortDatabase);
        this.jmDatabase.add(this.jmiInstallDatabase);
        this.jmDatabase.addSeparator();
        this.jmDatabase.add(this.jmiCommitDatabase);
        this.jmDatabase.add(this.jmiCommitDatabases);
        this.jmDatabase.add(this.jmDatabaseDelete);
        this.jmDatabase.addSeparator();
        this.jmDatabase.add(this.jmiDbProps);
        this.jmDatabase.addSeparator();
        this.jmDatabase.add(this.jmImport);
        this.jmImport.add(this.jmiImportCsv);
        this.jmImport.add(this.jmiImportXml);
        this.jmImport.add(this.jmiImportHtml);
        this.jmImport.add(this.jmiImportDirMp3);
        this.jmDatabase.add(this.jmExport);
        this.jmExport.add(this.jmiExportCsv);
        this.jmExport.add(this.jmiExportXml);
        this.jmExport.add(this.jmiExportRtf);
        this.jmExport.add(this.jmiExportPdf);
        this.jmExport.add(this.jmiExportXls);
        this.jmExport.add(this.jmiExportHtml);
        this.jmDatabase.addSeparator();
        this.jmDatabase.add(this.jmiExit);
        if (this.jmHelpGettingStarted != null) {
            this.jmHelp.add(this.jmHelpGettingStarted);
        }
        if (this.jmiHelpContents != null) {
            this.jmHelp.add(this.jmiHelpContents);
        }
        this.jmHelp.add(this.jmiCheckForUpdates);
        this.jmHelp.add(this.jmiSendFeedback);
        this.jmHelp.add(this.jmiAbout);
        this.jmView.add(this.jcbmiToolbar);
        this.jmView.add(this.jcbmiStatusBar);
        this.jmView.addSeparator();
        this.jmView.add(this.jmiViewPrefs);
        this.jmView.add(this.jmiViewResizeColumns);
        this.jmRecord.add(this.jmiRecordEdit);
        this.jmRecord.add(this.jmiRecordCopy);
        this.jmRecord.add(this.jmiRecordDelete);
        this.jmRecord.addSeparator();
        this.jmRecord.add(this.jmiRecordSave);
        this.jmRecord.add(this.jmiRecordUndo);
        this.jmWindow.addMenuListener(new MenuListener(){
            LinkedList items = new LinkedList();

            public void menuSelected(MenuEvent arg0) {
                MainMenuBar.this.destroyWindowList(this.items);
                MainMenuBar.this.buildWindowList(this.items);
            }

            public void menuDeselected(MenuEvent arg0) {
            }

            public void menuCanceled(MenuEvent arg0) {
            }
        });
        this.jmWindow.add(this.jmiWindowCascade);
        this.jmWindow.add(this.jmiWindowMinimizeAll);
        this.jmWindow.addSeparator();
        this.jmWindow.add(this.jmiWindowCycleWindows);
        this.jmWindow.addSeparator();
        this.jmWindow.add(this.jmiWindowShowDatabaseList);
        this.initListeners(this.jmDatabase);
        this.initListeners(this.jmHelp);
        this.initListeners(this.jmView);
        this.initListeners(this.jmImport);
        this.initListeners(this.jmExport);
        this.initListeners(this.jmRecord);
        this.initListeners(this.jmWindow);
    }

    private void buildWindowList(LinkedList l) {
        JInternalFrame[] jifs = this.getApplication().getMainWindow().getDesktop().getAllFrames();
        int selectedIndex = 0;
        selectedIndex = 0;
        while (selectedIndex < jifs.length) {
            if (jifs[selectedIndex].isSelected()) break;
            ++selectedIndex;
        }
        int count = 0;
        int i = 0;
        while (i < jifs.length) {
            if (!jifs[i].getTitle().equals(Messages.getString("MainMenuBar.DatabaseList"))) {
                JCheckBoxMenuItem jcbmi = new JCheckBoxMenuItem();
                jcbmi.setText(String.valueOf(String.valueOf(count + 1)) + " " + jifs[i].getTitle());
                jcbmi.setMnemonic(49 + count);
                jcbmi.setActionCommand(jifs[i].getTitle());
                jcbmi.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent arg0) {
                        MainMenuBar.this.showWindow((JMenuItem)arg0.getSource());
                    }
                });
                if (i == selectedIndex) {
                    jcbmi.setSelected(true);
                }
                this.jmWindow.add(jcbmi);
                l.add(jcbmi);
                ++count;
            }
            ++i;
        }
    }

    private void showWindow(JMenuItem jcbmi) {
        String windowTitle = jcbmi.getActionCommand();
        Command showWindowCommand = new Command(this, "cmd-bringtofront-window", windowTitle);
        this.getApplication().postEvent(showWindowCommand);
    }

    private void destroyWindowList(LinkedList l) {
        int i = 0;
        while (i < l.size()) {
            this.jmWindow.remove((Component)l.get(i));
            ++i;
        }
        l.clear();
    }

    public Application getApplication() {
        return this.application;
    }

    private void initListeners(JMenu jm) {
        Component[] cs = jm.getMenuComponents();
        int i = 0;
        while (i < cs.length) {
            if (cs[i] instanceof JMenuItem) {
                JMenuItem jmi = (JMenuItem)cs[i];
                jmi.addActionListener(this);
            }
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.application == null) {
            return;
        }
        Command ce = null;
        if ("mnu-view-statusbar".equals(e.getActionCommand())) {
            Boolean b = new Boolean(this.jcbmiStatusBar.isSelected());
            ce = new Command(this, "cmd-view-statusbar", b);
            this.application.postEvent(ce);
        } else if ("mnu-view-toolbar".equals(e.getActionCommand())) {
            Boolean b = new Boolean(this.jcbmiToolbar.isSelected());
            ce = new Command(this, "cmd-view-toolbar", b);
            this.application.postEvent(ce);
        } else {
            Command c = new Command(e.getSource(), e.getActionCommand(), null);
            this.application.postEvent(c);
        }
    }

    void onDatabaseMenuSelected() {
        this.jmiCommitDatabase.setEnabled(false);
        DatabaseList dl = this.getApplication().getMainWindow().getDatabaseListFrame();
        PilotDBDatabase[] pdd = dl.getSelectedDatabases();
        this.jmiNewView.setEnabled(pdd.length > 0);
        this.jmDatabaseDelete.setEnabled(pdd.length > 0);
        this.jmiCommitDatabase.setEnabled(pdd.length > 0);
        this.jmExport.setEnabled(pdd.length > 0);
        this.jmiViews.setEnabled(pdd.length > 0);
        this.jmiDbProps.setEnabled(pdd.length > 0);
        this.jmiDatabaseEditSchema.setEnabled(pdd.length > 0);
        this.jmiSortDatabase.setEnabled(pdd.length > 0);
        this.jmiInstallDatabase.setEnabled(pdd.length > 0);
    }

    void onRecordMenuSelected() {
        PilotDBRecord rec = null;
        DynamicForm dynamicForm = null;
        RecordsetList recordsetList = null;
        JInternalFrame jif = this.application.getMainWindow().getDesktop().getSelectedFrame();
        if (jif instanceof RecordsetList) {
            recordsetList = (RecordsetList)jif;
            rec = recordsetList.getSelectedRecord();
        } else if (jif instanceof DynamicForm) {
            dynamicForm = (DynamicForm)jif;
            rec = dynamicForm.getRecord();
        }
        this.jmiRecordCopy.setEnabled(false);
        this.jmiRecordSave.setEnabled(false);
        this.jmiRecordDelete.setEnabled(false);
        this.jmiRecordEdit.setEnabled(false);
        this.jmiRecordUndo.setEnabled(false);
        if (rec == null) {
            return;
        }
        if (recordsetList != null) {
            this.jmiRecordCopy.setEnabled(true);
            this.jmiRecordDelete.setEnabled(true);
            this.jmiRecordEdit.setEnabled(true);
        } else if (dynamicForm != null && dynamicForm.isEditing()) {
            this.jmiRecordSave.setEnabled(true);
            this.jmiRecordUndo.setEnabled(true);
        } else if (dynamicForm != null && !dynamicForm.isEditing()) {
            this.jmiRecordCopy.setEnabled(true);
            this.jmiRecordDelete.setEnabled(true);
            this.jmiRecordEdit.setEnabled(true);
        }
    }

    public void setApplication(Application a) {
        this.application = a;
        try {
            this.jmHelpGettingStarted.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(a.getHelpBroker()));
            this.jmiHelpContents.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(a.getHelpBroker()));
        }
        catch (Error e) {
            e.printStackTrace();
        }
    }
}

