/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URL;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.SwingUtilities;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBEnvironment;
import pilotdb.ui.MainWindow;
import pilotdb.ui.Messages;
import pilotdb.ui.UserPreferences;
import pilotdb.ui.command.ChainOfResponsibility;
import pilotdb.ui.command.Command;
import pilotdb.ui.command.CommandConduit;
import pilotdb.ui.command.handler.AboutBoxCommandHandler;
import pilotdb.ui.command.handler.AddEditRecordHandler;
import pilotdb.ui.command.handler.CommandHandler;
import pilotdb.ui.command.handler.CommitDbHandler;
import pilotdb.ui.command.handler.DbListPopupMenuHandler;
import pilotdb.ui.command.handler.DynamicFormRecordCommandHandler;
import pilotdb.ui.command.handler.EditSchemaHandler;
import pilotdb.ui.command.handler.ExportDbToXmlHandler;
import pilotdb.ui.command.handler.FileCommandsHandler;
import pilotdb.ui.command.handler.InternalFrameHandler;
import pilotdb.ui.command.handler.LogCommandHandler;
import pilotdb.ui.command.handler.MenuHandler;
import pilotdb.ui.command.handler.OpenDbHandler;
import pilotdb.ui.command.handler.SelectedDatabaseHandler;
import pilotdb.ui.command.handler.TableMakerCommandHandler;
import pilotdb.ui.command.handler.ViewMakerCommandHandler;
import pilotdb.ui.command.handler.ViewMenuHandler;
import pilotdb.ui.command.handler.WindowMenuHandler;
import pilotdb.ui.util.StyleSheet;

public class Application
implements CommandConduit,
ChainOfResponsibility {
    private PilotDBEnvironment currentEnvironment;
    private UserPreferences userPreferences;
    HelpSet helpSet = null;
    HelpBroker helpBroker = null;
    private MainWindow mainWindow = null;
    private CommandHandler commandHandlerChain = new FileCommandsHandler(this);
    private PilotDBDatabase selectedDb = null;

    public MainWindow getMainWindow() {
        return this.mainWindow;
    }

    private void helpInit() {
        try {
            URL hsURL = HelpSet.findHelpSet(null, (String)Messages.getString("Application.HelpSetFile"));
            this.helpSet = new HelpSet(null, hsURL);
            this.helpBroker = this.helpSet.createHelpBroker();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Application() throws Exception {
        this.commandHandlerChain.addToChain(new SelectedDatabaseHandler(this));
        this.commandHandlerChain.addToChain(new MenuHandler(this));
        this.commandHandlerChain.addToChain(new OpenDbHandler(this));
        this.commandHandlerChain.addToChain(new AddEditRecordHandler(this));
        this.commandHandlerChain.addToChain(new InternalFrameHandler(this));
        this.commandHandlerChain.addToChain(new DynamicFormRecordCommandHandler(this));
        this.commandHandlerChain.addToChain(new CommitDbHandler(this));
        this.commandHandlerChain.addToChain(new TableMakerCommandHandler(this));
        this.commandHandlerChain.addToChain(new ViewMakerCommandHandler(this));
        this.commandHandlerChain.addToChain(new ViewMenuHandler(this));
        this.commandHandlerChain.addToChain(new WindowMenuHandler(this));
        this.commandHandlerChain.addToChain(new LogCommandHandler(this));
        this.commandHandlerChain.addToChain(new AboutBoxCommandHandler(this));
        this.commandHandlerChain.addToChain(new ExportDbToXmlHandler(this));
        this.commandHandlerChain.addToChain(new DbListPopupMenuHandler(this));
        this.commandHandlerChain.addToChain(new EditSchemaHandler(this));
        try {
            this.helpInit();
        }
        catch (Error e) {
            e.printStackTrace();
        }
        this.mainWindow = new MainWindow();
        this.mainWindow.setApplication(this);
        this.mainWindow.setDefaultCloseOperation(3);
        this.commandHandlerChain.addToChain(this.mainWindow);
        this.helpInit();
    }

    public void handleEvent(Command ae) {
        if (this.commandHandlerChain != null) {
            this.commandHandlerChain.handle(ae);
        }
    }

    public void postEvent(Command ae) {
        final Application bridge = this;
        final Command evt = ae;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                bridge.postEventAndWait(new Command(bridge, "cmd-log-debug", evt));
                bridge.handleEvent(evt);
            }
        });
    }

    public void postEventAndWait(Command ce) {
        this.handleEvent(ce);
    }

    public Component getMainComponent() {
        return this.mainWindow;
    }

    public void openEnvironment(File directory) throws Exception {
        PilotDBEnvironment env;
        this.currentEnvironment = env = PilotDBEnvironment.getEnvironment(directory);
        this.postEvent(new Command(this, "msg-opened-directory", directory));
        this.postEvent(new Command(this, "cmd-show-status", String.valueOf(Messages.getString("Application.OpenedDirectory")) + directory.getAbsolutePath()));
    }

    public ChainOfResponsibility getChainOfResponsibility() {
        return this;
    }

    public CommandHandler getHead() {
        return this.commandHandlerChain;
    }

    public CommandHandler getTail() {
        CommandHandler ch = this.commandHandlerChain;
        while (!ch.isTail()) {
            ch = ch.getSuccessor();
        }
        return ch;
    }

    public int getLength() {
        int i = 0;
        CommandHandler ch = this.commandHandlerChain;
        while (ch != null) {
            ++i;
            ch = ch.getSuccessor();
        }
        return i;
    }

    public void insertAtHead(CommandHandler handler) {
        handler.addToChain(this.commandHandlerChain);
        this.commandHandlerChain = handler;
    }

    public void addToChain(CommandHandler handler) {
        this.commandHandlerChain.addToChain(handler);
    }

    public PilotDBDatabase getSelectedDatabase() {
        return this.selectedDb;
    }

    public void setSelectedDatabase(PilotDBDatabase db) {
        this.selectedDb = db;
    }

    public PilotDBEnvironment getCurrentEnvironment() {
        return this.currentEnvironment;
    }

    public UserPreferences getUserPreferences() {
        return this.userPreferences;
    }

    void setUserPreferences(UserPreferences userPreferences) {
        this.userPreferences = userPreferences;
        try {
            this.openEnvironment(userPreferences.getDefaultWorkingDirectory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void start(WindowListener windowListener) {
        this.mainWindow.start();
        Rectangle r = this.userPreferences.getApplicationWindowLocation();
        if (r != null && r.x != -1) {
            this.mainWindow.setLocation(r.x, r.y);
            this.mainWindow.setSize(r.width, r.height);
        } else {
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            this.mainWindow.setSize((int)((double)d.width * 0.6), (int)((double)d.height * 0.6));
            this.mainWindow.setLocation(15, 15);
        }
        this.mainWindow.addWindowListener(windowListener);
        this.mainWindow.setVisible(true);
        this.mainWindow.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent arg0) {
                MainWindow jif = (MainWindow)arg0.getSource();
                Rectangle r = new Rectangle(jif.getLocation().x, jif.getLocation().y, jif.getSize().width, jif.getSize().height);
                Application.this.userPreferences.setApplicationWindowLocation(r);
                try {
                    Application.savePreferences(Application.this.userPreferences);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void componentMoved(ComponentEvent arg0) {
                MainWindow jif = (MainWindow)arg0.getSource();
                Rectangle r = new Rectangle(jif.getLocation().x, jif.getLocation().y, jif.getSize().width, jif.getSize().height);
                Application.this.userPreferences.setApplicationWindowLocation(r);
                try {
                    Application.savePreferences(Application.this.userPreferences);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void componentShown(ComponentEvent arg0) {
            }

            public void componentHidden(ComponentEvent arg0) {
            }
        });
    }

    public static UserPreferences loadPreferences() throws Exception {
        UserPreferences preferences = new UserPreferences();
        File userdir = new File(System.getProperty("user.home"));
        File prefs = new File(userdir, ".jpilotdb");
        StyleSheet ss = null;
        if (!prefs.exists()) {
            FileOutputStream preferencesOutStream = new FileOutputStream(prefs);
            ss = new StyleSheet();
            preferences.saveTo(ss);
            preferences.setPreferencesFile(prefs);
            ss.write(preferencesOutStream);
            preferencesOutStream.close();
            return preferences;
        }
        FileInputStream preferenceStream = new FileInputStream(prefs);
        ss = new StyleSheet(preferenceStream);
        preferenceStream.close();
        preferences.loadFrom(ss);
        preferences.setPreferencesFile(prefs);
        return preferences;
    }

    public static void savePreferences(UserPreferences preferences) throws Exception {
        File prefs = preferences.getPreferencesFile();
        StyleSheet ss = null;
        FileOutputStream preferencesOutStream = new FileOutputStream(prefs);
        ss = new StyleSheet();
        preferences.saveTo(ss);
        ss.write(preferencesOutStream);
        preferencesOutStream.close();
    }

    public HelpBroker getHelpBroker() {
        return this.helpBroker;
    }

    public HelpSet getHelpSet() {
        return this.helpSet;
    }
}

