/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.tools.simplecreator.xml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBField;
import pilotdb.PilotDBRecord;
import pilotdb.PilotDBSchema;
import pilotdb.tools.PluginMonitor;

public class Plugin
extends DefaultHandler
implements pilotdb.tools.Plugin {
    PluginMonitor pluginMonitor;
    boolean isCommandLine = false;
    private List errors = new LinkedList();
    private Map indexList = new HashMap(10);
    private Map elementInfo = new HashMap(10);
    private List elementList = new LinkedList();
    private String lastKey;
    private boolean hasStarted = false;
    private List records = new LinkedList();
    private String configPath;
    private String xmlPath;
    private String pdbPath;
    private String databaseName;
    private String creatorId;
    String repeatingElementName;
    private List fieldNames = new LinkedList();
    private List paths = new LinkedList();

    public void setUp() {
    }

    public void tearDown() {
    }

    public boolean isReady() {
        return this.xmlPath != null && this.pdbPath != null && this.repeatingElementName != null;
    }

    public Collection getErrors() {
        return this.errors;
    }

    public Options getOptions() {
        Options ops = new Options();
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("input");
        OptionBuilder.withLongOpt("input-file");
        OptionBuilder.withDescription("the xml file to import");
        OptionBuilder.isRequired();
        Option iOption = OptionBuilder.create("x");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("config");
        OptionBuilder.withLongOpt("config-file");
        OptionBuilder.withDescription("the config file to use");
        OptionBuilder.isRequired();
        Option cOption = OptionBuilder.create("c");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("output");
        OptionBuilder.withLongOpt("output-file");
        OptionBuilder.withDescription("the pdb file to create");
        OptionBuilder.isRequired();
        Option oOption = OptionBuilder.create("o");
        OptionBuilder.withDescription("the creator id to use - default (DBOS)");
        OptionBuilder.withLongOpt("creator-id");
        Option creatorOption = OptionBuilder.create("c");
        ops.addOption(iOption);
        ops.addOption(cOption);
        ops.addOption(oOption);
        ops.addOption(creatorOption);
        return ops;
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public boolean isCommandLine() {
        return this.isCommandLine;
    }

    public void configure(CommandLine config) {
        this.isCommandLine = true;
        try {
            this.setXmlPath(config.getOptionValue('x'));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.setConfigPath(config.getOptionValue('c'));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.setPdbPath(config.getOptionValue('o'));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String cid = config.getOptionValue('c');
            this.creatorId = cid == null ? "DBOS" : cid;
        }
        catch (Exception e) {
            this.creatorId = "DBOS";
        }
    }

    public void addFieldNamePathMapping(String fieldName, String path) {
        this.fieldNames.add(fieldName);
        this.paths.add(path);
    }

    public void writeConfiguration(File file) throws Exception {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(fos));
            writer.write("database " + this.getDatabaseName());
            writer.write("\n");
            writer.write("repeatingelement " + this.getRepeatingElementName());
            writer.write("\n");
            int i = 0;
            while (i < this.fieldNames.size()) {
                writer.write("path " + this.fieldNames.get(i) + " " + this.paths.get(i));
                writer.write("\n");
                ++i;
            }
            writer.flush();
            writer.close();
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new Exception(e.getMessage());
        }
    }

    private void readConfiguration() throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(this.configPath));
        String line = null;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).startsWith("database")) {
                this.setDatabaseName(line.substring(9, line.length()));
                continue;
            }
            if (line.startsWith("path")) {
                String fn = line.substring(5, line.indexOf(" ", 5));
                String path = line.substring(line.indexOf(" ", 5) + 1, line.length());
                this.addFieldNamePathMapping(fn, path);
                continue;
            }
            if (!line.startsWith("repeatingelement")) continue;
            this.setRepeatingElementName(line.substring(17, line.length()));
        }
        reader.close();
    }

    public void execute() throws Exception {
        this.start();
        this.setMessage("reading xml");
        PilotDBSchema schema = new PilotDBSchema();
        int i = 0;
        while (i < this.fieldNames.size()) {
            String fn = this.fieldNames.get(i).toString();
            schema.addField(new PilotDBField(0, fn));
            ++i;
        }
        String type = "DB00";
        if (this.creatorId == null) {
            this.creatorId = "DBOS";
        }
        PilotDBDatabase database = new PilotDBDatabase(this.getDatabaseName(), type, this.creatorId, schema);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        SAXParser parser = factory.newSAXParser();
        parser.parse(new InputSource(this.xmlPath), (DefaultHandler)this);
        this.setSteps(this.records.size());
        int i2 = 0;
        while (i2 < this.records.size()) {
            this.setStep(i2, "writing record " + (i2 + 1));
            Map record = (Map)this.records.get(i2);
            PilotDBRecord pdbr = database.createRecord();
            int j = 0;
            while (j < this.fieldNames.size()) {
                String path = this.paths.get(j).toString();
                boolean keepTrying = true;
                int idx = 0;
                String value = "";
                while (keepTrying) {
                    String key = path;
                    key = key.indexOf(".") > -1 ? String.valueOf(key.substring(0, key.indexOf("."))) + "[" + idx + "]" + key.substring(key.indexOf("."), key.length()) : String.valueOf(path) + "[" + idx + "]";
                    String v = (String)record.get(key);
                    if (v == null) {
                        keepTrying = false;
                    } else if (idx == 0) {
                        value = v;
                    } else if (idx > 0) {
                        value = String.valueOf(value) + "," + v;
                    }
                    ++idx;
                }
                if (value != null) {
                    pdbr.setString(j, value);
                }
                ++j;
            }
            ++i2;
        }
        FileOutputStream fos = new FileOutputStream(this.pdbPath);
        database.write(fos);
        fos.close();
        this.done();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String s = new String(ch, start, length).trim();
        if (this.lastKey != null) {
            this.elementInfo.put(this.lastKey, s);
        }
    }

    public void endElement(String name, String element, String y) {
        if (element.equals(this.getRepeatingElementName())) {
            this.hasStarted = false;
            this.indexList = new HashMap(10);
            this.elementInfo = new HashMap(10);
            this.elementList = new LinkedList();
        } else if (this.hasStarted) {
            int li = this.elementList.lastIndexOf(element);
            this.elementList.remove(li);
            this.lastKey = null;
        }
    }

    protected String getElementPath() {
        Iterator iterator = this.elementList.iterator();
        StringBuffer fullPath = new StringBuffer(10);
        while (iterator.hasNext()) {
            String currentNode = (String)iterator.next();
            fullPath.append('/');
            fullPath.append(currentNode);
        }
        return fullPath.toString();
    }

    protected String getNextIndex(String element) {
        String indexString = "[0]";
        Integer currentIndex = new Integer(0);
        if (this.indexList.containsKey(element)) {
            Integer lastIndex = (Integer)this.indexList.get(element);
            currentIndex = new Integer(lastIndex + 1);
            indexString = "[" + currentIndex.toString() + "]";
        }
        this.indexList.put(element, currentIndex);
        return indexString;
    }

    public void startElement(String name, String element, String y, Attributes al) throws SAXException {
        if (element.equals(this.getRepeatingElementName())) {
            this.hasStarted = true;
            this.records.add(this.elementInfo);
        } else if (this.hasStarted) {
            String infoString;
            this.elementList.add(element);
            this.lastKey = infoString = String.valueOf(this.getElementPath()) + this.getNextIndex(element);
            int attSize = al.getLength();
            int i = 0;
            while (i < attSize) {
                String attName = al.getLocalName(i);
                String attValue = al.getValue(i);
                String attKey = String.valueOf(this.lastKey) + "." + attName;
                this.elementInfo.put(attKey, attValue);
                ++i;
            }
        }
    }

    public String getPdbPath() {
        return this.pdbPath;
    }

    public String getRepeatingElementName() {
        return this.repeatingElementName;
    }

    public String getXmlPath() {
        return this.xmlPath;
    }

    public void setConfigPath(String path) throws Exception {
        File f = new File(path);
        if (!f.exists()) {
            throw new Exception("Cannot read " + this.configPath);
        }
        this.configPath = path;
        this.readConfiguration();
    }

    public void setPdbPath(String path) {
        this.pdbPath = path;
    }

    public void setRepeatingElementName(String repeatingElementName) {
        if (repeatingElementName == null) {
            this.errors.add("repeatingElementName cannot be null");
        }
        this.repeatingElementName = repeatingElementName;
    }

    public void setXmlPath(String xml) throws Exception {
        this.xmlPath = xml;
        File f = new File(this.xmlPath);
        if (!f.exists()) {
            throw new Exception(String.valueOf(this.xmlPath) + " does not exist");
        }
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public int getPathCount() {
        return this.paths.size();
    }

    public String getPath(int i) {
        return (String)this.paths.get(i);
    }

    public String getField(int i) {
        return (String)this.fieldNames.get(i);
    }

    public void setPath(int i, String value) {
        this.paths.set(i, value);
    }

    public void setField(int i, String value) {
        this.fieldNames.set(i, value);
    }

    public void removeFieldNamePathMapping(int selected) {
        this.paths.remove(selected);
        this.fieldNames.remove(selected);
    }

    public void removeAllFieldMappings() {
        this.paths.clear();
        this.fieldNames.clear();
    }

    public PluginMonitor getPluginMonitor() {
        return this.pluginMonitor;
    }

    public void setPluginMonitor(PluginMonitor pm) {
        this.pluginMonitor = pm;
    }

    public void setSteps(int totalSteps) {
        if (this.pluginMonitor != null) {
            this.pluginMonitor.setSteps(totalSteps);
        }
    }

    public void setStep(int step) {
        if (this.pluginMonitor != null) {
            this.pluginMonitor.setStep(step);
        }
    }

    public void setStep(int step, String message) {
        if (this.pluginMonitor != null) {
            this.pluginMonitor.setStep(step, message);
        }
    }

    public void setMessage(String message) {
        if (this.pluginMonitor != null) {
            this.pluginMonitor.setMessage(message);
        }
    }

    public void setError(String error) {
        if (this.pluginMonitor != null) {
            this.pluginMonitor.setError(error);
        }
    }

    public void done() {
        if (this.pluginMonitor != null) {
            this.pluginMonitor.done();
        }
    }

    public void start() {
        if (this.pluginMonitor != null) {
            this.pluginMonitor.start();
        }
    }
}

