/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.tools.simplecreator.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.util.Date;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import pilotdb.PilotDBAppInfo;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBDate;
import pilotdb.PilotDBField;
import pilotdb.PilotDBRecord;
import pilotdb.PilotDBSchema;
import pilotdb.PilotDBTime;
import pilotdb.PilotDBView;
import pilotdb.tools.AbstractPlugin;
import pilotdb.tools.simplecreator.csv.CSVImportModel;
import pilotdb.util.StringUtils;

public class Plugin
extends AbstractPlugin {
    private CSVImportModel model = new CSVImportModel();
    private PilotDBDatabase db = null;
    private Options options = null;

    public Options getOptions() {
        if (this.options == null) {
            this.options = new Options();
            OptionBuilder.withArgName("file");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription("Read the info FILE for the metadata.");
            OptionBuilder.isRequired();
            OptionBuilder.withLongOpt("config-file");
            Option configFile = OptionBuilder.create("c");
            OptionBuilder.withDescription("set the backup bit");
            OptionBuilder.withLongOpt("backup");
            Option backupOption = OptionBuilder.create("b");
            OptionBuilder.withDescription("use extended csv mode");
            OptionBuilder.withLongOpt("extended");
            Option extendedOption = OptionBuilder.create("e");
            OptionBuilder.withDescription("The csv file to be imported");
            OptionBuilder.isRequired();
            OptionBuilder.withLongOpt("input-file");
            Option dataFileOption = OptionBuilder.create("f");
            OptionBuilder.withDescription("the pdb file to create");
            OptionBuilder.isRequired();
            OptionBuilder.withLongOpt("output-file");
            Option outputFileOption = OptionBuilder.create("p");
            OptionBuilder.withDescription("see this help information");
            OptionBuilder.withLongOpt("help");
            Option helpOption = OptionBuilder.create("h");
            OptionBuilder.withDescription("the creator id to use - default (DBOS)");
            OptionBuilder.withLongOpt("creator-id");
            Option creatorOption = OptionBuilder.create("c");
            this.options.addOption(helpOption);
            this.options.addOption(configFile);
            this.options.addOption(backupOption);
            this.options.addOption(extendedOption);
            this.options.addOption(dataFileOption);
            this.options.addOption(outputFileOption);
            this.options.addOption(creatorOption);
            return this.options;
        }
        return this.options;
    }

    public boolean isReady() {
        return this.model.isComplete();
    }

    public void execute() throws Exception {
        this.start();
        this.setSteps(this.model.getFieldCount());
        PilotDBSchema schema = new PilotDBSchema();
        int i = 0;
        while (i < this.model.getFieldCount()) {
            CSVImportModel.TableField f = this.model.getField(i);
            PilotDBField field = new PilotDBField(f.type, f.name);
            schema.addField(field);
            this.setStep(i, "Creating Field " + (i + 1));
            ++i;
        }
        this.db = new PilotDBDatabase(this.model.getDatabaseTitle(), "DB00", "DBOS", schema);
        PilotDBAppInfo appInfo = (PilotDBAppInfo)this.db.getAppInfo();
        appInfo.setProtected(this.model.isProtectedDb());
        appInfo.setReadOnly(this.model.isReadOnly());
        this.setSteps(this.model.getViewCount());
        int i2 = 0;
        while (i2 < this.model.getViewCount()) {
            CSVImportModel.View v = this.model.getView(i2);
            PilotDBView view = this.db.createView(v.name);
            int j = 0;
            while (j < v.fields.size()) {
                CSVImportModel.ViewField vf = v.getViewField(j);
                view.addColumn(vf.name, (short)vf.width);
                ++j;
            }
            this.setStep(i2, "Creating View " + (i2 + 1));
            ++i2;
        }
        File csvFile = new File(this.model.getCsvPath());
        long fileSize = csvFile.length();
        BufferedReader reader = new BufferedReader(new FileReader(csvFile));
        this.setSteps((int)fileSize / 1000);
        String s = null;
        int lineNumber = 1;
        int step = 0;
        while ((s = reader.readLine()) != null) {
            this.setStep((step += s.length()) / 1000, "Read " + step / 1000 + " kb");
            PilotDBRecord newRecord = this.db.createRecord();
            String[] vals = this.model.isExtendedCsvFormat() ? StringUtils.breakStringApartExtended(s, this.model.getSeparator()) : StringUtils.breakStringApart(s, this.model.getSeparator());
            try {
                int i3 = 0;
                while (i3 < vals.length) {
                    this.setObjectAt(vals[i3].trim(), newRecord, i3);
                    ++i3;
                }
            }
            catch (Exception e) {
                this.db.deleteRecord(newRecord);
                this.addError("error importing line {0} : {1}", new Object[]{new Integer(lineNumber), e});
            }
            ++lineNumber;
        }
        FileOutputStream fos = new FileOutputStream(this.model.getDatabasePath());
        this.db.write(fos);
        fos.close();
        this.done();
    }

    private void setObjectAt(String string, PilotDBRecord newRecord, int i) throws Exception {
        if (string != null && !string.equals("")) {
            int type = this.db.getSchema().getField(i).getType();
            switch (type) {
                case 0: {
                    newRecord.setString(i, string);
                    break;
                }
                case 1: {
                    newRecord.setBoolean(i, string);
                    break;
                }
                case 2: {
                    newRecord.setInteger(i, string);
                    break;
                }
                case 8: {
                    newRecord.setFloat(i, string);
                    break;
                }
                case 3: {
                    Date d = this.model.getJavaDateFormat().parse(string);
                    newRecord.setDate(i, new PilotDBDate(d));
                    break;
                }
                case 4: {
                    Date d = this.model.getJavaTimeFormat().parse(string);
                    newRecord.setTime(i, new PilotDBTime(d));
                    break;
                }
                default: {
                    this.addError("Invalid Type {0}", new Object[]{new Integer(type)});
                }
            }
        }
    }

    public String getDBPath() {
        return null;
    }

    public void setConfigPath(String configPath) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(configPath));
        this.model.read(reader);
    }

    public void setCsvPath(String csvPath) throws Exception {
        this.model.setCsvPath(csvPath);
    }

    public void setPdbPath(String pdbPath) {
        this.model.setDatabasePath(pdbPath);
    }

    public void setImportModel(CSVImportModel model) {
        this.model = model;
    }

    public PilotDBDatabase getDb() {
        return this.db;
    }

    public void configure(CommandLine line) {
        String configPath = line.getOptionValue("config-file");
        String pdbPath = line.getOptionValue("output-file");
        String csvPath = line.getOptionValue("input-file");
        if (line.hasOption("extended")) {
            this.model.setExtendedCsvFormat(true);
        }
        if (line.hasOption("backup")) {
            this.model.setBackup(true);
        }
        try {
            String cid = line.getOptionValue('c');
            this.model.setCreatorId(cid);
        }
        catch (Exception cid) {
            // empty catch block
        }
        try {
            this.setConfigPath(configPath);
        }
        catch (Exception e) {
            this.addError(e.getMessage(), new Object[]{e});
        }
        try {
            this.setCsvPath(csvPath);
        }
        catch (Exception e) {
            this.addError(e.getMessage(), new Object[]{e});
        }
        try {
            this.setPdbPath(pdbPath);
        }
        catch (Exception e) {
            this.addError(e.getMessage(), new Object[]{e});
        }
    }
}

