/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.tools.export.xml;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBField;
import pilotdb.PilotDBRecord;
import pilotdb.tools.AbstractPlugin;

public class Plugin
extends AbstractPlugin {
    private String outputXmlPath;
    private String configPath;
    private String pdbPath;
    private boolean useConfigPath = false;
    private File outputXmlFile;
    private PilotDBDatabase database = null;
    String xmlDbElementName;
    String xmlRowElementName;
    Map xmlColumnElementNames;
    List dbColumns;

    public boolean isReady() {
        return this.outputXmlFile != null && this.database != null && this.xmlDbElementName != null && this.xmlRowElementName != null && this.xmlColumnElementNames.size() > 0 && this.dbColumns.size() > 0;
    }

    public void configure(CommandLine line) {
        try {
            this.setOutputXmlPath(line.getOptionValue("o"));
        }
        catch (Exception e) {
            this.addError(e.getMessage(), new Object[0]);
        }
        String p = line.getOptionValue("c");
        if (p != null) {
            try {
                this.setConfigPath(line.getOptionValue("c"));
            }
            catch (Exception e) {
                this.addError(e.getMessage(), new Object[0]);
            }
        }
        try {
            this.setPdbPath(line.getOptionValue("p"));
        }
        catch (Exception e) {
            this.addError(e.getMessage(), new Object[0]);
        }
    }

    public void tearDown() {
        super.tearDown();
        this.database = null;
        this.xmlColumnElementNames = null;
        this.xmlDbElementName = null;
        this.xmlRowElementName = null;
        this.outputXmlFile = null;
        this.outputXmlPath = null;
    }

    public void setUp() {
        super.setUp();
        this.xmlColumnElementNames = new HashMap();
        this.dbColumns = new LinkedList();
        if (this.useConfigPath) {
            try {
                this.readConfiguration(this.configPath);
            }
            catch (Exception e) {
                this.addError("An error occured reading the configuration file {0}", new Object[]{e});
            }
        } else {
            this.setXmlDbElementName("database");
            this.setXmlRowElementName("record");
            this.readFieldsFromDatabase();
        }
    }

    private void readFieldsFromDatabase() {
        int i = 0;
        while (i < this.database.getSchema().getFieldCount()) {
            PilotDBField field = this.database.getSchema().getField(i);
            this.addXmlColumnElementName(field.getName(), field.getName());
            ++i;
        }
    }

    private void readConfiguration(String configPath) throws IOException {
        String s;
        BufferedReader reader = new BufferedReader(new FileReader(configPath));
        while ((s = reader.readLine()) != null) {
            StringTokenizer st;
            if (s.startsWith("dbelement")) {
                st = new StringTokenizer(s);
                if (st.countTokens() < 2) continue;
                st.nextToken();
                this.setXmlDbElementName(st.nextToken());
                continue;
            }
            if (s.startsWith("recordelement")) {
                st = new StringTokenizer(s);
                if (st.countTokens() < 2) continue;
                st.nextToken();
                this.setXmlRowElementName(st.nextToken());
                continue;
            }
            if (!s.startsWith("columnelement") || (st = new StringTokenizer(s)).countTokens() < 3) continue;
            st.nextToken();
            String columnName = st.nextToken();
            String columnElement = st.nextToken();
            this.addXmlColumnElementName(columnName, columnElement);
        }
        reader.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws Exception {
        try {
            this.start();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element rootElement = document.createElement(this.getXmlDbElementName());
            document.appendChild(rootElement);
            int recordCount = this.database.getRecordCount();
            this.setSteps(recordCount);
            int i = 0;
            block3: while (true) {
                block6: {
                    if (i < recordCount) break block6;
                    TransformerFactory tfactory = TransformerFactory.newInstance();
                    Transformer transformer = tfactory.newTransformer();
                    DOMSource domSource = new DOMSource(document);
                    File out = new File(this.getOutputXmlPath());
                    FileOutputStream outstream = new FileOutputStream(out);
                    StreamResult streamResult = new StreamResult(outstream);
                    transformer.transform(domSource, streamResult);
                    outstream.close();
                    break;
                }
                this.setStep(i + 1, "Exporting Record " + (i + 1));
                PilotDBRecord record = (PilotDBRecord)this.database.getRecord(i);
                Element rElement = document.createElement(this.getXmlRowElementName());
                rootElement.appendChild(rElement);
                int dbColumnCount = this.getDbColumnCount();
                int c = 0;
                while (true) {
                    if (c >= dbColumnCount) {
                        ++i;
                        continue block3;
                    }
                    String dbColumnName = this.getDbColumnName(c);
                    Object value = record.getObject(dbColumnName);
                    String elementName = this.getXmlElementNameForDbColumn(dbColumnName);
                    Element celement = document.createElement(elementName);
                    Text telement = document.createTextNode(String.valueOf(value));
                    celement.appendChild(telement);
                    rElement.appendChild(celement);
                    ++c;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            this.done();
            throw throwable;
        }
        {
            Object var16_21 = null;
        }
        this.done();
    }

    public PilotDBDatabase getDatabase() {
        return this.database;
    }

    public void setDatabase(PilotDBDatabase database) {
        this.database = database;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public String getOutputXmlPath() {
        return this.outputXmlPath;
    }

    public String getPdbPath() {
        return this.pdbPath;
    }

    public void setConfigPath(String configPath) throws Exception {
        this.configPath = configPath;
        this.useConfigPath = true;
    }

    public void setOutputXmlPath(String outputXmlPath) throws Exception {
        this.outputXmlPath = outputXmlPath;
        this.outputXmlFile = new File(outputXmlPath);
        if (this.outputXmlFile.exists() && !this.outputXmlFile.canWrite()) {
            this.addError("{0} is not writable", new Object[]{outputXmlPath});
        }
    }

    public void addXmlColumnElementName(String dbColumnName, String xmlElementName) {
        MessageFormat warning = new MessageFormat("Warning: Field name \"{0}\" {1} ''{2}'' -- {3}");
        String newElementName = xmlElementName;
        char[] chars = xmlElementName.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (!Character.isLetterOrDigit(chars[i]) && chars[i] != '_' && chars[i] != ':') {
                if (chars[i] == '-' || chars[i] == '.') {
                    if (i == 0) {
                        System.err.println(warning.format(new Object[]{xmlElementName, "begins with", new Character(chars[i]), "prefixing with '_'"}));
                        newElementName = "_".concat(newElementName);
                    }
                } else {
                    System.err.println(warning.format(new Object[]{xmlElementName, "contains", new Character(chars[i]), "replacing with '_'"}));
                    newElementName = newElementName.replace(chars[i], '_');
                }
            }
            ++i;
        }
        this.xmlColumnElementNames.put(dbColumnName, newElementName);
        this.dbColumns.add(dbColumnName);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPdbPath(String pdbPath) {
        this.pdbPath = pdbPath;
        File f = new File(pdbPath);
        if (f.exists() && f.canRead()) {
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(f);
                    this.database = new PilotDBDatabase(fis);
                }
                catch (Exception e) {
                    this.addError("{0} is not a valid Pilot-DB", new Object[]{pdbPath});
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                try {
                    fis.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            {
                Object var5_7 = null;
                try {}
                catch (Exception exception) {
                    return;
                }
                fis.close();
                return;
            }
        }
        this.addError("{0} does not exists or is not readable", new Object[]{pdbPath});
    }

    public String getXmlDbElementName() {
        return this.xmlDbElementName;
    }

    public String getXmlRowElementName() {
        return this.xmlRowElementName;
    }

    public void setXmlDbElementName(String xmlDbElementName) {
        char[] chars = xmlDbElementName.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (!Character.isJavaIdentifierPart(chars[i])) {
                this.addError("{0} is not a valid character in an xml element name", new Object[]{new Character(chars[i])});
            }
            ++i;
        }
        this.xmlDbElementName = xmlDbElementName;
    }

    public void setXmlRowElementName(String xmlRowElementName) {
        this.xmlRowElementName = xmlRowElementName;
        char[] chars = xmlRowElementName.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (!Character.isJavaIdentifierPart(chars[i])) {
                this.addError("{0} is not a valid character in an xml element name", new Object[]{new Character(chars[i])});
            }
            ++i;
        }
    }

    public int getDbColumnCount() {
        return this.dbColumns.size();
    }

    public String getDbColumnName(int index) {
        return this.dbColumns.get(index).toString();
    }

    public String getXmlElementNameForDbColumn(String columnName) {
        return String.valueOf(this.xmlColumnElementNames.get(columnName));
    }

    public Options getOptions() {
        Options options = new Options();
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("output");
        OptionBuilder.withDescription("the output file");
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt("output-file");
        Option o = OptionBuilder.create("o");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("config");
        OptionBuilder.withDescription("the config file");
        OptionBuilder.withLongOpt("config-file");
        Option c = OptionBuilder.create("c");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("input");
        OptionBuilder.withDescription("the pdb file");
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt("input-file");
        Option p = OptionBuilder.create("p");
        options.addOption(o);
        options.addOption(c);
        options.addOption(p);
        return options;
    }
}

