/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.tools.export.rtf;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Table;
import com.lowagie.text.rtf.RtfWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBRecord;
import pilotdb.PilotDBSchema;
import pilotdb.tools.AbstractPlugin;

public class Plugin
extends AbstractPlugin {
    private String outputRtfPath;
    private String pdbPath;
    private PilotDBDatabase database = null;

    public Options getOptions() {
        Options options = new Options();
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("output-rtf");
        OptionBuilder.withDescription("the rtf output file");
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt("output-rtf");
        Option o = OptionBuilder.create("o");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("input");
        OptionBuilder.withDescription("the pdb file");
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt("input-file");
        Option p = OptionBuilder.create("p");
        options.addOption(o);
        options.addOption(p);
        return options;
    }

    public void configure(CommandLine line) {
        try {
            this.setOutputRtfPath(line.getOptionValue("o"));
        }
        catch (Exception e) {
            this.addError(e.getMessage(), new Object[0]);
        }
        try {
            this.setPdbPath(line.getOptionValue("p"));
        }
        catch (Exception e) {
            this.addError(e.getMessage(), new Object[0]);
        }
    }

    public boolean isReady() {
        return this.outputRtfPath != null && this.pdbPath != null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws Exception {
        if (this.database == null) {
            throw new Exception("Database is not set");
        }
        this.start();
        this.setSteps(this.database.getRecordCount());
        try {
            Document document = new Document(PageSize.LETTER.rotate());
            try {
                RtfWriter writer = RtfWriter.getInstance(document, new FileOutputStream(this.getOutputRtfPath()));
                document.open();
                Paragraph p = new Paragraph(this.database.getTitle());
                document.add(p);
                int recordcount = this.database.getRecordCount();
                PilotDBSchema schema = this.database.getSchema();
                Table table = new Table(schema.getFieldCount());
                table.setWidths(this.widths());
                table.setPadding(3.0f);
                table.setBorderWidth(2.0f);
                table.setAlignment(1);
                int i = 0;
                while (true) {
                    if (i >= schema.getFieldCount()) break;
                    table.addCell(schema.getField(i).getName());
                    ++i;
                }
                i = 0;
                block7: while (true) {
                    if (i >= recordcount) {
                        document.add(table);
                        break;
                    }
                    PilotDBRecord rec = (PilotDBRecord)this.database.getRecord(i);
                    this.setStep(i + 1, "Constructing Table Row " + (i + 1));
                    int j = 0;
                    while (true) {
                        if (j >= schema.getFieldCount()) {
                            ++i;
                            continue block7;
                        }
                        if (i % 2 == 1) {
                            table.setGrayFill(0.9f);
                        }
                        table.addCell(String.valueOf(rec.getObject(j)));
                        if (i % 2 == 1) {
                            table.setGrayFill(0.0f);
                        }
                        if (i % 50 == 0) {
                            Thread.yield();
                        }
                        ++j;
                    }
                    break;
                }
            }
            catch (DocumentException de) {
                System.err.println(de.getMessage());
            }
            catch (IOException ioe) {
                System.err.println(ioe.getMessage());
            }
            document.close();
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            this.done();
            throw throwable;
        }
        {
            Object var10_14 = null;
        }
        this.done();
    }

    private String quoted(String in) {
        return "\"".concat(in).concat("\"");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPdbPath(String string) {
        this.pdbPath = string;
        File f = new File(this.pdbPath);
        if (f.exists() && f.canRead()) {
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(f);
                    this.database = new PilotDBDatabase(fis);
                }
                catch (Exception e) {
                    this.addError("{0} is not a valid Pilot-DB", new Object[]{this.pdbPath});
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                try {
                    fis.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            {
                Object var5_7 = null;
                try {}
                catch (Exception exception) {
                    return;
                }
                fis.close();
                return;
            }
        }
        this.addError("{0} does not exists or is not readable", new Object[]{this.pdbPath});
    }

    public void setDatabase(PilotDBDatabase selectedDb) {
        this.database = selectedDb;
    }

    public PilotDBDatabase getDatabase() {
        return this.database;
    }

    public String getOutputRtfPath() {
        return this.outputRtfPath;
    }

    public String getPdbPath() {
        return this.pdbPath;
    }

    public void setOutputRtfPath(String string) {
        this.outputRtfPath = string;
    }

    private int[] widths() {
        int rcount = this.database.getRecordCount();
        int[] chars = new int[this.database.getSchema().getFieldCount()];
        int f = 0;
        while (f < this.database.getSchema().getFieldCount()) {
            int r = 0;
            while (r < rcount) {
                PilotDBRecord rec = (PilotDBRecord)this.database.getRecord(r);
                try {
                    chars[f] = Math.max(chars[f], String.valueOf(rec.getObject(f)).length());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++r;
            }
            ++f;
        }
        f = 0;
        while (f < this.database.getSchema().getFieldCount()) {
            chars[f] = Math.max(chars[f], String.valueOf(this.database.getSchema().getField(f).getName()).length());
            ++f;
        }
        int totalCharWidth = 0;
        int i = 0;
        while (i < chars.length) {
            totalCharWidth += chars[i];
            ++i;
        }
        int[] w = new int[chars.length];
        int i2 = 0;
        while (i2 < chars.length) {
            w[i2] = (int)((float)chars[i2] / (float)totalCharWidth * 100.0f);
            ++i2;
        }
        return w;
    }
}

