/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.tools.export.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBException;
import pilotdb.PilotDBRecord;
import pilotdb.PilotDBSchema;
import pilotdb.tools.AbstractPlugin;
import pilotdb.tools.export.pdf.ExportProperties;

public class Plugin
extends AbstractPlugin {
    private String outputRtfPath;
    private String pdbPath;
    private PilotDBDatabase database = null;

    public Options getOptions() {
        Options options = new Options();
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("output-rtf");
        OptionBuilder.withDescription("the rtf output file");
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt("output-rtf");
        Option o = OptionBuilder.create("o");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("input");
        OptionBuilder.withDescription("the pdb file");
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt("input-file");
        Option p = OptionBuilder.create("p");
        options.addOption(o);
        options.addOption(p);
        return options;
    }

    public void configure(CommandLine line) {
        try {
            this.setOutputRtfPath(line.getOptionValue("o"));
        }
        catch (Exception e) {
            this.addError(e.getMessage(), new Object[0]);
        }
        try {
            this.setPdbPath(line.getOptionValue("p"));
        }
        catch (Exception e) {
            this.addError(e.getMessage(), new Object[0]);
        }
    }

    public boolean isReady() {
        return this.outputRtfPath != null && this.pdbPath != null;
    }

    public void setExportProperties(ExportProperties props) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws Exception {
        if (this.database == null) {
            throw new Exception("Database is not set");
        }
        this.start();
        this.setSteps(this.database.getRecordCount());
        int[] charWidths = this.actualCharWidths();
        try {
            int fullwidth = 0;
            int i = 0;
            while (i < charWidths.length) {
                fullwidth += charWidths[i];
                ++i;
            }
            int fontWidthAdjustment = 12;
            float fontSize = 10.0f;
            Rectangle r = new Rectangle(fullwidth / fontWidthAdjustment * 72, 612.0f);
            Document document = new Document(r, 10.0f, 10.0f, 10.0f, 10.0f);
            document.addCreationDate();
            document.addSubject(this.database.getTitle());
            document.addTitle(this.database.getTitle());
            document.setJavaScript_onLoad("alert('You Suck')");
            try {
                PdfWriter.getInstance(document, new FileOutputStream(this.getOutputRtfPath()));
                document.setMargins(15.0f, 15.0f, 15.0f, 15.0f);
                document.open();
                Paragraph p = new Paragraph(this.database.getTitle());
                p.setAlignment(1);
                document.add(p);
                Font headerFont = new Font(1, fontSize, 1);
                Font cellFont = new Font(1, fontSize, 0);
                int recordcount = this.database.getRecordCount();
                PilotDBSchema schema = this.database.getSchema();
                PdfPTable table = new PdfPTable(schema.getFieldCount());
                table.setWidths(this.widthPercentages());
                table.setWidthPercentage(95.0f);
                table.getDefaultCell().setPadding(3.0f);
                table.getDefaultCell().setBorderWidth(2.0f);
                table.getDefaultCell().setHorizontalAlignment(0);
                int i2 = 0;
                while (i2 < schema.getFieldCount()) {
                    Chunk c = new Chunk(schema.getField(i2).getName());
                    c.setFont(headerFont);
                    table.addCell(new Phrase(c));
                    ++i2;
                }
                table.setHeaderRows(1);
                table.getDefaultCell().setBorderWidth(1.0f);
                i2 = 0;
                while (i2 < recordcount) {
                    if (i2 % 2 == 1) {
                        table.getDefaultCell().setGrayFill(0.9f);
                    }
                    PilotDBRecord rec = (PilotDBRecord)this.database.getRecord(i2);
                    this.setStep(i2 + 1, "Constructing Table Row " + (i2 + 1));
                    int j = 0;
                    while (j < schema.getFieldCount()) {
                        Object value = rec.getObject(j);
                        Chunk c = new Chunk(String.valueOf(value));
                        c.setFont(cellFont);
                        table.addCell(new Phrase(c));
                        ++j;
                    }
                    if (i2 % 2 == 1) {
                        table.getDefaultCell().setGrayFill(0.0f);
                    }
                    if (i2 % 50 == 0) {
                        Thread.yield();
                    }
                    ++i2;
                }
                document.add(table);
            }
            catch (DocumentException de) {
                System.err.println(de.getMessage());
                throw de;
            }
            catch (IOException ioe) {
                System.err.println(ioe.getMessage());
                throw ioe;
            }
            this.setMessage("Closing File");
            Thread.yield();
            document.close();
            Object var18_22 = null;
        }
        catch (Throwable throwable) {
            Object var18_21 = null;
            this.done();
            throw throwable;
        }
        this.done();
    }

    private String quoted(String in) {
        return "\"".concat(in).concat("\"");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPdbPath(String string) {
        this.pdbPath = string;
        File f = new File(this.pdbPath);
        if (f.exists() && f.canRead()) {
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(f);
                    this.database = new PilotDBDatabase(fis);
                }
                catch (Exception e) {
                    this.addError("{0} is not a valid Pilot-DB", new Object[]{this.pdbPath});
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                try {
                    fis.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            {
                Object var5_7 = null;
                try {}
                catch (Exception exception) {
                    return;
                }
                fis.close();
                return;
            }
        }
        this.addError("{0} does not exists or is not readable", new Object[]{this.pdbPath});
    }

    public void setDatabase(PilotDBDatabase selectedDb) {
        this.database = selectedDb;
    }

    public PilotDBDatabase getDatabase() {
        return this.database;
    }

    public String getOutputRtfPath() {
        return this.outputRtfPath;
    }

    public String getPdbPath() {
        return this.pdbPath;
    }

    public void setOutputRtfPath(String string) {
        this.outputRtfPath = string;
    }

    private int[] actualCharWidths() {
        int rcount = this.database.getRecordCount();
        int[] chars = new int[this.database.getSchema().getFieldCount()];
        int f = 0;
        while (f < this.database.getSchema().getFieldCount()) {
            int r = 0;
            while (r < rcount) {
                PilotDBRecord rec = (PilotDBRecord)this.database.getRecord(r);
                try {
                    chars[f] = Math.max(chars[f], String.valueOf(rec.getObject(f)).length());
                }
                catch (PilotDBException pde) {
                    this.addError("Error : " + pde.getMessage(), new Object[0]);
                }
                ++r;
            }
            ++f;
        }
        f = 0;
        while (f < this.database.getSchema().getFieldCount()) {
            chars[f] = Math.max(chars[f], String.valueOf(this.database.getSchema().getField(f).getName()).length());
            ++f;
        }
        return chars;
    }

    private int[] widthPercentages() {
        int rcount = this.database.getRecordCount();
        int[] chars = new int[this.database.getSchema().getFieldCount()];
        int f = 0;
        while (f < this.database.getSchema().getFieldCount()) {
            int r = 0;
            while (r < rcount) {
                PilotDBRecord rec = (PilotDBRecord)this.database.getRecord(r);
                try {
                    chars[f] = Math.max(chars[f], String.valueOf(rec.getObject(f)).length());
                }
                catch (Exception e) {
                    this.addError("Error:" + e.getMessage(), new Object[0]);
                }
                ++r;
            }
            ++f;
        }
        f = 0;
        while (f < this.database.getSchema().getFieldCount()) {
            chars[f] = Math.max(chars[f], String.valueOf(this.database.getSchema().getField(f).getName()).length());
            ++f;
        }
        int totalCharWidth = 0;
        int i = 0;
        while (i < chars.length) {
            totalCharWidth += chars[i];
            ++i;
        }
        int[] w = new int[chars.length];
        int i2 = 0;
        while (i2 < chars.length) {
            w[i2] = (int)((float)chars[i2] / (float)totalCharWidth * 100.0f) + 1;
            ++i2;
        }
        return w;
    }
}

