/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.tools.export.html;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBRecord;
import pilotdb.tools.AbstractPlugin;
import pilotdb.ui.util.Style;
import pilotdb.ui.util.StyleSheet;

public class Plugin
extends AbstractPlugin {
    private String outputHtmlPath;
    private String configPath;
    private String pdbPath;
    private boolean useConfigPath = false;
    private File outputHtmlFile;
    private PilotDBDatabase database = null;
    String xmlDbElementName;
    String xmlRowElementName;
    Map xmlColumnElementNames;
    List dbColumns;

    public boolean isReady() {
        return this.outputHtmlFile != null && this.database != null && this.xmlDbElementName != null && this.xmlRowElementName != null && this.xmlColumnElementNames.size() > 0 && this.dbColumns.size() > 0;
    }

    public void configure(CommandLine line) {
        try {
            this.setOutputHtmlPath(line.getOptionValue("o"));
        }
        catch (Exception e) {
            this.addError(e.getMessage(), new Object[0]);
        }
        String p = line.getOptionValue("c");
        if (p != null) {
            try {
                this.setConfigPath(line.getOptionValue("c"));
            }
            catch (Exception e) {
                this.addError(e.getMessage(), new Object[0]);
            }
        }
        try {
            this.setPdbPath(line.getOptionValue("p"));
        }
        catch (Exception e) {
            this.addError(e.getMessage(), new Object[0]);
        }
    }

    public void tearDown() {
        super.tearDown();
        this.database = null;
        this.xmlColumnElementNames = null;
        this.xmlDbElementName = null;
        this.xmlRowElementName = null;
        this.outputHtmlFile = null;
        this.outputHtmlPath = null;
    }

    public void setUp() {
        super.setUp();
        this.xmlColumnElementNames = new HashMap();
        this.dbColumns = new LinkedList();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws Exception {
        try {
            this.start();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element rootElement = document.createElement("html");
            document.appendChild(rootElement);
            Element bodyElement = document.createElement("body");
            rootElement.appendChild(bodyElement);
            Element headElement = document.createElement("head");
            rootElement.appendChild(headElement);
            Element linkElement = document.createElement("link");
            linkElement.setAttribute("rel", "stylesheet");
            linkElement.setAttribute("href", "export.css");
            headElement.appendChild(linkElement);
            StyleSheet ss = new StyleSheet();
            Style style = new Style();
            style.setId("th");
            style.addValue("font-family", "Verdana");
            style.addValue("font-weight", "bold");
            style.addValue("font-size", "10pt");
            ss.registerStyle(style);
            style = new Style();
            style.setId("td");
            style.addValue("font-family", "Verdana");
            style.addValue("font-weight", "normal");
            style.addValue("font-size", "8pt");
            ss.registerStyle(style);
            style = new Style();
            style.setId("table");
            style.addValue("border", "solid 1px black");
            ss.registerStyle(style);
            File outputHtml = new File(this.getOutputHtmlPath());
            File dir = outputHtml.getParentFile();
            File cssFile = new File(dir, "export.css");
            FileOutputStream fos = new FileOutputStream(cssFile);
            ss.write(fos);
            fos.close();
            Element tableElement = document.createElement("table");
            bodyElement.appendChild(tableElement);
            int recordCount = this.database.getRecordCount();
            int fieldCount = this.database.getSchema().getFieldCount();
            this.setSteps(recordCount);
            Element tr = document.createElement("tr");
            tableElement.appendChild(tr);
            int i = 0;
            while (true) {
                if (i >= fieldCount) break;
                Element td = document.createElement("th");
                tr.appendChild(td);
                Text txt = document.createTextNode(String.valueOf(this.database.getSchema().getField(i).getName()));
                td.appendChild(txt);
                ++i;
            }
            i = 0;
            block4: while (true) {
                block8: {
                    if (i < recordCount) break block8;
                    TransformerFactory tfactory = TransformerFactory.newInstance();
                    Transformer transformer = tfactory.newTransformer();
                    DOMSource domSource = new DOMSource(document);
                    StreamResult streamResult = new StreamResult(new File(this.getOutputHtmlPath()));
                    transformer.transform(domSource, streamResult);
                    OutputStream os = streamResult.getOutputStream();
                    if (os != null) {
                        os.close();
                    }
                    break;
                }
                this.setStep(i + 1, "Exporting Record " + (i + 1));
                tr = document.createElement("tr");
                tableElement.appendChild(tr);
                PilotDBRecord record = (PilotDBRecord)this.database.getRecord(i);
                int dbColumnCount = fieldCount;
                int c = 0;
                while (true) {
                    if (c >= dbColumnCount) {
                        ++i;
                        continue block4;
                    }
                    Element td = document.createElement("td");
                    tr.appendChild(td);
                    Object value = record.getObject(c);
                    Text txt = document.createTextNode(String.valueOf(value));
                    td.appendChild(txt);
                    ++c;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var25_29 = null;
            this.done();
            throw throwable;
        }
        {
            Object var25_30 = null;
        }
        this.done();
    }

    public PilotDBDatabase getDatabase() {
        return this.database;
    }

    public void setDatabase(PilotDBDatabase database) {
        this.database = database;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public String getOutputHtmlPath() {
        return this.outputHtmlPath;
    }

    public String getPdbPath() {
        return this.pdbPath;
    }

    public void setConfigPath(String configPath) throws Exception {
        this.configPath = configPath;
        this.useConfigPath = true;
    }

    public void setOutputHtmlPath(String outputHtmlPath) throws Exception {
        this.outputHtmlPath = outputHtmlPath;
        this.outputHtmlFile = new File(outputHtmlPath);
        if (this.outputHtmlFile.exists() && !this.outputHtmlFile.canWrite()) {
            this.addError("{0} is not writable", new Object[]{outputHtmlPath});
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPdbPath(String pdbPath) {
        this.pdbPath = pdbPath;
        File f = new File(pdbPath);
        if (f.exists() && f.canRead()) {
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(f);
                    this.database = new PilotDBDatabase(fis);
                }
                catch (Exception e) {
                    this.addError("{0} is not a valid Pilot-DB", new Object[]{pdbPath});
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                try {
                    fis.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            {
                Object var5_7 = null;
                try {}
                catch (Exception exception) {
                    return;
                }
                fis.close();
                return;
            }
        }
        this.addError("{0} does not exists or is not readable", new Object[]{pdbPath});
    }

    public String getHtmlDbElementName() {
        return this.xmlDbElementName;
    }

    public String getHtmlRowElementName() {
        return this.xmlRowElementName;
    }

    public int getDbColumnCount() {
        return this.dbColumns.size();
    }

    public String getDbColumnName(int index) {
        return this.dbColumns.get(index).toString();
    }

    public String getHtmlElementNameForDbColumn(String columnName) {
        return String.valueOf(this.xmlColumnElementNames.get(columnName));
    }

    public Options getOptions() {
        Options options = new Options();
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("output");
        OptionBuilder.withDescription("the output file");
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt("output-file");
        Option o = OptionBuilder.create("o");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName("input");
        OptionBuilder.withDescription("the pdb file");
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt("input-file");
        Option p = OptionBuilder.create("p");
        options.addOption(o);
        options.addOption(p);
        return options;
    }
}

