/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.tools;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import pilotdb.tools.Plugin;
import pilotdb.tools.PluginMonitor;
import pilotdb.ui.GUI;

public class Tools
implements PluginMonitor {
    Options options = null;
    Options ieOptions = null;

    public Options getIEOptions() {
        if (this.ieOptions == null) {
            this.ieOptions = new Options();
            OptionBuilder.hasArg();
            OptionBuilder.withArgName("type");
            OptionBuilder.withLongOpt("type");
            OptionBuilder.isRequired();
            OptionBuilder.withDescription("the type of import/export csv/htmltable/xml");
            Option typeOption = OptionBuilder.create("t");
            this.ieOptions.addOption(typeOption);
        }
        return this.ieOptions;
    }

    public Options getOptions() {
        if (this.options == null) {
            this.options = new Options();
            OptionGroup optGroup = new OptionGroup();
            OptionBuilder.withDescription("starts the GUI");
            OptionBuilder.withLongOpt("gui");
            Option guiOption = OptionBuilder.create("g");
            OptionBuilder.withDescription("import a file");
            OptionBuilder.withLongOpt("import");
            Option importOption = OptionBuilder.create("i");
            OptionBuilder.withDescription("export a file");
            OptionBuilder.withLongOpt("export");
            Option exportOption = OptionBuilder.create("e");
            OptionBuilder.withDescription("show help");
            OptionBuilder.withLongOpt("help");
            Option helpOption = OptionBuilder.create("?");
            optGroup.addOption(guiOption);
            optGroup.addOption(importOption);
            optGroup.addOption(exportOption);
            optGroup.addOption(helpOption);
            optGroup.setRequired(true);
            this.options.addOptionGroup(optGroup);
        }
        return this.options;
    }

    private static CommandLine parse(Options opts, String[] args) {
        try {
            PosixParser parser = new PosixParser();
            return parser.parse(opts, args, false);
        }
        catch (ParseException exp) {
            System.err.println("Parsing failed.  Reason: " + exp.getMessage());
            HelpFormatter hf = new HelpFormatter();
            hf.printHelp(60, "java -jar jpilot-db.jar", "JPilot DB", opts, "footer");
            System.exit(1);
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        Tools main = new Tools();
        CommandLine line = null;
        String[] level1Args = new String[1];
        if (args.length == 0) {
            args = new String[]{"-g"};
        }
        if (args.length > 0) {
            level1Args[0] = args[0];
        } else {
            level1Args = args;
        }
        line = Tools.parse(main.getOptions(), level1Args);
        if (line.hasOption("g")) {
            GUI gui = new GUI();
            gui.start();
        } else if (line.hasOption("i")) {
            String[] level2Args = new String[Math.min(args.length - 1, 2)];
            System.arraycopy(args, 1, level2Args, 0, level2Args.length);
            line = Tools.parse(main.getIEOptions(), level2Args);
            String pluginType = line.getOptionValue("t");
            String pluginFQN = "pilotdb.tools.simplecreator." + pluginType + ".Plugin";
            Class<?> pluginClass = Class.forName(pluginFQN);
            Plugin plugin = (Plugin)pluginClass.newInstance();
            String[] level3Args = new String[args.length - 3];
            System.arraycopy(args, 3, level3Args, 0, args.length - 3);
            Options pluginOptions = plugin.getOptions();
            line = Tools.parse(pluginOptions, level3Args);
            plugin.configure(line);
            plugin.setPluginMonitor(main);
            plugin.setUp();
            plugin.execute();
            plugin.tearDown();
        } else if (line.hasOption("e")) {
            String[] level2Args = new String[Math.min(args.length - 1, 2)];
            System.arraycopy(args, 1, level2Args, 0, level2Args.length);
            line = Tools.parse(main.getIEOptions(), level2Args);
            String pluginType = line.getOptionValue("t");
            String pluginFQN = "pilotdb.tools.export." + pluginType + ".Plugin";
            Class<?> pluginClass = Class.forName(pluginFQN);
            Plugin plugin = (Plugin)pluginClass.newInstance();
            String[] level3Args = new String[args.length - 3];
            System.arraycopy(args, 3, level3Args, 0, args.length - 3);
            Options pluginOptions = plugin.getOptions();
            CommandLine cl = Tools.parse(pluginOptions, level3Args);
            plugin.configure(cl);
            plugin.setPluginMonitor(main);
            plugin.setUp();
            plugin.execute();
            plugin.tearDown();
        } else if (line.hasOption("?")) {
            HelpFormatter hf = new HelpFormatter();
            hf.printHelp(60, "java -jar jpilot-db.jar", "JPilot DB", main.getOptions(), "");
            System.out.flush();
            System.err.flush();
            System.exit(0);
        }
    }

    public void done() {
        System.out.println("done");
    }

    public void setError(String error) {
        System.err.println("ERROR: " + error);
    }

    public void setMessage(String message) {
        System.out.println("\n" + message);
    }

    public void setStep(int step, String message) {
        this.setStep(step);
        System.out.println("\n" + message);
    }

    public void setStep(int step) {
    }

    public void setSteps(int totalSteps) {
    }

    public void start() {
        System.out.println("start");
    }
}

