/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.conduit;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import palm.conduit.Record;
import palm.conduit.SyncManager;
import palmdb.PalmDbException;
import palmdb.util.ByteArray;
import pilotdb.PilotDBRecord;
import pilotdb.conduit.PilotDBSyncDatabase;

public class PilotDBSyncRecord
extends PilotDBRecord
implements Record {
    int categoryIndex;
    int recIndex;
    int syncRecordId;
    boolean isNew = true;

    public PilotDBSyncRecord(PilotDBSyncDatabase syncdb) throws IOException, PalmDbException {
        super(syncdb);
    }

    private void setOffset(int fieldIdx, short offset) {
        this.recordData.position(fieldIdx * 2);
        this.recordData.SHORT(offset, false);
    }

    private int getOffset(int fieldIdx) {
        this.recordData.position(fieldIdx * 2);
        return this.recordData.SHORT();
    }

    private int getOffsetCount() {
        return this.getSchema().getFieldCount();
    }

    public void saveToHH() throws IOException {
        int dbHandle = ((PilotDBSyncDatabase)this.database).getDBHandle();
        SyncManager.writeRec(dbHandle, this);
    }

    public void readData(DataInputStream dis) throws IOException {
        this.recordData = new ByteArray(dis.available());
        dis.readFully(this.recordData.getBytes());
        this.isNew = false;
    }

    public void writeData(DataOutputStream dos) throws IOException {
        dos.write(this.recordData.getBytes());
    }

    public int getId() {
        return this.syncRecordId;
    }

    public void setId(int parm1) {
        this.syncRecordId = parm1;
    }

    public int getIndex() {
        return this.recIndex;
    }

    public void setIndex(int parm1) {
        this.recIndex = parm1;
    }

    public int getCategoryIndex() {
        return this.categoryIndex;
    }

    public void setCategoryIndex(int parm1) {
        this.categoryIndex = parm1;
    }

    public boolean isModified() {
        return this.recordHeader.isDirty();
    }

    public void setIsModified(boolean parm1) {
        this.recordHeader.setDirty(parm1);
    }

    public boolean isDeleted() {
        return this.recordHeader.isDelete();
    }

    public void setIsDeleted(boolean parm1) {
        this.recordHeader.setDelete(parm1);
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setIsNew(boolean parm1) {
        this.isNew = parm1;
    }

    public boolean isPrivate() {
        return this.recordHeader.isSecret();
    }

    public void setIsPrivate(boolean parm1) {
        this.recordHeader.setSecret(parm1);
    }

    public boolean isArchived() {
        return false;
    }

    public void setIsArchived(boolean parm1) {
    }
}

