/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.calc;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import palmdb.util.ByteArray;
import pilotdb.PilotDBDate;
import pilotdb.PilotDBTime;
import pilotdb.calc.ByteCodeExpressionParser;
import pilotdb.calc.LispCodeExpressionParser;
import pilotdb.calc.Script;

public class TestScripts
extends TestCase {
    ByteCodeExpressionParser parser = new ByteCodeExpressionParser();
    LispCodeExpressionParser lispParser = new LispCodeExpressionParser();
    Script e = null;
    byte[] byteCode;
    ByteArray generated;
    static /* synthetic */ Class class$0;

    public void testMissingParen() throws Exception {
        try {
            String code = "+ 3 3)";
            LispCodeExpressionParser parser = new LispCodeExpressionParser();
            parser.parse(null, code);
            TestScripts.fail((String)"parsing should have failed");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIAddSC() throws Exception {
        String script = "(+ 3 4)";
        byte[] byArray = new byte[14];
        byArray[0] = 2;
        byArray[2] = 64;
        byArray[3] = 7;
        byArray[7] = 3;
        byArray[8] = 7;
        byArray[12] = 4;
        byArray[13] = 3;
        this.byteCode = byArray;
        this.checkSC(script, this.byteCode);
    }

    public void testIAddSG() throws Exception {
        String script = "(+ 3 4)";
        byte[] byArray = new byte[14];
        byArray[0] = 2;
        byArray[2] = 64;
        byArray[3] = 7;
        byArray[7] = 3;
        byArray[8] = 7;
        byArray[12] = 4;
        byArray[13] = 3;
        this.byteCode = byArray;
        this.checkSG(script, this.byteCode);
    }

    public void testIntegerAddition() throws Exception {
        byte[] byArray = new byte[14];
        byArray[0] = 2;
        byArray[2] = 64;
        byArray[3] = 7;
        byArray[7] = 3;
        byArray[8] = 7;
        byArray[12] = 4;
        byArray[13] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getInt(null), (int)7);
    }

    public void testISubtSG() throws Exception {
        String script = "(- 3 4)";
        byte[] byArray = new byte[14];
        byArray[0] = 2;
        byArray[1] = 1;
        byArray[2] = 64;
        byArray[3] = 7;
        byArray[7] = 3;
        byArray[8] = 7;
        byArray[12] = 4;
        byArray[13] = 3;
        this.byteCode = byArray;
        this.checkSG(script, this.byteCode);
    }

    public void testIntegerSubtraction() throws Exception {
        byte[] byArray = new byte[14];
        byArray[0] = 2;
        byArray[1] = 1;
        byArray[2] = 64;
        byArray[3] = 7;
        byArray[7] = 3;
        byArray[8] = 7;
        byArray[12] = 4;
        byArray[13] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getInt(null), (int)-1);
    }

    public void testISubSC() throws Exception {
        String script = "(- 3 4)";
        byte[] byArray = new byte[14];
        byArray[0] = 2;
        byArray[1] = 1;
        byArray[2] = 64;
        byArray[3] = 7;
        byArray[7] = 3;
        byArray[8] = 7;
        byArray[12] = 4;
        byArray[13] = 3;
        this.byteCode = byArray;
        this.checkSC(script, this.byteCode);
    }

    public void testIMultSC() throws Exception {
        String script = "(* 3 4)";
        byte[] byArray = new byte[14];
        byArray[0] = 2;
        byArray[1] = 2;
        byArray[2] = 64;
        byArray[3] = 7;
        byArray[7] = 3;
        byArray[8] = 7;
        byArray[12] = 4;
        byArray[13] = 3;
        this.byteCode = byArray;
        this.checkSC(script, this.byteCode);
    }

    public void testIMultSG() throws Exception {
        String script = "(* 3 4)";
        byte[] byArray = new byte[14];
        byArray[0] = 2;
        byArray[1] = 2;
        byArray[2] = 64;
        byArray[3] = 7;
        byArray[7] = 3;
        byArray[8] = 7;
        byArray[12] = 4;
        byArray[13] = 3;
        this.byteCode = byArray;
        this.checkSG(script, this.byteCode);
    }

    public void testIntegerMultiplication() throws Exception {
        byte[] byArray = new byte[14];
        byArray[0] = 2;
        byArray[1] = 2;
        byArray[2] = 64;
        byArray[3] = 7;
        byArray[7] = 3;
        byArray[8] = 7;
        byArray[12] = 4;
        byArray[13] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getInt(null), (int)12);
    }

    public void testIDivSC() throws Exception {
        String script = "(/ 3 4)";
        byte[] byArray = new byte[14];
        byArray[0] = 2;
        byArray[1] = 3;
        byArray[2] = 64;
        byArray[3] = 7;
        byArray[7] = 3;
        byArray[8] = 7;
        byArray[12] = 4;
        byArray[13] = 3;
        this.byteCode = byArray;
        this.checkSC(script, this.byteCode);
    }

    public void testIDivSG() throws Exception {
        String script = "(/ 3 4)";
        byte[] byArray = new byte[14];
        byArray[0] = 2;
        byArray[1] = 3;
        byArray[2] = 64;
        byArray[3] = 7;
        byArray[7] = 3;
        byArray[8] = 7;
        byArray[12] = 4;
        byArray[13] = 3;
        this.byteCode = byArray;
        this.checkSG(script, this.byteCode);
    }

    public void testIntegerDivision() throws Exception {
        byte[] byArray = new byte[14];
        byArray[0] = 2;
        byArray[1] = 3;
        byArray[2] = 64;
        byArray[3] = 7;
        byArray[7] = 3;
        byArray[8] = 7;
        byArray[12] = 4;
        byArray[13] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getInt(null), (int)0);
    }

    public void testFAddSC() throws Exception {
        byte[] byArray = new byte[22];
        byArray[0] = 2;
        byArray[2] = 65;
        byArray[3] = 8;
        byArray[4] = 64;
        byArray[5] = 8;
        byArray[12] = 8;
        byArray[13] = 64;
        byArray[14] = 16;
        byArray[21] = 3;
        this.byteCode = byArray;
        this.checkSC("(+ 3.0 4.0)", this.byteCode);
    }

    public void testFAddCG() throws Exception {
        byte[] byArray = new byte[22];
        byArray[0] = 2;
        byArray[2] = 65;
        byArray[3] = 8;
        byArray[4] = 64;
        byArray[5] = 8;
        byArray[12] = 8;
        byArray[13] = 64;
        byArray[14] = 16;
        byArray[21] = 3;
        this.byteCode = byArray;
        this.checkBC(this.byteCode);
    }

    public void testFloatAddition() throws Exception {
        byte[] byArray = new byte[22];
        byArray[0] = 2;
        byArray[2] = 65;
        byArray[3] = 8;
        byArray[4] = 64;
        byArray[5] = 8;
        byArray[12] = 8;
        byArray[13] = 64;
        byArray[14] = 16;
        byArray[21] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((double)7.0, (double)this.e.getFloat(null), (double)0.0);
    }

    public void testFSubtCG() throws Exception {
        byte[] byArray = new byte[22];
        byArray[0] = 2;
        byArray[1] = 1;
        byArray[2] = 65;
        byArray[3] = 8;
        byArray[4] = 64;
        byArray[5] = 8;
        byArray[12] = 8;
        byArray[13] = 64;
        byArray[14] = 16;
        byArray[21] = 3;
        this.byteCode = byArray;
        this.checkBC(this.byteCode);
    }

    public void testFloatSubtraction() throws Exception {
        byte[] byArray = new byte[22];
        byArray[0] = 2;
        byArray[1] = 1;
        byArray[2] = 65;
        byArray[3] = 8;
        byArray[4] = 64;
        byArray[5] = 8;
        byArray[12] = 8;
        byArray[13] = 64;
        byArray[14] = 16;
        byArray[21] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((double)-1.0, (double)this.e.getFloat(null), (double)0.0);
    }

    public void testFMultCG() throws Exception {
        byte[] byArray = new byte[22];
        byArray[0] = 2;
        byArray[1] = 2;
        byArray[2] = 65;
        byArray[3] = 8;
        byArray[4] = 64;
        byArray[5] = 8;
        byArray[12] = 8;
        byArray[13] = 64;
        byArray[14] = 16;
        byArray[21] = 3;
        this.byteCode = byArray;
        this.checkBC(this.byteCode);
    }

    public void testFloatMultiplication() throws Exception {
        byte[] byArray = new byte[22];
        byArray[0] = 2;
        byArray[1] = 2;
        byArray[2] = 65;
        byArray[3] = 8;
        byArray[4] = 64;
        byArray[5] = 8;
        byArray[12] = 8;
        byArray[13] = 64;
        byArray[14] = 16;
        byArray[21] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((double)12.0, (double)this.e.getFloat(null), (double)0.0);
    }

    public void testFDivCG() throws Exception {
        byte[] byArray = new byte[22];
        byArray[0] = 2;
        byArray[1] = 3;
        byArray[2] = 65;
        byArray[3] = 8;
        byArray[4] = 64;
        byArray[5] = 8;
        byArray[12] = 8;
        byArray[13] = 64;
        byArray[14] = 16;
        byArray[21] = 3;
        this.byteCode = byArray;
        this.checkBC(this.byteCode);
    }

    public void testFloatDivision() throws Exception {
        byte[] byArray = new byte[22];
        byArray[0] = 2;
        byArray[1] = 3;
        byArray[2] = 65;
        byArray[3] = 8;
        byArray[4] = 64;
        byArray[5] = 8;
        byArray[12] = 8;
        byArray[13] = 64;
        byArray[14] = 16;
        byArray[21] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((double)0.75, (double)this.e.getFloat(null), (double)0.0);
    }

    public void testRandomSC() throws Exception {
        this.byteCode = new byte[]{2, 11, 69, 3};
        this.checkSC("(rand)", this.byteCode);
    }

    public void testRandomCG() throws Exception {
        this.byteCode = new byte[]{2, 11, 69, 3};
        this.checkBC(this.byteCode);
    }

    public void testRandomSG() throws Exception {
        this.byteCode = new byte[]{2, 11, 69, 3};
        this.checkSG("(rand)", this.byteCode);
    }

    public void testRandom() throws Exception {
        this.byteCode = new byte[]{2, 11, 69, 3};
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Field Type", (int)2, (int)this.e.getType(null));
    }

    public void testEqIFSC() throws Exception {
        byte[] byArray = new byte[18];
        byArray[0] = 2;
        byArray[1] = 8;
        byArray[2] = 66;
        byArray[3] = 7;
        byArray[7] = 3;
        byArray[8] = 8;
        byArray[9] = 64;
        byArray[10] = 8;
        byArray[17] = 3;
        this.byteCode = byArray;
        this.checkSC("(eq 3 3.0)", this.byteCode);
    }

    public void testEqIFCG() throws Exception {
        byte[] byArray = new byte[18];
        byArray[0] = 2;
        byArray[1] = 8;
        byArray[2] = 66;
        byArray[3] = 7;
        byArray[7] = 3;
        byArray[8] = 8;
        byArray[9] = 64;
        byArray[10] = 8;
        byArray[17] = 3;
        this.byteCode = byArray;
        this.checkBC(this.byteCode);
    }

    public void testEqualityIntFloat() throws Exception {
        byte[] byArray = new byte[18];
        byArray[0] = 2;
        byArray[1] = 8;
        byArray[2] = 66;
        byArray[3] = 7;
        byArray[7] = 3;
        byArray[8] = 8;
        byArray[9] = 64;
        byArray[10] = 8;
        byArray[17] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getInt(null), (int)1);
        byte[] byArray2 = new byte[18];
        byArray2[0] = 2;
        byArray2[1] = 8;
        byArray2[2] = 66;
        byArray2[3] = 7;
        byArray2[7] = 4;
        byArray2[8] = 8;
        byArray2[9] = 64;
        byArray2[10] = 8;
        byArray2[17] = 3;
        this.byteCode = byArray2;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getInt(null), (int)0);
    }

    public void testSstrSC() throws Exception {
        String script = "(sstr abc ab)";
        byte[] byArray = new byte[13];
        byArray[0] = 2;
        byArray[1] = 10;
        byArray[2] = 67;
        byArray[3] = 6;
        byArray[4] = 97;
        byArray[5] = 98;
        byArray[6] = 99;
        byArray[8] = 6;
        byArray[9] = 97;
        byArray[10] = 98;
        byArray[12] = 3;
        this.byteCode = byArray;
        this.checkSC(script, this.byteCode);
    }

    public void testSstrSG() throws Exception {
        String script = "(sstr abc ab)";
        byte[] byArray = new byte[13];
        byArray[0] = 2;
        byArray[1] = 10;
        byArray[2] = 67;
        byArray[3] = 6;
        byArray[4] = 97;
        byArray[5] = 98;
        byArray[6] = 99;
        byArray[8] = 6;
        byArray[9] = 97;
        byArray[10] = 98;
        byArray[12] = 3;
        this.byteCode = byArray;
        this.checkSG(script, this.byteCode);
    }

    public void testSstrCG() throws Exception {
        byte[] byArray = new byte[13];
        byArray[0] = 2;
        byArray[1] = 10;
        byArray[2] = 67;
        byArray[3] = 6;
        byArray[4] = 97;
        byArray[5] = 98;
        byArray[6] = 99;
        byArray[8] = 6;
        byArray[9] = 97;
        byArray[10] = 98;
        byArray[12] = 3;
        this.byteCode = byArray;
        this.checkBC(this.byteCode);
    }

    public void testSstr() throws Exception {
        byte[] byArray = new byte[13];
        byArray[0] = 2;
        byArray[1] = 10;
        byArray[2] = 67;
        byArray[3] = 6;
        byArray[4] = 97;
        byArray[5] = 98;
        byArray[6] = 99;
        byArray[8] = 6;
        byArray[9] = 97;
        byArray[10] = 98;
        byArray[12] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Value", (int)1, (int)this.e.getInt(null));
        this.e.getInt(null);
        byte[] byArray2 = new byte[11];
        byArray2[0] = 2;
        byArray2[1] = 10;
        byArray2[2] = 67;
        byArray2[3] = 6;
        byArray2[5] = 6;
        byArray2[6] = 97;
        byArray2[7] = 98;
        byArray2[8] = 99;
        byArray2[10] = 3;
        this.byteCode = byArray2;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Value", (int)0, (int)this.e.getInt(null));
    }

    public void testSeqSC() throws Exception {
        String script = "(seq abc abc)";
        byte[] byArray = new byte[14];
        byArray[0] = 2;
        byArray[1] = 9;
        byArray[2] = 67;
        byArray[3] = 6;
        byArray[4] = 97;
        byArray[5] = 98;
        byArray[6] = 99;
        byArray[8] = 6;
        byArray[9] = 97;
        byArray[10] = 98;
        byArray[11] = 99;
        byArray[13] = 3;
        this.byteCode = byArray;
        this.checkSC(script, this.byteCode);
    }

    public void testSeqSG() throws Exception {
        String script = "(seq abc abc)";
        byte[] byArray = new byte[14];
        byArray[0] = 2;
        byArray[1] = 9;
        byArray[2] = 67;
        byArray[3] = 6;
        byArray[4] = 97;
        byArray[5] = 98;
        byArray[6] = 99;
        byArray[8] = 6;
        byArray[9] = 97;
        byArray[10] = 98;
        byArray[11] = 99;
        byArray[13] = 3;
        this.byteCode = byArray;
        this.checkSG(script, this.byteCode);
    }

    public void testSeqCG() throws Exception {
        byte[] byArray = new byte[14];
        byArray[0] = 2;
        byArray[1] = 9;
        byArray[2] = 67;
        byArray[3] = 6;
        byArray[4] = 97;
        byArray[5] = 98;
        byArray[6] = 99;
        byArray[8] = 6;
        byArray[9] = 97;
        byArray[10] = 98;
        byArray[11] = 99;
        byArray[13] = 3;
        this.byteCode = byArray;
        this.checkBC(this.byteCode);
    }

    public void testSeq() throws Exception {
        byte[] byArray = new byte[14];
        byArray[0] = 2;
        byArray[1] = 9;
        byArray[2] = 67;
        byArray[3] = 6;
        byArray[4] = 97;
        byArray[5] = 98;
        byArray[6] = 99;
        byArray[8] = 6;
        byArray[9] = 97;
        byArray[10] = 98;
        byArray[11] = 99;
        byArray[13] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Value", (int)1, (int)this.e.getInt(null));
        this.e.getInt(null);
        byte[] byArray2 = new byte[11];
        byArray2[0] = 2;
        byArray2[1] = 9;
        byArray2[2] = 67;
        byArray2[3] = 6;
        byArray2[5] = 6;
        byArray2[6] = 97;
        byArray2[7] = 98;
        byArray2[8] = 99;
        byArray2[10] = 3;
        this.byteCode = byArray2;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Value", (int)0, (int)this.e.getInt(null));
    }

    public void testEqFSC() throws Exception {
        byte[] byArray = new byte[22];
        byArray[0] = 2;
        byArray[1] = 8;
        byArray[2] = 66;
        byArray[3] = 8;
        byArray[4] = 64;
        byArray[5] = 8;
        byArray[12] = 8;
        byArray[13] = 64;
        byArray[14] = 8;
        byArray[21] = 3;
        this.byteCode = byArray;
        this.checkSC("(eq 3.0 3.0)", this.byteCode);
    }

    public void testEqFCG() throws Exception {
        byte[] byArray = new byte[22];
        byArray[0] = 2;
        byArray[1] = 8;
        byArray[2] = 66;
        byArray[3] = 8;
        byArray[4] = 64;
        byArray[5] = 8;
        byArray[12] = 8;
        byArray[13] = 64;
        byArray[14] = 8;
        byArray[21] = 3;
        this.byteCode = byArray;
        this.checkBC(this.byteCode);
    }

    public void testEqualityFloatFloat() throws Exception {
        byte[] byArray = new byte[22];
        byArray[0] = 2;
        byArray[1] = 8;
        byArray[2] = 66;
        byArray[3] = 8;
        byArray[4] = 64;
        byArray[5] = 8;
        byArray[12] = 8;
        byArray[13] = 64;
        byArray[14] = 8;
        byArray[21] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getInt(null), (int)1);
        byte[] byArray2 = new byte[22];
        byArray2[0] = 2;
        byArray2[1] = 8;
        byArray2[2] = 66;
        byArray2[3] = 8;
        byArray2[11] = 3;
        byArray2[12] = 8;
        byArray2[13] = 64;
        byArray2[14] = 8;
        byArray2[21] = 3;
        this.byteCode = byArray2;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getInt(null), (int)0);
    }

    public void testEqIISG() throws Exception {
        byte[] byArray = new byte[14];
        byArray[0] = 2;
        byArray[1] = 8;
        byArray[2] = 66;
        byArray[3] = 7;
        byArray[7] = 3;
        byArray[8] = 7;
        byArray[12] = 3;
        byArray[13] = 3;
        this.byteCode = byArray;
        this.checkSG("(eq 3 3)", this.byteCode);
    }

    public void testEqualityIntInt() throws Exception {
        byte[] byArray = new byte[14];
        byArray[0] = 2;
        byArray[1] = 8;
        byArray[2] = 66;
        byArray[3] = 7;
        byArray[7] = 3;
        byArray[8] = 7;
        byArray[12] = 3;
        byArray[13] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getInt(null), (int)1);
        byte[] byArray2 = new byte[14];
        byArray2[0] = 2;
        byArray2[1] = 8;
        byArray2[2] = 66;
        byArray2[3] = 7;
        byArray2[7] = 4;
        byArray2[8] = 7;
        byArray2[12] = 3;
        byArray2[13] = 3;
        this.byteCode = byArray2;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getInt(null), (int)0);
    }

    public void testGECG() throws Exception {
        byte[] byArray = new byte[18];
        byArray[0] = 2;
        byArray[1] = 7;
        byArray[2] = 66;
        byArray[3] = 7;
        byArray[7] = 3;
        byArray[8] = 8;
        byArray[9] = 64;
        byArray[10] = 8;
        byArray[17] = 3;
        this.byteCode = byArray;
        this.checkBC(this.byteCode);
    }

    public void testGESG() throws Exception {
        byte[] byArray = new byte[14];
        byArray[0] = 2;
        byArray[1] = 7;
        byArray[2] = 66;
        byArray[3] = 7;
        byArray[7] = 3;
        byArray[8] = 7;
        byArray[12] = 4;
        byArray[13] = 3;
        this.byteCode = byArray;
        this.checkSG("(ge 3 4)", this.byteCode);
    }

    public void testGreaterThanEqualTo() throws Exception {
        byte[] byArray = new byte[18];
        byArray[0] = 2;
        byArray[1] = 7;
        byArray[2] = 66;
        byArray[3] = 7;
        byArray[7] = 3;
        byArray[8] = 8;
        byArray[9] = 64;
        byArray[10] = 8;
        byArray[17] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getInt(null), (int)1);
        byte[] byArray2 = new byte[18];
        byArray2[0] = 2;
        byArray2[1] = 7;
        byArray2[2] = 66;
        byArray2[3] = 8;
        byArray2[4] = 64;
        byArray2[5] = 8;
        byArray2[12] = 7;
        byArray2[16] = 3;
        byArray2[17] = 3;
        this.byteCode = byArray2;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getInt(null), (int)1);
        byte[] byArray3 = new byte[18];
        byArray3[0] = 2;
        byArray3[1] = 7;
        byArray3[2] = 66;
        byArray3[3] = 8;
        byArray3[4] = 64;
        byArray3[5] = 8;
        byArray3[12] = 7;
        byArray3[16] = 4;
        byArray3[17] = 3;
        this.byteCode = byArray3;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getInt(null), (int)0);
        byte[] byArray4 = new byte[18];
        byArray4[0] = 2;
        byArray4[1] = 7;
        byArray4[2] = 66;
        byArray4[3] = 7;
        byArray4[7] = 4;
        byArray4[8] = 8;
        byArray4[9] = 64;
        byArray4[10] = 8;
        byArray4[17] = 3;
        this.byteCode = byArray4;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getInt(null), (int)1);
        byte[] byArray5 = new byte[22];
        byArray5[0] = 2;
        byArray5[1] = 7;
        byArray5[2] = 66;
        byArray5[3] = 8;
        byArray5[4] = 64;
        byArray5[5] = 8;
        byArray5[12] = 8;
        byArray5[13] = 64;
        byArray5[14] = 8;
        byArray5[21] = 3;
        this.byteCode = byArray5;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getInt(null), (int)1);
    }

    public void testTestSG() throws Exception {
        byte[] byArray = new byte[27];
        byArray[0] = 1;
        byArray[1] = -124;
        byArray[2] = 2;
        byArray[3] = 8;
        byArray[4] = 66;
        byArray[5] = 7;
        byArray[9] = 3;
        byArray[10] = 7;
        byArray[14] = 4;
        byArray[15] = 3;
        byArray[16] = 7;
        byArray[20] = 5;
        byArray[21] = 7;
        byArray[25] = 7;
        byArray[26] = 3;
        this.byteCode = byArray;
        this.checkSG("(? (eq 3 4) 5 7)", this.byteCode);
    }

    public void testTestSC() throws Exception {
        byte[] byArray = new byte[27];
        byArray[0] = 1;
        byArray[1] = -124;
        byArray[2] = 2;
        byArray[3] = 8;
        byArray[4] = 66;
        byArray[5] = 7;
        byArray[9] = 3;
        byArray[10] = 7;
        byArray[14] = 4;
        byArray[15] = 3;
        byArray[16] = 7;
        byArray[20] = 5;
        byArray[21] = 7;
        byArray[25] = 7;
        byArray[26] = 3;
        this.byteCode = byArray;
        this.checkSC("(? (eq 3 4) 5 7)", this.byteCode);
    }

    public void testTestCG() throws Exception {
        byte[] byArray = new byte[27];
        byArray[0] = 1;
        byArray[1] = -124;
        byArray[2] = 2;
        byArray[3] = 8;
        byArray[4] = 66;
        byArray[5] = 7;
        byArray[9] = 3;
        byArray[10] = 7;
        byArray[14] = 4;
        byArray[15] = 3;
        byArray[16] = 7;
        byArray[20] = 5;
        byArray[21] = 7;
        byArray[25] = 7;
        byArray[26] = 3;
        this.byteCode = byArray;
        this.checkBC(this.byteCode);
    }

    public void testTestOperation() throws Exception {
        byte[] byArray = new byte[27];
        byArray[0] = 1;
        byArray[1] = -124;
        byArray[2] = 2;
        byArray[3] = 8;
        byArray[4] = 66;
        byArray[5] = 7;
        byArray[9] = 3;
        byArray[10] = 7;
        byArray[14] = 4;
        byArray[15] = 3;
        byArray[16] = 7;
        byArray[20] = 5;
        byArray[21] = 7;
        byArray[25] = 7;
        byArray[26] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getInt(null), (int)7);
        byte[] byArray2 = new byte[27];
        byArray2[0] = 1;
        byArray2[1] = -124;
        byArray2[2] = 2;
        byArray2[3] = 8;
        byArray2[4] = 66;
        byArray2[5] = 7;
        byArray2[9] = 3;
        byArray2[10] = 7;
        byArray2[14] = 3;
        byArray2[15] = 3;
        byArray2[16] = 7;
        byArray2[20] = 5;
        byArray2[21] = 7;
        byArray2[25] = 7;
        byArray2[26] = 3;
        this.byteCode = byArray2;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getInt(null), (int)5);
    }

    public void testGTCG() throws Exception {
        byte[] byArray = new byte[18];
        byArray[0] = 2;
        byArray[1] = 6;
        byArray[2] = 66;
        byArray[3] = 7;
        byArray[7] = 3;
        byArray[8] = 8;
        byArray[9] = 64;
        byArray[10] = 8;
        byArray[17] = 3;
        this.byteCode = byArray;
        this.checkBC(this.byteCode);
    }

    public void testGTSG() throws Exception {
        byte[] byArray = new byte[14];
        byArray[0] = 2;
        byArray[1] = 6;
        byArray[2] = 66;
        byArray[3] = 7;
        byArray[7] = 3;
        byArray[8] = 7;
        byArray[12] = 4;
        byArray[13] = 3;
        this.byteCode = byArray;
        this.checkSG("(gt 3 4)", this.byteCode);
    }

    public void testGTSC() throws Exception {
        byte[] byArray = new byte[14];
        byArray[0] = 2;
        byArray[1] = 6;
        byArray[2] = 66;
        byArray[3] = 7;
        byArray[7] = 3;
        byArray[8] = 7;
        byArray[12] = 4;
        byArray[13] = 3;
        this.byteCode = byArray;
        this.checkSC("(gt 3 4)", this.byteCode);
    }

    public void testGreaterThan() throws Exception {
        byte[] byArray = new byte[18];
        byArray[0] = 2;
        byArray[1] = 6;
        byArray[2] = 66;
        byArray[3] = 7;
        byArray[7] = 3;
        byArray[8] = 8;
        byArray[9] = 64;
        byArray[10] = 8;
        byArray[17] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getInt(null), (int)0);
        byte[] byArray2 = new byte[18];
        byArray2[0] = 2;
        byArray2[1] = 6;
        byArray2[2] = 66;
        byArray2[3] = 8;
        byArray2[4] = 64;
        byArray2[5] = 8;
        byArray2[12] = 7;
        byArray2[16] = 3;
        byArray2[17] = 3;
        this.byteCode = byArray2;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getInt(null), (int)0);
        byte[] byArray3 = new byte[18];
        byArray3[0] = 2;
        byArray3[1] = 6;
        byArray3[2] = 66;
        byArray3[3] = 8;
        byArray3[4] = 64;
        byArray3[5] = 8;
        byArray3[12] = 7;
        byArray3[16] = 4;
        byArray3[17] = 3;
        this.byteCode = byArray3;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getInt(null), (int)0);
        byte[] byArray4 = new byte[18];
        byArray4[0] = 2;
        byArray4[1] = 6;
        byArray4[2] = 66;
        byArray4[3] = 7;
        byArray4[7] = 4;
        byArray4[8] = 8;
        byArray4[9] = 64;
        byArray4[10] = 8;
        byArray4[17] = 3;
        this.byteCode = byArray4;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getInt(null), (int)1);
        byte[] byArray5 = new byte[22];
        byArray5[0] = 2;
        byArray5[1] = 6;
        byArray5[2] = 66;
        byArray5[3] = 8;
        byArray5[4] = 64;
        byArray5[5] = 8;
        byArray5[12] = 8;
        byArray5[13] = 64;
        byArray5[14] = 8;
        byArray5[21] = 3;
        this.byteCode = byArray5;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getInt(null), (int)0);
    }

    public void testLTSC() throws Exception {
        byte[] byArray = new byte[14];
        byArray[0] = 2;
        byArray[1] = 4;
        byArray[2] = 66;
        byArray[3] = 7;
        byArray[7] = 3;
        byArray[8] = 7;
        byArray[12] = 4;
        byArray[13] = 3;
        this.byteCode = byArray;
        this.checkSC("(lt 3 4)", this.byteCode);
    }

    public void testLTSG() throws Exception {
        byte[] byArray = new byte[14];
        byArray[0] = 2;
        byArray[1] = 4;
        byArray[2] = 66;
        byArray[3] = 7;
        byArray[7] = 3;
        byArray[8] = 7;
        byArray[12] = 4;
        byArray[13] = 3;
        this.byteCode = byArray;
        this.checkSG("(lt 3 4)", this.byteCode);
    }

    public void testLTCG() throws Exception {
        byte[] byArray = new byte[18];
        byArray[0] = 2;
        byArray[1] = 4;
        byArray[2] = 66;
        byArray[3] = 7;
        byArray[7] = 3;
        byArray[8] = 8;
        byArray[9] = 64;
        byArray[10] = 8;
        byArray[17] = 3;
        this.byteCode = byArray;
        this.checkBC(this.byteCode);
        byte[] byArray2 = new byte[18];
        byArray2[0] = 2;
        byArray2[1] = 4;
        byArray2[2] = 66;
        byArray2[3] = 8;
        byArray2[4] = 64;
        byArray2[5] = 8;
        byArray2[12] = 7;
        byArray2[16] = 3;
        byArray2[17] = 3;
        this.byteCode = byArray2;
        this.checkBC(this.byteCode);
        byte[] byArray3 = new byte[18];
        byArray3[0] = 2;
        byArray3[1] = 4;
        byArray3[2] = 66;
        byArray3[3] = 8;
        byArray3[4] = 64;
        byArray3[5] = 8;
        byArray3[12] = 7;
        byArray3[16] = 4;
        byArray3[17] = 3;
        this.byteCode = byArray3;
        this.checkBC(this.byteCode);
        byte[] byArray4 = new byte[22];
        byArray4[0] = 2;
        byArray4[1] = 4;
        byArray4[2] = 66;
        byArray4[3] = 8;
        byArray4[4] = 64;
        byArray4[5] = 8;
        byArray4[12] = 8;
        byArray4[13] = 64;
        byArray4[14] = 8;
        byArray4[21] = 3;
        this.byteCode = byArray4;
        this.checkBC(this.byteCode);
    }

    public void testLessThan() throws Exception {
        byte[] byArray = new byte[18];
        byArray[0] = 2;
        byArray[1] = 4;
        byArray[2] = 66;
        byArray[3] = 7;
        byArray[7] = 3;
        byArray[8] = 8;
        byArray[9] = 64;
        byArray[10] = 8;
        byArray[17] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getInt(null), (int)0);
        byte[] byArray2 = new byte[18];
        byArray2[0] = 2;
        byArray2[1] = 4;
        byArray2[2] = 66;
        byArray2[3] = 8;
        byArray2[4] = 64;
        byArray2[5] = 8;
        byArray2[12] = 7;
        byArray2[16] = 3;
        byArray2[17] = 3;
        this.byteCode = byArray2;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getInt(null), (int)0);
        byte[] byArray3 = new byte[18];
        byArray3[0] = 2;
        byArray3[1] = 4;
        byArray3[2] = 66;
        byArray3[3] = 8;
        byArray3[4] = 64;
        byArray3[5] = 8;
        byArray3[12] = 7;
        byArray3[16] = 4;
        byArray3[17] = 3;
        this.byteCode = byArray3;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getInt(null), (int)1);
        byte[] byArray4 = new byte[18];
        byArray4[0] = 2;
        byArray4[1] = 4;
        byArray4[2] = 66;
        byArray4[3] = 7;
        byArray4[7] = 4;
        byArray4[8] = 8;
        byArray4[9] = 64;
        byArray4[10] = 8;
        byArray4[17] = 3;
        this.byteCode = byArray4;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getInt(null), (int)0);
        byte[] byArray5 = new byte[22];
        byArray5[0] = 2;
        byArray5[1] = 4;
        byArray5[2] = 66;
        byArray5[3] = 8;
        byArray5[4] = 64;
        byArray5[5] = 8;
        byArray5[12] = 8;
        byArray5[13] = 64;
        byArray5[14] = 8;
        byArray5[21] = 3;
        this.byteCode = byArray5;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getInt(null), (int)0);
    }

    public void testLESG() throws Exception {
        byte[] byArray = new byte[14];
        byArray[0] = 2;
        byArray[1] = 5;
        byArray[2] = 66;
        byArray[3] = 7;
        byArray[7] = 3;
        byArray[8] = 7;
        byArray[12] = 4;
        byArray[13] = 3;
        this.byteCode = byArray;
        this.checkSG("(le 3 4)", this.byteCode);
    }

    public void testLESC() throws Exception {
        byte[] byArray = new byte[14];
        byArray[0] = 2;
        byArray[1] = 5;
        byArray[2] = 66;
        byArray[3] = 7;
        byArray[7] = 3;
        byArray[8] = 7;
        byArray[12] = 4;
        byArray[13] = 3;
        this.byteCode = byArray;
        this.checkSC("(le 3 4)", this.byteCode);
    }

    public void testLECG() throws Exception {
        byte[] byArray = new byte[18];
        byArray[0] = 2;
        byArray[1] = 5;
        byArray[2] = 66;
        byArray[3] = 7;
        byArray[7] = 3;
        byArray[8] = 8;
        byArray[9] = 64;
        byArray[10] = 8;
        byArray[17] = 3;
        this.byteCode = byArray;
        this.checkBC(this.byteCode);
    }

    public void testLessThanEqualTo() throws Exception {
        byte[] byArray = new byte[18];
        byArray[0] = 2;
        byArray[1] = 5;
        byArray[2] = 66;
        byArray[3] = 7;
        byArray[7] = 3;
        byArray[8] = 8;
        byArray[9] = 64;
        byArray[10] = 8;
        byArray[17] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getInt(null), (int)1);
        byte[] byArray2 = new byte[18];
        byArray2[0] = 2;
        byArray2[1] = 5;
        byArray2[2] = 66;
        byArray2[3] = 8;
        byArray2[4] = 64;
        byArray2[5] = 8;
        byArray2[12] = 7;
        byArray2[16] = 3;
        byArray2[17] = 3;
        this.byteCode = byArray2;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getInt(null), (int)1);
        byte[] byArray3 = new byte[18];
        byArray3[0] = 2;
        byArray3[1] = 5;
        byArray3[2] = 66;
        byArray3[3] = 8;
        byArray3[4] = 64;
        byArray3[5] = 8;
        byArray3[12] = 7;
        byArray3[16] = 4;
        byArray3[17] = 3;
        this.byteCode = byArray3;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getInt(null), (int)1);
        byte[] byArray4 = new byte[18];
        byArray4[0] = 2;
        byArray4[1] = 5;
        byArray4[2] = 66;
        byArray4[3] = 7;
        byArray4[7] = 4;
        byArray4[8] = 8;
        byArray4[9] = 64;
        byArray4[10] = 8;
        byArray4[17] = 3;
        this.byteCode = byArray4;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getInt(null), (int)0);
        byte[] byArray5 = new byte[22];
        byArray5[0] = 2;
        byArray5[1] = 5;
        byArray5[2] = 66;
        byArray5[3] = 8;
        byArray5[4] = 64;
        byArray5[5] = 8;
        byArray5[12] = 8;
        byArray5[13] = 64;
        byArray5[14] = 8;
        byArray5[21] = 3;
        this.byteCode = byArray5;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getInt(null), (int)1);
    }

    public void testBrSC() throws Exception {
        byte[] byArray = new byte[23];
        byArray[0] = 1;
        byArray[1] = -125;
        byArray[2] = 7;
        byArray[7] = 7;
        byArray[11] = 1;
        byArray[12] = 7;
        byArray[16] = 2;
        byArray[17] = 7;
        byArray[21] = 3;
        byArray[22] = 3;
        this.byteCode = byArray;
        this.checkSC("(br 0 1 2 3)", this.byteCode);
        byte[] byArray2 = new byte[29];
        byArray2[0] = 1;
        byArray2[1] = -125;
        byArray2[2] = 2;
        byArray2[3] = 5;
        byArray2[4] = 66;
        byArray2[5] = 5;
        byArray2[7] = 7;
        byArray2[11] = 4;
        byArray2[12] = 3;
        byArray2[13] = 7;
        byArray2[17] = 1;
        byArray2[18] = 7;
        byArray2[22] = 2;
        byArray2[23] = 7;
        byArray2[27] = 3;
        byArray2[28] = 3;
        this.byteCode = byArray2;
        this.checkSC("(br (le %0 4) 1 2 3)", this.byteCode);
    }

    public void testBrSG() throws Exception {
        byte[] byArray = new byte[23];
        byArray[0] = 1;
        byArray[1] = -125;
        byArray[2] = 7;
        byArray[7] = 7;
        byArray[11] = 1;
        byArray[12] = 7;
        byArray[16] = 2;
        byArray[17] = 7;
        byArray[21] = 3;
        byArray[22] = 3;
        this.byteCode = byArray;
        this.checkSG("(br 0 1 2 3)", this.byteCode);
        byte[] byArray2 = new byte[32];
        byArray2[0] = 1;
        byArray2[1] = -125;
        byArray2[2] = 2;
        byArray2[3] = 5;
        byArray2[4] = 66;
        byArray2[5] = 7;
        byArray2[9] = 3;
        byArray2[10] = 7;
        byArray2[14] = 4;
        byArray2[15] = 3;
        byArray2[16] = 7;
        byArray2[20] = 1;
        byArray2[21] = 7;
        byArray2[25] = 2;
        byArray2[26] = 7;
        byArray2[30] = 3;
        byArray2[31] = 3;
        this.byteCode = byArray2;
        this.checkSG("(br (le 3 4) 1 2 3)", this.byteCode);
    }

    public void testBrCG() throws Exception {
        byte[] byArray = new byte[23];
        byArray[0] = 1;
        byArray[1] = -125;
        byArray[2] = 7;
        byArray[7] = 7;
        byArray[11] = 1;
        byArray[12] = 7;
        byArray[16] = 2;
        byArray[17] = 7;
        byArray[21] = 3;
        byArray[22] = 3;
        this.byteCode = byArray;
        this.checkBC(this.byteCode);
    }

    public void testBranchII() throws Exception {
        byte[] byArray = new byte[23];
        byArray[0] = 1;
        byArray[1] = -125;
        byArray[2] = 7;
        byArray[7] = 7;
        byArray[11] = 1;
        byArray[12] = 7;
        byArray[16] = 2;
        byArray[17] = 7;
        byArray[21] = 3;
        byArray[22] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)2, (int)this.e.getType(null));
        TestScripts.assertEquals((int)1, (int)this.e.getInt(null));
        byte[] byArray2 = new byte[23];
        byArray2[0] = 1;
        byArray2[1] = -125;
        byArray2[2] = 7;
        byArray2[6] = 2;
        byArray2[7] = 7;
        byArray2[11] = 1;
        byArray2[12] = 7;
        byArray2[16] = 2;
        byArray2[17] = 7;
        byArray2[21] = 3;
        byArray2[22] = 3;
        this.byteCode = byArray2;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getType(null), (int)2);
        TestScripts.assertEquals((int)this.e.getInt(null), (int)3);
        byte[] byArray3 = new byte[23];
        byArray3[0] = 1;
        byArray3[1] = -125;
        byArray3[2] = 7;
        byArray3[6] = 4;
        byArray3[7] = 7;
        byArray3[11] = 1;
        byArray3[12] = 7;
        byArray3[16] = 2;
        byArray3[17] = 7;
        byArray3[21] = 3;
        byArray3[22] = 3;
        this.byteCode = byArray3;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((int)this.e.getType(null), (int)2);
        TestScripts.assertEquals((int)this.e.getInt(null), (int)3);
    }

    public void testBranchFF() throws Exception {
        byte[] byArray = new byte[35];
        byArray[0] = 1;
        byArray[1] = -125;
        byArray[2] = 7;
        byArray[7] = 8;
        byArray[8] = 64;
        byArray[9] = 8;
        byArray[16] = 8;
        byArray[17] = 64;
        byArray[18] = 9;
        byArray[25] = 8;
        byArray[26] = 64;
        byArray[27] = 10;
        byArray[34] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Field Type", (int)8, (int)this.e.getType(null));
        TestScripts.assertEquals((String)"Value", (double)3.0, (double)this.e.getFloat(null), (double)0.0);
    }

    public void testBranchDD() throws Exception {
        byte[] byArray = new byte[23];
        byArray[0] = 1;
        byArray[1] = -125;
        byArray[2] = 7;
        byArray[7] = 9;
        byArray[8] = 7;
        byArray[9] = -45;
        byArray[10] = 10;
        byArray[11] = 9;
        byArray[12] = 9;
        byArray[15] = 7;
        byArray[16] = 9;
        byArray[17] = 9;
        byArray[20] = 6;
        byArray[21] = 10;
        byArray[22] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Field Type", (int)3, (int)this.e.getType(null));
        TestScripts.assertEquals((String)"Value", (Object)new PilotDBDate(2003, 10, 9), (Object)this.e.getDate(null));
    }

    public void testBranchDDSC() throws Exception {
        byte[] byArray = new byte[23];
        byArray[0] = 1;
        byArray[1] = -125;
        byArray[2] = 7;
        byArray[7] = 9;
        byArray[8] = 7;
        byArray[9] = -45;
        byArray[10] = 10;
        byArray[11] = 9;
        byArray[12] = 9;
        byArray[13] = 7;
        byArray[14] = -45;
        byArray[15] = 7;
        byArray[16] = 9;
        byArray[17] = 9;
        byArray[18] = 7;
        byArray[19] = -45;
        byArray[20] = 6;
        byArray[21] = 10;
        byArray[22] = 3;
        this.byteCode = byArray;
        this.checkSC("(br 0 2003/10/9 2003/7/9 2003/6/10)", this.byteCode);
    }

    public void testBranchTTSC() throws Exception {
        byte[] byArray = new byte[17];
        byArray[0] = 1;
        byArray[1] = -125;
        byArray[2] = 7;
        byArray[7] = 10;
        byArray[8] = 7;
        byArray[9] = 30;
        byArray[10] = 10;
        byArray[11] = 18;
        byArray[12] = 30;
        byArray[13] = 10;
        byArray[14] = 5;
        byArray[15] = 30;
        byArray[16] = 3;
        this.byteCode = byArray;
        this.checkSC("(br 0 7:30 18:30 5:30)", this.byteCode);
    }

    public void testBranchTT() throws Exception {
        byte[] byArray = new byte[17];
        byArray[0] = 1;
        byArray[1] = -125;
        byArray[2] = 7;
        byArray[7] = 10;
        byArray[8] = 7;
        byArray[9] = 30;
        byArray[10] = 10;
        byArray[11] = 6;
        byArray[12] = 30;
        byArray[13] = 10;
        byArray[14] = 5;
        byArray[15] = 30;
        byArray[16] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Field Type", (int)4, (int)this.e.getType(null));
        TestScripts.assertEquals((String)"Value", (Object)new PilotDBTime(7, 30), (Object)this.e.getTime(null));
    }

    public void testBrSSCG() throws Exception {
        byte[] byArray = new byte[17];
        byArray[0] = 1;
        byArray[1] = -125;
        byArray[2] = 7;
        byArray[7] = 6;
        byArray[8] = 97;
        byArray[10] = 6;
        byArray[11] = 97;
        byArray[13] = 6;
        byArray[14] = 97;
        byArray[16] = 3;
        this.byteCode = byArray;
        this.checkBC(this.byteCode);
    }

    public void testBrSSSC() throws Exception {
        byte[] byArray = new byte[17];
        byArray[0] = 1;
        byArray[1] = -125;
        byArray[2] = 7;
        byArray[7] = 6;
        byArray[8] = 97;
        byArray[10] = 6;
        byArray[11] = 97;
        byArray[13] = 6;
        byArray[14] = 97;
        byArray[16] = 3;
        this.byteCode = byArray;
        this.checkSC("(br 0 a a a)", this.byteCode);
    }

    public void testBranchSS() throws Exception {
        byte[] byArray = new byte[17];
        byArray[0] = 1;
        byArray[1] = -125;
        byArray[2] = 7;
        byArray[7] = 6;
        byArray[8] = 97;
        byArray[10] = 6;
        byArray[11] = 97;
        byArray[13] = 6;
        byArray[14] = 97;
        byArray[16] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Field Type", (int)0, (int)this.e.getType(null));
        TestScripts.assertEquals((String)"Value", (Object)"a", (Object)this.e.getString(null));
    }

    public void testBranchFI() throws Exception {
        byte[] byArray = new byte[27];
        byArray[0] = 1;
        byArray[1] = -125;
        byArray[2] = 7;
        byArray[7] = 7;
        byArray[11] = 4;
        byArray[12] = 8;
        byArray[13] = 64;
        byArray[14] = 8;
        byArray[21] = 7;
        byArray[25] = 5;
        byArray[26] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Field Type", (int)8, (int)this.e.getType(null));
        TestScripts.assertEquals((String)"Value", (double)4.0, (double)this.e.getFloat(null), (double)0.0);
    }

    public void testBranchDT() throws Exception {
        byte[] byArray = new byte[19];
        byArray[0] = 1;
        byArray[1] = -125;
        byArray[2] = 7;
        byArray[7] = 9;
        byArray[8] = 7;
        byArray[9] = -45;
        byArray[10] = 10;
        byArray[11] = 9;
        byArray[12] = 10;
        byArray[13] = 6;
        byArray[14] = 30;
        byArray[15] = 10;
        byArray[16] = 5;
        byArray[17] = 30;
        byArray[18] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Field Type", (int)0, (int)this.e.getType(null));
        TestScripts.assertEquals((String)"Value", (Object)new PilotDBDate(2003, 10, 9).toString(), (Object)this.e.getString(null));
    }

    public void testBranchSI() throws Exception {
        byte[] byArray = new byte[16];
        byArray[0] = 1;
        byArray[1] = -125;
        byArray[2] = 7;
        byArray[6] = 1;
        byArray[7] = 6;
        byArray[8] = 97;
        byArray[10] = 7;
        byArray[14] = 4;
        byArray[15] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Field Type", (int)0, (int)this.e.getType(null));
        TestScripts.assertEquals((String)"Value", (Object)"4", (Object)this.e.getString(null));
    }

    public void testAllCG() throws Exception {
        byte[] byArray = new byte[18];
        byArray[0] = 1;
        byArray[1] = -126;
        byArray[2] = 7;
        byArray[6] = 1;
        byArray[7] = 7;
        byArray[11] = 2;
        byArray[12] = 7;
        byArray[16] = 3;
        byArray[17] = 3;
        this.byteCode = byArray;
        this.checkBC(this.byteCode);
    }

    public void testAllI() throws Exception {
        byte[] byArray = new byte[18];
        byArray[0] = 1;
        byArray[1] = -126;
        byArray[2] = 7;
        byArray[6] = 1;
        byArray[7] = 7;
        byArray[11] = 2;
        byArray[12] = 7;
        byArray[16] = 3;
        byArray[17] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Field Type", (int)2, (int)this.e.getType(null));
        TestScripts.assertEquals((String)"Value", (int)3, (int)this.e.getInt(null));
    }

    public void testAllF() throws Exception {
        byte[] byArray = new byte[30];
        byArray[0] = 1;
        byArray[1] = -126;
        byArray[2] = 8;
        byArray[3] = 64;
        byArray[4] = 7;
        byArray[11] = 8;
        byArray[12] = 64;
        byArray[13] = 9;
        byArray[20] = 8;
        byArray[21] = 64;
        byArray[22] = 8;
        byArray[29] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Field Type", (int)8, (int)this.e.getType(null));
        TestScripts.assertEquals((String)"Value", (double)3.0, (double)this.e.getFloat(null), (double)0.0);
    }

    public void testAllD() throws Exception {
        this.byteCode = new byte[]{1, -126, 9, 7, -45, 10, 10, 9, 7, -45, 10, 11, 9, 7, -45, 10, 12, 3};
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Field Type", (int)3, (int)this.e.getType(null));
        TestScripts.assertEquals((String)"Value", (Object)new PilotDBDate(2003, 10, 12), (Object)this.e.getDate(null));
    }

    public void testAllDSG() throws Exception {
        this.byteCode = new byte[]{1, -126, 9, 7, -45, 10, 10, 9, 7, -45, 10, 11, 9, 7, -45, 10, 12, 3};
        this.checkSG("(all 03/10/10 03/10/11 03/10/12)", this.byteCode);
    }

    public void testAllDSC() throws Exception {
        this.byteCode = new byte[]{1, -126, 9, 7, -45, 10, 10, 9, 7, -45, 10, 11, 9, 7, -45, 10, 12, 3};
        this.checkSC("(all 03/10/10 03/10/11 03/10/12)", this.byteCode);
    }

    public void testAllT() throws Exception {
        this.byteCode = new byte[]{1, -126, 10, 6, 30, 10, 7, 30, 10, 8, 30, 3};
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Field Type", (int)4, (int)this.e.getType(null));
        TestScripts.assertEquals((String)"Value", (Object)new PilotDBTime(8, 30), (Object)this.e.getTime(null));
    }

    public void testAllS() throws Exception {
        byte[] byArray = new byte[12];
        byArray[0] = 1;
        byArray[1] = -126;
        byArray[2] = 6;
        byArray[3] = 97;
        byArray[5] = 6;
        byArray[6] = 98;
        byArray[8] = 6;
        byArray[9] = 99;
        byArray[11] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Field Type", (int)0, (int)this.e.getType(null));
        TestScripts.assertEquals((String)"Value", (Object)"c", (Object)this.e.getString(null));
    }

    public void testNotSC() throws Exception {
        byte[] byArray = new byte[8];
        byArray[0] = 1;
        byArray[1] = -123;
        byArray[2] = 7;
        byArray[6] = 1;
        byArray[7] = 3;
        this.byteCode = byArray;
        this.checkSC("(!1)", this.byteCode);
        this.checkSC("(! 1 )", this.byteCode);
    }

    public void testNotCG() throws Exception {
        byte[] byArray = new byte[8];
        byArray[0] = 1;
        byArray[1] = -123;
        byArray[2] = 7;
        byArray[6] = 1;
        byArray[7] = 3;
        this.byteCode = byArray;
        this.checkBC(this.byteCode);
    }

    public void testNotI() throws Exception {
        byte[] byArray = new byte[8];
        byArray[0] = 1;
        byArray[1] = -123;
        byArray[2] = 7;
        byArray[6] = 1;
        byArray[7] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Field Type", (int)2, (int)this.e.getType(null));
        TestScripts.assertEquals((String)"Value", (int)0, (int)this.e.getInt(null));
        byte[] byArray2 = new byte[8];
        byArray2[0] = 1;
        byArray2[1] = -123;
        byArray2[2] = 7;
        byArray2[7] = 3;
        this.byteCode = byArray2;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Field Type", (int)2, (int)this.e.getType(null));
        TestScripts.assertEquals((String)"Value", (int)1, (int)this.e.getInt(null));
    }

    public void testNotF() throws Exception {
        byte[] byArray = new byte[12];
        byArray[0] = 1;
        byArray[1] = -123;
        byArray[2] = 8;
        byArray[3] = 64;
        byArray[4] = 8;
        byArray[11] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Field Type", (int)2, (int)this.e.getType(null));
        TestScripts.assertEquals((String)"Value", (int)0, (int)this.e.getInt(null));
        byte[] byArray2 = new byte[12];
        byArray2[0] = 1;
        byArray2[1] = -123;
        byArray2[2] = 8;
        byArray2[11] = 3;
        this.byteCode = byArray2;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Field Type", (int)2, (int)this.e.getType(null));
        TestScripts.assertEquals((String)"Value", (int)1, (int)this.e.getInt(null));
    }

    public void testNotS() throws Exception {
        byte[] byArray = new byte[6];
        byArray[0] = 1;
        byArray[1] = -123;
        byArray[2] = 6;
        byArray[3] = 97;
        byArray[5] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Field Type", (int)2, (int)this.e.getType(null));
        TestScripts.assertEquals((String)"Value", (int)0, (int)this.e.getInt(null));
        byte[] byArray2 = new byte[5];
        byArray2[0] = 1;
        byArray2[1] = -123;
        byArray2[2] = 6;
        byArray2[4] = 3;
        this.byteCode = byArray2;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Field Type", (int)2, (int)this.e.getType(null));
        TestScripts.assertEquals((String)"Value", (int)1, (int)this.e.getInt(null));
    }

    public void testAndCG() throws Exception {
        byte[] byArray = new byte[13];
        byArray[0] = 1;
        byArray[1] = -128;
        byArray[2] = 7;
        byArray[6] = 1;
        byArray[7] = 7;
        byArray[11] = 1;
        byArray[12] = 3;
        this.byteCode = byArray;
        this.checkBC(this.byteCode);
    }

    public void testAndSC() throws Exception {
        byte[] byArray = new byte[13];
        byArray[0] = 1;
        byArray[1] = -128;
        byArray[2] = 7;
        byArray[6] = 1;
        byArray[7] = 7;
        byArray[11] = 1;
        byArray[12] = 3;
        this.byteCode = byArray;
        this.checkSC("(and 1 1 )", this.byteCode);
        this.checkSC("( and 1 1)", this.byteCode);
    }

    public void testAndI() throws Exception {
        byte[] byArray = new byte[13];
        byArray[0] = 1;
        byArray[1] = -128;
        byArray[2] = 7;
        byArray[6] = 1;
        byArray[7] = 7;
        byArray[11] = 1;
        byArray[12] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Field Type", (int)2, (int)this.e.getType(null));
        TestScripts.assertEquals((String)"Value", (int)1, (int)this.e.getInt(null));
        byte[] byArray2 = new byte[13];
        byArray2[0] = 1;
        byArray2[1] = -128;
        byArray2[2] = 7;
        byArray2[7] = 7;
        byArray2[11] = 1;
        byArray2[12] = 3;
        this.byteCode = byArray2;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Value", (int)0, (int)this.e.getInt(null));
    }

    public void testAndF() throws Exception {
        byte[] byArray = new byte[21];
        byArray[0] = 1;
        byArray[1] = -128;
        byArray[2] = 8;
        byArray[3] = 64;
        byArray[4] = 8;
        byArray[11] = 8;
        byArray[12] = 64;
        byArray[13] = 8;
        byArray[20] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Field Type", (int)2, (int)this.e.getType(null));
        TestScripts.assertEquals((String)"Value", (int)1, (int)this.e.getInt(null));
        byte[] byArray2 = new byte[21];
        byArray2[0] = 1;
        byArray2[1] = -128;
        byArray2[2] = 8;
        byArray2[3] = 64;
        byArray2[4] = 8;
        byArray2[11] = 8;
        byArray2[20] = 3;
        this.byteCode = byArray2;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Value", (int)0, (int)this.e.getInt(null));
    }

    public void testAndS() throws Exception {
        byte[] byArray = new byte[9];
        byArray[0] = 1;
        byArray[1] = -128;
        byArray[2] = 6;
        byArray[3] = 97;
        byArray[5] = 6;
        byArray[6] = 97;
        byArray[8] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Field Type", (int)2, (int)this.e.getType(null));
        TestScripts.assertEquals((String)"Value", (int)1, (int)this.e.getInt(null));
        byte[] byArray2 = new byte[8];
        byArray2[0] = 1;
        byArray2[1] = -128;
        byArray2[2] = 6;
        byArray2[4] = 6;
        byArray2[5] = 97;
        byArray2[7] = 3;
        this.byteCode = byArray2;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Value", (int)0, (int)this.e.getInt(null));
    }

    public void testOrSC() throws Exception {
        byte[] byArray = new byte[13];
        byArray[0] = 1;
        byArray[1] = -127;
        byArray[2] = 7;
        byArray[7] = 7;
        byArray[11] = 1;
        byArray[12] = 3;
        this.byteCode = byArray;
        this.checkSC("( or 0 1 )", this.byteCode);
        this.checkSC("(or 0 1)", this.byteCode);
    }

    public void testOrCG() throws Exception {
        byte[] byArray = new byte[13];
        byArray[0] = 1;
        byArray[1] = -127;
        byArray[2] = 7;
        byArray[7] = 7;
        byArray[11] = 1;
        byArray[12] = 3;
        this.byteCode = byArray;
        this.checkBC(this.byteCode);
    }

    public void testOrI() throws Exception {
        byte[] byArray = new byte[13];
        byArray[0] = 1;
        byArray[1] = -127;
        byArray[2] = 7;
        byArray[7] = 7;
        byArray[11] = 1;
        byArray[12] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Field Type", (int)2, (int)this.e.getType(null));
        TestScripts.assertEquals((String)"Value", (int)1, (int)this.e.getInt(null));
        byte[] byArray2 = new byte[13];
        byArray2[0] = 1;
        byArray2[1] = -127;
        byArray2[2] = 7;
        byArray2[7] = 7;
        byArray2[12] = 3;
        this.byteCode = byArray2;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Value", (int)0, (int)this.e.getInt(null));
    }

    public void testOrF() throws Exception {
        byte[] byArray = new byte[21];
        byArray[0] = 1;
        byArray[1] = -127;
        byArray[2] = 8;
        byArray[3] = 64;
        byArray[4] = 8;
        byArray[11] = 8;
        byArray[20] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Field Type", (int)2, (int)this.e.getType(null));
        TestScripts.assertEquals((String)"Value", (int)1, (int)this.e.getInt(null));
        byte[] byArray2 = new byte[21];
        byArray2[0] = 1;
        byArray2[1] = -127;
        byArray2[2] = 8;
        byArray2[11] = 8;
        byArray2[20] = 3;
        this.byteCode = byArray2;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Value", (int)0, (int)this.e.getInt(null));
    }

    public void testOrS() throws Exception {
        byte[] byArray = new byte[8];
        byArray[0] = 1;
        byArray[1] = -127;
        byArray[2] = 6;
        byArray[3] = 97;
        byArray[5] = 6;
        byArray[7] = 3;
        this.byteCode = byArray;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Field Type", (int)2, (int)this.e.getType(null));
        TestScripts.assertEquals((String)"Value", (int)1, (int)this.e.getInt(null));
        byte[] byArray2 = new byte[7];
        byArray2[0] = 1;
        byArray2[1] = -127;
        byArray2[2] = 6;
        byArray2[4] = 6;
        byArray2[6] = 3;
        this.byteCode = byArray2;
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        TestScripts.assertEquals((String)"Value", (int)0, (int)this.e.getInt(null));
    }

    public TestScripts(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("pilotdb.calc.TestScripts");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("pilotdb.calc.TestScripts");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite ts = new TestSuite((Class)clazz);
        return ts;
    }

    private void checkBC(byte[] byteCode) throws Exception {
        this.e = this.parser.parse(null, new ByteArray(byteCode));
        this.generated = new ByteArray();
        this.e.toByteCode(null, this.generated);
        TestScripts.assertEquals((String)"Generated Byte Code", (Object)new ByteArray(byteCode), (Object)this.generated);
    }

    private void checkSG(String script, byte[] fromByteCode) throws Exception {
        this.e = this.parser.parse(null, new ByteArray(this.byteCode));
        StringBuffer sb = new StringBuffer();
        this.e.toScript(null, sb);
        TestScripts.assertEquals((String)"Generated Byte Code", (Object)script, (Object)sb.toString());
    }

    private void checkSC(String script, byte[] actualByteCode) throws Exception {
        this.e = this.lispParser.parse(null, script);
        ByteArray generatedBa = new ByteArray();
        this.e.toByteCode(null, generatedBa);
        TestScripts.assertEquals((Object)new ByteArray(actualByteCode), (Object)generatedBa);
    }
}

