/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.calc;

import palmdb.util.ByteArray;
import pilotdb.PilotDBDate;
import pilotdb.PilotDBException;
import pilotdb.PilotDBTime;
import pilotdb.calc.EvaluationContext;
import pilotdb.calc.Expression;
import pilotdb.calc.SortOperation;

public class Script {
    Expression sortOperation = null;
    Expression typedOperation = null;

    public void setSortOperation(SortOperation se) {
        this.sortOperation = se;
    }

    public int getType(EvaluationContext ctx) throws PilotDBException {
        return this.typedOperation.getType(ctx);
    }

    private void maybeSort(EvaluationContext ctx) throws PilotDBException {
        if (ctx == null) {
            return;
        }
        if (ctx.isSorted() || this.sortOperation == null) {
            return;
        }
        this.sortOperation.evaluateVoid(ctx);
    }

    public PilotDBDate getDate(EvaluationContext ctx) throws PilotDBException {
        this.maybeSort(ctx);
        return this.typedOperation.getDate(ctx);
    }

    public double getFloat(EvaluationContext ctx) throws PilotDBException {
        this.maybeSort(ctx);
        return this.typedOperation.getFloat(ctx);
    }

    public int getInt(EvaluationContext ctx) throws PilotDBException {
        this.maybeSort(ctx);
        return this.typedOperation.getInt(ctx);
    }

    public String getString(EvaluationContext ctx) throws PilotDBException {
        this.maybeSort(ctx);
        return this.typedOperation.getString(ctx);
    }

    public PilotDBTime getTime(EvaluationContext ctx) throws PilotDBException {
        this.maybeSort(ctx);
        return this.typedOperation.getTime(ctx);
    }

    public void toByteCode(EvaluationContext ctx, ByteArray byteArray) throws PilotDBException {
        if (this.sortOperation != null) {
            this.sortOperation.toByteCode(ctx, byteArray);
        }
        this.typedOperation.toByteCode(ctx, byteArray);
    }

    public void toScript(EvaluationContext ctx, StringBuffer stringBuffer) {
        if (this.sortOperation != null) {
            this.sortOperation.toScript(ctx, stringBuffer);
        }
        if (this.typedOperation != null) {
            this.typedOperation.toScript(ctx, stringBuffer);
        }
    }

    public String toString() {
        EvaluationContext ctx = new EvaluationContext();
        StringBuffer sb = new StringBuffer();
        this.toScript(ctx, sb);
        return sb.toString();
    }

    public Expression getSortExpression() {
        return this.sortOperation;
    }

    public Expression getTypedOperation() {
        return this.typedOperation;
    }

    public void setTypedOperation(Expression typedExpression) {
        this.typedOperation = typedExpression;
    }
}

