/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.calc;

import pilotdb.PilotDBException;
import pilotdb.calc.AbstractOperation;
import pilotdb.calc.EvaluationContext;
import pilotdb.calc.Expression;

public abstract class LogicalOperation
extends AbstractOperation {
    public int getType(EvaluationContext ctx) {
        return 2;
    }

    public double getFloat(EvaluationContext ctx) throws PilotDBException {
        return this.getInt(ctx);
    }

    public int oneOrZero(int arg, EvaluationContext ctx) throws PilotDBException {
        Expression e = this.getArgument(arg);
        switch (e.getType(ctx)) {
            case 0: {
                String s = e.getString(ctx);
                if (s != null) {
                    return 1;
                }
                return 0;
            }
            case 4: {
                throw new RuntimeException("not yet implemented");
            }
            case 3: {
                throw new RuntimeException("not yet implemented");
            }
            case 2: {
                int i = e.getInt(ctx);
                return i == 0 ? 0 : 1;
            }
            case 8: {
                double f = e.getFloat(ctx);
                return f != 0.0 ? 1 : 0;
            }
        }
        throw new RuntimeException("invalid argument type");
    }

    public String getString(EvaluationContext ctx) throws PilotDBException {
        return String.valueOf(this.getInt(ctx));
    }
}

