/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.calc;

import java.util.Stack;
import pilotdb.PilotDBDate;
import pilotdb.PilotDBTime;
import pilotdb.calc.AbstractExpression;
import pilotdb.calc.AllOperation;
import pilotdb.calc.AndOperation;
import pilotdb.calc.ArithmeticOperation;
import pilotdb.calc.BranchOperation;
import pilotdb.calc.ByteCodeConstants;
import pilotdb.calc.DateLiteral;
import pilotdb.calc.EvaluationContext;
import pilotdb.calc.Expression;
import pilotdb.calc.FieldExpression;
import pilotdb.calc.FloatLiteral;
import pilotdb.calc.IntegerLiteral;
import pilotdb.calc.InvalidCodeException;
import pilotdb.calc.NotOperation;
import pilotdb.calc.NumberComparisonOperation;
import pilotdb.calc.Operation;
import pilotdb.calc.OrOperation;
import pilotdb.calc.RandomOperation;
import pilotdb.calc.Script;
import pilotdb.calc.SortOperation;
import pilotdb.calc.StringComparisonOperation;
import pilotdb.calc.StringLiteral;
import pilotdb.calc.TestOperation;
import pilotdb.calc.TimeLiteral;

public class LispCodeExpressionParser
implements ByteCodeConstants {
    private static final byte STATE_IN_QUOTED_STRING = 1;
    private static final byte STATE_BEFORE_FUNC_NAME = 2;
    private static final byte STATE_FIELD_ID_REF = 4;
    private static final byte STATE_ARITHMETIC = 8;
    private int currentPosition = 0;
    byte state = 0;
    StringBuffer buffer = null;
    Stack opStack = new Stack();
    Operation currentOp = null;

    public Script parse(EvaluationContext context, String scriptCode) throws InvalidCodeException {
        Script script = new Script();
        this.opStack.clear();
        this.currentOp = null;
        char[] scriptChars = scriptCode.toCharArray();
        int i = 0;
        while (i < scriptChars.length) {
            this.currentPosition = i;
            char c = scriptChars[i];
            if (this.instate((byte)1)) {
                if (c == '\'') {
                    StringLiteral sl = new StringLiteral(this.buffer_contents());
                    this.currentOp.addArgument(sl);
                    this.clearstate((byte)1);
                } else {
                    this.append_buffer(c);
                }
            } else {
                switch (c) {
                    case '(': {
                        this.setstate((byte)2);
                        break;
                    }
                    case ')': {
                        if (this.buffer.length() > 0) {
                            this.push(this.expression());
                        }
                        if (!this.opStack.empty()) {
                            this.currentOp = (Operation)this.opStack.pop();
                            break;
                        }
                        if (this.currentOp instanceof SortOperation) {
                            script.setSortOperation((SortOperation)this.currentOp);
                            break;
                        }
                        script.setTypedOperation(this.currentOp);
                        break;
                    }
                    case '%': {
                        this.setstate((byte)4);
                        break;
                    }
                    case ' ': {
                        if (this.instate((byte)2)) {
                            if (this.getBuffer(false).length() <= 0) break;
                            this.push(this.expression());
                            this.clearstate((byte)2);
                            break;
                        }
                        if (this.instate((byte)4)) {
                            String fieldIdRef = this.buffer_contents();
                            int fieldIdx = Integer.parseInt(fieldIdRef);
                            FieldExpression fe = new FieldExpression(fieldIdx);
                            this.currentOp.addArgument(fe);
                            this.clearstate((byte)4);
                            break;
                        }
                        if (this.getBuffer(false).length() <= 0) break;
                        Expression e = this.expression();
                        this.push(e);
                        break;
                    }
                    case '?': {
                        this.push(new TestOperation());
                        this.clearstate((byte)2);
                        break;
                    }
                    case '!': {
                        this.clearstate((byte)2);
                        this.push(new NotOperation());
                        break;
                    }
                    case '\'': {
                        this.setstate((byte)1);
                        break;
                    }
                    default: {
                        this.append_buffer(scriptChars[i]);
                    }
                }
            }
            ++i;
        }
        return script;
    }

    private Expression expression() throws InvalidCodeException {
        String word = this.buffer_contents();
        AbstractExpression e = null;
        if (word.equals("eq")) {
            if (!this.instate((byte)2)) {
                throw new InvalidCodeException(this.currentPosition);
            }
            e = new NumberComparisonOperation(8);
        } else if (word.equals("lt")) {
            if (!this.instate((byte)2)) {
                throw new InvalidCodeException(this.currentPosition);
            }
            e = new NumberComparisonOperation(4);
        } else if (word.equals("gt")) {
            if (!this.instate((byte)2)) {
                throw new InvalidCodeException(this.currentPosition);
            }
            e = new NumberComparisonOperation(6);
        } else if (word.equals("le")) {
            if (!this.instate((byte)2)) {
                throw new InvalidCodeException(this.currentPosition);
            }
            e = new NumberComparisonOperation(5);
        } else if (word.equals("ge")) {
            if (!this.instate((byte)2)) {
                throw new InvalidCodeException(this.currentPosition);
            }
            e = new NumberComparisonOperation(7);
        } else if (word.equals("seq")) {
            if (!this.instate((byte)2)) {
                throw new InvalidCodeException(this.currentPosition);
            }
            e = new StringComparisonOperation(9);
        } else if (word.equals("sstr")) {
            if (!this.instate((byte)2)) {
                throw new InvalidCodeException(this.currentPosition);
            }
            e = new StringComparisonOperation(10);
        } else if (word.equals("br")) {
            if (!this.instate((byte)2)) {
                throw new InvalidCodeException(this.currentPosition);
            }
            e = new BranchOperation();
        } else if (word.equals("all")) {
            if (!this.instate((byte)2)) {
                throw new InvalidCodeException(this.currentPosition);
            }
            e = new AllOperation();
        } else if (word.equals("or")) {
            if (!this.instate((byte)2)) {
                throw new InvalidCodeException(this.currentPosition);
            }
            e = new OrOperation();
        } else if (word.equals("and")) {
            if (!this.instate((byte)2)) {
                throw new InvalidCodeException(this.currentPosition);
            }
            e = new AndOperation();
        } else if (word.equals("rand")) {
            if (!this.instate((byte)2)) {
                throw new InvalidCodeException(this.currentPosition);
            }
            e = new RandomOperation();
        } else {
            if (word.equals("int")) {
                if (!this.instate((byte)2)) {
                    throw new InvalidCodeException(this.currentPosition);
                }
                throw new RuntimeException("not yet implemented");
            }
            if (word.equals("dur")) {
                if (!this.instate((byte)2)) {
                    throw new InvalidCodeException(this.currentPosition);
                }
                throw new RuntimeException("not yet implemented");
            }
            if (word.equals("ffr")) {
                if (!this.instate((byte)2)) {
                    throw new InvalidCodeException(this.currentPosition);
                }
                throw new RuntimeException("not yet implemented");
            }
            if (word.equals("sort")) {
                if (!this.instate((byte)2)) {
                    throw new InvalidCodeException(this.currentPosition);
                }
                e = new SortOperation();
            } else if (word.equals("+")) {
                if (!this.instate((byte)2)) {
                    throw new InvalidCodeException(this.currentPosition);
                }
                e = new ArithmeticOperation(0);
            } else if (word.equals("-")) {
                if (!this.instate((byte)2)) {
                    throw new InvalidCodeException(this.currentPosition);
                }
                e = new ArithmeticOperation(1);
            } else if (word.equals("*")) {
                if (!this.instate((byte)2)) {
                    throw new InvalidCodeException(this.currentPosition);
                }
                e = new ArithmeticOperation(2);
            } else if (word.equals("/")) {
                if (!this.instate((byte)2)) {
                    throw new InvalidCodeException(this.currentPosition);
                }
                e = new ArithmeticOperation(3);
            } else {
                if (e == null) {
                    try {
                        int i = Integer.parseInt(word);
                        e = new IntegerLiteral(i);
                    }
                    catch (NumberFormatException i) {
                        // empty catch block
                    }
                }
                if (e == null) {
                    try {
                        double d = Double.parseDouble(word);
                        e = new FloatLiteral(d);
                    }
                    catch (Exception d) {
                        // empty catch block
                    }
                }
                if (e == null) {
                    try {
                        PilotDBDate dt = new PilotDBDate(word);
                        e = new DateLiteral(dt);
                    }
                    catch (Exception dt) {
                        // empty catch block
                    }
                }
                if (e == null) {
                    try {
                        PilotDBTime tm = new PilotDBTime(word);
                        e = new TimeLiteral(tm);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (e == null) {
                    e = new StringLiteral(word);
                }
            }
        }
        return e;
    }

    private void push(Expression e) {
        if (e instanceof Operation) {
            if (this.currentOp != null) {
                this.currentOp.addArgument(e);
                this.opStack.push(this.currentOp);
            }
            this.currentOp = (Operation)e;
        } else {
            this.currentOp.addArgument(e);
        }
    }

    private boolean instate(byte instate) {
        return (this.state & instate) == instate;
    }

    private void clearstate(byte instate) {
        this.state = (byte)(this.state & ~instate);
    }

    private void setstate(byte instate) {
        this.state = (byte)(this.state | instate);
    }

    private void append_buffer(char c) {
        this.getBuffer(false).append(c);
    }

    private String buffer_contents() {
        String s = this.getBuffer(false).toString();
        this.getBuffer(true);
        return s;
    }

    private StringBuffer getBuffer(boolean clear) {
        if (clear) {
            this.buffer = null;
        }
        if (this.buffer == null) {
            this.buffer = new StringBuffer();
        }
        return this.buffer;
    }
}

