/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.calc;

import palmdb.util.ByteArray;
import pilotdb.calc.AbstractExpression;
import pilotdb.calc.EvaluationContext;

public class IntegerLiteral
extends AbstractExpression {
    int i;

    public IntegerLiteral(int i) {
        this.i = i;
    }

    public int getInt(EvaluationContext ctx) {
        return this.i;
    }

    public int getType(EvaluationContext ctx) {
        return 2;
    }

    public void toByteCode(EvaluationContext ctx, ByteArray byteArray) {
        byteArray.BYTE((byte)7, true).INT(this.i, true);
    }

    public void toScript(EvaluationContext ctx, StringBuffer stringBuffer) {
        stringBuffer.append(String.valueOf(this.i));
    }

    public String getString(EvaluationContext ctx) {
        return String.valueOf(this.getInt(ctx));
    }

    public double getFloat(EvaluationContext ctx) {
        return this.i;
    }
}

