/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.calc;

import palmdb.util.ByteArray;
import pilotdb.PilotDBDate;
import pilotdb.PilotDBException;
import pilotdb.PilotDBTime;
import pilotdb.calc.AbstractOperation;
import pilotdb.calc.EvaluationContext;

public class BranchOperation
extends AbstractOperation {
    private static final byte[] LCD_FACTORS;
    private static final int[][] LCD;

    static {
        byte[] byArray = new byte[10];
        byArray[0] = 1;
        byArray[2] = 2;
        byArray[3] = 4;
        byArray[4] = 8;
        byArray[8] = 10;
        LCD_FACTORS = byArray;
        int[][] nArrayArray = new int[6][];
        int[] nArray = new int[2];
        nArray[0] = 1;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{2, 2};
        nArrayArray[2] = new int[]{4, 3};
        nArrayArray[3] = new int[]{8, 4};
        nArrayArray[4] = new int[]{10, 8};
        nArrayArray[5] = new int[]{10, 8};
        LCD = nArrayArray;
    }

    public int getType(EvaluationContext ctx) throws PilotDBException {
        return this.leastCommonDenominator(ctx);
    }

    private int leastCommonDenominator(EvaluationContext ctx) throws PilotDBException {
        int argCount = this.getArgumentCount() - 1;
        int lcd = 0;
        int i = 1;
        while (i < argCount) {
            lcd |= LCD_FACTORS[this.getArgument(i).getType(ctx)];
            ++i;
        }
        i = 0;
        while (i < LCD.length) {
            int[] lcdentry = LCD[i];
            if (lcdentry[0] == lcd) {
                return lcdentry[1];
            }
            ++i;
        }
        return 0;
    }

    public void toByteCode(EvaluationContext ctx, ByteArray byteArray) throws PilotDBException {
        byteArray.BYTE((byte)1, true);
        byteArray.BYTE((byte)-125, true);
        int i = 0;
        while (i < this.getArgumentCount()) {
            this.getArgument(i).toByteCode(ctx, byteArray);
            ++i;
        }
        byteArray.BYTE((byte)3, true);
    }

    public void toScript(EvaluationContext ctx, StringBuffer stringBuffer) {
        stringBuffer.append("(br");
        int i = 0;
        while (i < this.getArgumentCount()) {
            stringBuffer.append(" ");
            this.getArgument(i).toScript(ctx, stringBuffer);
            ++i;
        }
        stringBuffer.append(")");
    }

    private int getRawIndex(EvaluationContext ctx) throws PilotDBException {
        return this.getArgument(0).getInt(ctx);
    }

    private int getIndex(EvaluationContext ctx) throws PilotDBException {
        int lastIndex = this.getArgumentCount() - 2;
        int i = this.getRawIndex(ctx);
        if (i < 0) {
            return 0;
        }
        if (i > lastIndex) {
            return lastIndex;
        }
        return i;
    }

    public PilotDBDate getDate(EvaluationContext ctx) throws PilotDBException {
        int branchIndex = this.getIndex(ctx);
        return this.getArgument(branchIndex + 1).getDate(ctx);
    }

    public double getFloat(EvaluationContext ctx) throws PilotDBException {
        int branchIndex = this.getIndex(ctx);
        return this.getArgument(branchIndex + 1).getFloat(ctx);
    }

    public int getInt(EvaluationContext ctx) throws PilotDBException {
        int branchIndex = this.getIndex(ctx);
        return this.getArgument(branchIndex + 1).getInt(ctx);
    }

    public String getString(EvaluationContext ctx) throws PilotDBException {
        int branchIndex = this.getIndex(ctx);
        return this.getArgument(branchIndex + 1).getString(ctx);
    }

    public PilotDBTime getTime(EvaluationContext ctx) throws PilotDBException {
        int branchIndex = this.getIndex(ctx);
        return this.getArgument(branchIndex + 1).getTime(ctx);
    }
}

