/*
 * Decompiled with CFR 0.152.
 */
package pilotdb.calc;

import palmdb.util.ByteArray;
import pilotdb.PilotDBDate;
import pilotdb.PilotDBException;
import pilotdb.PilotDBTime;
import pilotdb.calc.AbstractOperation;
import pilotdb.calc.EvaluationContext;
import pilotdb.calc.Expression;

public class AllOperation
extends AbstractOperation {
    public int getType(EvaluationContext ctx) throws PilotDBException {
        return this.getArgument(this.getArgumentCount() - 1).getType(ctx);
    }

    private void evaluateAll(EvaluationContext ctx) throws PilotDBException {
        int i = 0;
        while (i < this.getArgumentCount() - 1) {
            Expression e = this.getArgument(i);
            int type = e.getType(ctx);
            switch (type) {
                case 2: {
                    e.getInt(ctx);
                    break;
                }
                case 8: {
                    e.getFloat(ctx);
                    break;
                }
                case 3: {
                    e.getDate(ctx);
                    break;
                }
                case 4: {
                    e.getTime(ctx);
                    break;
                }
                case 0: {
                    e.getString(ctx);
                    break;
                }
                default: {
                    throw new RuntimeException("invalid argument return type");
                }
            }
            ++i;
        }
    }

    public PilotDBDate getDate(EvaluationContext ctx) throws PilotDBException {
        this.evaluateAll(ctx);
        return this.getArgument(this.getArgumentCount() - 1).getDate(ctx);
    }

    public double getFloat(EvaluationContext ctx) throws PilotDBException {
        this.evaluateAll(ctx);
        return this.getArgument(this.getArgumentCount() - 1).getFloat(ctx);
    }

    public int getInt(EvaluationContext ctx) throws PilotDBException {
        this.evaluateAll(ctx);
        return this.getArgument(this.getArgumentCount() - 1).getInt(ctx);
    }

    public String getString(EvaluationContext ctx) throws PilotDBException {
        this.evaluateAll(ctx);
        return this.getArgument(this.getArgumentCount() - 1).getString(ctx);
    }

    public PilotDBTime getTime(EvaluationContext ctx) throws PilotDBException {
        this.evaluateAll(ctx);
        return this.getArgument(this.getArgumentCount() - 1).getTime(ctx);
    }

    public void toByteCode(EvaluationContext ctx, ByteArray byteArray) throws PilotDBException {
        byteArray.BYTE((byte)1, true);
        byteArray.BYTE((byte)-126, true);
        int i = 0;
        while (i < this.getArgumentCount()) {
            this.getArgument(i).toByteCode(ctx, byteArray);
            ++i;
        }
        byteArray.BYTE((byte)3, true);
    }

    public void toScript(EvaluationContext ctx, StringBuffer stringBuffer) {
        stringBuffer.append("(all");
        int i = 0;
        while (i < this.getArgumentCount()) {
            stringBuffer.append(" ");
            this.getArgument(i).toScript(ctx, stringBuffer);
            ++i;
        }
        stringBuffer.append(")");
    }
}

