/*
 * Decompiled with CFR 0.152.
 */
package pilotdb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import junit.awtui.TestRunner;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBDate;
import pilotdb.PilotDBEnvironment;
import pilotdb.PilotDBField;
import pilotdb.PilotDBRecord;
import pilotdb.PilotDBSchema;
import pilotdb.PilotDBTime;

public class Test1
extends TestCase {
    PilotDBDatabase database = null;
    File f = null;
    public static final String FINDBYID_TITLE = "Suicide Kings";
    public static final String FINDBYID_ID = "417";
    public static final int COLUMN_COUNT = 7;
    public static final int RECORD_COUNT = 418;
    public static final String[] COLUMN_NAMES = new String[]{"Id", "Title", "Media", "Director", "Anthology", "Category", "Language"};
    public static final int[] COLUMN_TYPES;
    static /* synthetic */ Class class$0;

    static {
        int[] nArray = new int[7];
        nArray[0] = 2;
        COLUMN_TYPES = nArray;
    }

    public Test1(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("pilotdb.Test1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite ts = new TestSuite((Class)clazz);
        return ts;
    }

    public void testColumnCount() throws Exception {
        Test1.assertEquals((int)7, (int)this.database.getSchema().getFieldCount());
    }

    public void testColumnTypes() throws Exception {
        int i = 0;
        while (i < COLUMN_TYPES.length) {
            Test1.assertEquals((int)this.database.getSchema().getField(i).getType(), (int)COLUMN_TYPES[i]);
            ++i;
        }
    }

    public void testColumnNames() throws Exception {
        int i = 0;
        while (i < COLUMN_NAMES.length) {
            Test1.assertEquals((Object)this.database.getSchema().getField(i).getName(), (Object)COLUMN_NAMES[i]);
            ++i;
        }
    }

    public void testCreatorId() throws Exception {
        Test1.assertEquals((Object)this.database.getCreator(), (Object)"DBOS");
    }

    public void testDBType() throws Exception {
        Test1.assertEquals((Object)this.database.getType(), (Object)"DB00");
    }

    public void testRecordCount() throws Exception {
        Test1.assertEquals((int)this.database.getRecordCount(), (int)418);
    }

    public void testFindById() throws Exception {
        PilotDBRecord rec = this.database.findRecord(0, FINDBYID_ID);
        Test1.assertEquals((Object)rec.getString(1), (Object)FINDBYID_TITLE);
    }

    public void testFindByName() throws Exception {
        PilotDBRecord rec = this.database.findRecord(1, FINDBYID_TITLE);
        Test1.assertEquals((int)rec.getInteger(0), (int)Integer.parseInt(FINDBYID_ID));
    }

    public void testIdGeneration() throws Exception {
        PilotDBRecord rec = this.database.createRecord();
        Test1.assertTrue((rec.getRecordHeader().uniqueId != 0 ? 1 : 0) != 0);
        this.database.deleteRecord(rec);
    }

    public void testDelete() throws Exception {
        PilotDBRecord rec = this.database.createRecord();
        rec.setInteger(0, 1001);
        rec.setString(1, "test title");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.database.write(baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        PilotDBDatabase db2 = new PilotDBDatabase(bais);
        rec = db2.findRecord(0, String.valueOf(1001));
        db2.deleteRecord(rec);
        Test1.assertNull((Object)db2.findRecord(0, String.valueOf(1001)));
    }

    public void testCreateAndFind2() throws Exception {
        PilotDBRecord rec = this.database.createRecord();
        rec.setInteger(0, "1001");
        rec.setString(1, "test title");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.database.write(baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        PilotDBDatabase db2 = new PilotDBDatabase(bais);
        rec = db2.findRecord(0, String.valueOf(1001));
        Test1.assertEquals((Object)rec.getString(1), (Object)"test title");
    }

    public void testCreateAndFind() throws Exception {
        PilotDBRecord rec = this.database.createRecord();
        rec.setInteger(0, 1001);
        rec.setString(1, "test title");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.database.write(baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        PilotDBDatabase db2 = new PilotDBDatabase(bais);
        rec = db2.findRecord(0, String.valueOf(1001));
        Test1.assertEquals((Object)rec.getString(1), (Object)"test title");
    }

    public void testDateParse() throws Exception {
        String test1 = "2002/05/11";
        String test2 = "1974/12/12";
        PilotDBDate date = new PilotDBDate(test1);
        Test1.assertEquals((int)date.date, (int)11);
        Test1.assertEquals((int)date.month, (int)5);
        Test1.assertEquals((int)date.year, (int)2002);
        date = new PilotDBDate(test2);
        Test1.assertEquals((int)date.date, (int)12);
        Test1.assertEquals((int)date.month, (int)12);
        Test1.assertEquals((int)date.year, (int)1974);
    }

    public void testTimeParse() throws Exception {
        String test1 = "11:00";
        String test4 = "00:00";
        String test2 = "23:59";
        PilotDBTime time = new PilotDBTime(test1);
        Test1.assertEquals((int)time.hour, (int)11);
        Test1.assertEquals((int)time.minute, (int)0);
        time = new PilotDBTime(test2);
        Test1.assertEquals((int)time.hour, (int)23);
        Test1.assertEquals((int)time.minute, (int)59);
        time = new PilotDBTime(test4);
        Test1.assertEquals((int)time.hour, (int)0);
        Test1.assertEquals((int)time.minute, (int)0);
    }

    public void testDatabaseSort() throws Exception {
        PilotDBSchema schema = new PilotDBSchema();
        PilotDBField field = new PilotDBField(0, "test1");
        schema.addField(field);
        PilotDBField field2 = new PilotDBField(0, "test2");
        schema.addField(field2);
        PilotDBDatabase database = new PilotDBDatabase("test1", "DB00", "DBOS", schema);
        PilotDBRecord rec = database.createRecord();
        rec.setString(0, "trever");
        rec.setString(1, "shick");
        rec = database.createRecord();
        rec.setString(0, "hijee");
        Test1.assertEquals((Object)"", (Object)rec.getString(1));
        rec = (PilotDBRecord)database.getRecord(0);
        Test1.assertEquals((Object)"trever", (Object)rec.getString(0));
        rec = (PilotDBRecord)database.getRecord(1);
        Test1.assertEquals((Object)"hijee", (Object)rec.getString(0));
        database.sort(0, false);
        rec = (PilotDBRecord)database.getRecord(0);
        Test1.assertEquals((Object)"hijee", (Object)rec.getString(0));
        database.sort(1, false);
        rec = (PilotDBRecord)database.getRecord(0);
        Test1.assertEquals((Object)"hijee", (Object)rec.getString(0));
    }

    public void testEnvironment() throws Exception {
        PilotDBEnvironment env = new PilotDBEnvironment();
        env.setBaseDirectory(this.f);
        PilotDBDatabase db1 = env.openDatabase("HTML_Characters");
        PilotDBDatabase db2 = env.openDatabase("tld");
        PilotDBDatabase db3 = env.openDatabase("palmtld_generic");
        PilotDBDatabase db4 = env.openDatabase("Mime_Type");
        PilotDBDatabase db5 = env.openDatabase("tld");
        Test1.assertNotNull((Object)db1);
        Test1.assertNotNull((Object)db2);
        Test1.assertNotNull((Object)db3);
        Test1.assertNotNull((Object)db4);
        Test1.assertNotNull((Object)db5);
        Test1.assertEquals((String)"db2 and db5", (Object)db5, (Object)db2);
        Test1.assertTrue((String)"Close db1", (boolean)env.closeDatabase(db1));
        Test1.assertTrue((String)"Close db2", (!env.closeDatabase(db2) ? 1 : 0) != 0);
        Test1.assertTrue((String)"Close db5", (env.closeDatabase(db5) ? 1 : 0) != 0);
        Test1.assertTrue((PilotDBEnvironment.getEnvironment(db4) != null ? 1 : 0) != 0);
        Test1.assertTrue((String)"Close db3", (boolean)env.closeDatabase(db3));
        db3 = env.openDatabase("Mime_Type");
        Test1.assertTrue((PilotDBEnvironment.getEnvironment(db3) == PilotDBEnvironment.getEnvironment(db4) ? 1 : 0) != 0);
        Test1.assertTrue((String)"Close db3", (!env.closeDatabase(db3) ? 1 : 0) != 0);
        Test1.assertTrue((String)"Close db4", (boolean)env.closeDatabase(db4));
        env = null;
        while (PilotDBEnvironment.references > 0) {
            System.gc();
            Thread.sleep(5000L);
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.database = new PilotDBDatabase(((Object)((Object)this)).getClass().getResourceAsStream("/movies.pdb"));
        this.f = new File("tmp_jpilotdb");
        File out = null;
        if (!this.f.exists()) {
            this.f.mkdir();
        }
        PilotDBDatabase tmp = null;
        tmp = new PilotDBDatabase(((Object)((Object)this)).getClass().getResourceAsStream("/HTML_Characters.pdb"));
        out = new File(this.f, "HTML_Characters.pdb");
        tmp.write(new FileOutputStream(out));
        tmp = new PilotDBDatabase(((Object)((Object)this)).getClass().getResourceAsStream("/tld.pdb"));
        out = new File(this.f, "tld.pdb");
        tmp.write(new FileOutputStream(out));
        tmp = new PilotDBDatabase(((Object)((Object)this)).getClass().getResourceAsStream("/palmtld_generic.pdb"));
        out = new File(this.f, "palmtld_generic.pdb");
        tmp.write(new FileOutputStream(out));
        tmp = new PilotDBDatabase(((Object)((Object)this)).getClass().getResourceAsStream("/Mime_Type.pdb"));
        out = new File(this.f, "Mime_Type.pdb");
        tmp.write(new FileOutputStream(out));
    }

    protected void tearDown() throws Exception {
        File[] filesToDelete = this.f.listFiles();
        int i = 0;
        while (i < filesToDelete.length) {
            filesToDelete[i].delete();
            ++i;
        }
        this.f.delete();
    }

    public static void main(String[] args) throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("pilotdb.Test1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }
}

