/*
 * Decompiled with CFR 0.152.
 */
package pilotdb;

import java.util.LinkedList;
import java.util.List;
import palmdb.util.ByteArray;
import pilotdb.PilotDBConstants;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBViewColumn;

public class PilotDBView
implements PilotDBConstants {
    short flags = 0;
    PilotDBDatabase database;
    List columns = new LinkedList();
    String name = null;

    public List getColumns() {
        return new LinkedList(this.columns);
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public PilotDBViewColumn getColumn(int i) {
        return (PilotDBViewColumn)this.columns.get(i);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String nm) {
        this.name = nm;
    }

    public PilotDBDatabase getDatabase() {
        return this.database;
    }

    PilotDBView(PilotDBDatabase db, ByteArray data) {
        this.database = db;
        this.flags = data.SHORT();
        int numberOfCols = data.SHORT();
        this.name = data.SZ(32);
        int i = 0;
        while (i < numberOfCols) {
            short fieldNumber = data.SHORT();
            short len = data.SHORT();
            this.columns.add(new PilotDBViewColumn(fieldNumber, len));
            ++i;
        }
    }

    void write(ByteArray ba) {
        ba.SHORT(64, true);
        int size = 36 + this.columns.size() * 4;
        ba.SHORT(size, true);
        ba.SHORT(this.flags, true);
        ba.SHORT(this.columns.size(), true);
        ba.SZ(this.name, 32, true);
        int i = 0;
        while (i < this.columns.size()) {
            PilotDBViewColumn col = (PilotDBViewColumn)this.columns.get(i);
            ba.SHORT(col.fieldNumber, true).SHORT(col.fieldWidth, true);
            ++i;
        }
    }

    PilotDBView(String name, PilotDBDatabase db) {
        this.name = name;
        this.database = db;
    }

    public void addColumn(String name, short width) {
        int fieldNumber = this.database.getSchema().getFieldIndex(name);
        PilotDBViewColumn col = new PilotDBViewColumn((short)fieldNumber, width);
        this.columns.add(col);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[ View name=" + this.name + ", cols=[");
        sb.append(this.columns);
        sb.append("]]");
        return sb.toString();
    }
}

