/*
 * Decompiled with CFR 0.152.
 */
package pilotdb;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBDate;
import pilotdb.PilotDBField;
import pilotdb.PilotDBRecord;
import pilotdb.PilotDBSchema;
import pilotdb.PilotDBTime;

public class PilotDBRecordTest
extends TestCase {
    static /* synthetic */ Class class$0;

    public PilotDBRecordTest(String arg0) {
        super(arg0);
    }

    public static TestSuite suite() {
        TestSuite ts = new TestSuite("Pilot-DB Record Test");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("pilotdb.PilotDBRecordTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ts.addTestSuite((Class)clazz);
        return ts;
    }

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("pilotdb.PilotDBRecordTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetCalculatedText() {
    }

    public void testGetSetList() {
    }

    public void testGetListChoice() {
    }

    public void testGetSetNote() throws Exception {
        PilotDBSchema schema = new PilotDBSchema();
        PilotDBField field = new PilotDBField(5, "test1");
        schema.addField(field);
        PilotDBField field2 = new PilotDBField(0, "test2");
        field2.setStringDefaultValue("shick");
        schema.addField(field2);
        PilotDBDatabase database = new PilotDBDatabase("test1", "DB00", "DBOS", schema);
        PilotDBRecord rec = database.createRecord();
        rec.setNote(0, "my note");
        rec.setNoteTitle(0, "Title");
        rec.setString(1, "trever");
        PilotDBRecordTest.assertEquals((String)"Note Value", (Object)"my note", (Object)rec.getNote(0));
        PilotDBRecordTest.assertEquals((String)"Note Title", (Object)"Title", (Object)rec.getNoteTitle(0));
        PilotDBRecordTest.assertEquals((String)"String Value", (Object)"trever", (Object)rec.getString(1));
        rec.setNoteTitle(0, "new note title");
        rec.setNote(0, "new note");
        PilotDBRecordTest.assertEquals((String)"Note Value", (Object)"new note", (Object)rec.getNote(0));
        PilotDBRecordTest.assertEquals((String)"Note Title", (Object)"new note title", (Object)rec.getNoteTitle(0));
    }

    public void testGetSetString() throws Exception {
        PilotDBSchema schema = new PilotDBSchema();
        PilotDBField field = new PilotDBField(0, "test1");
        field.setStringDefaultValue("trever");
        schema.addField(field);
        PilotDBField field2 = new PilotDBField(0, "test2");
        field2.setStringDefaultValue("shick");
        schema.addField(field2);
        PilotDBDatabase database = new PilotDBDatabase("test1", "DB00", "DBOS", schema);
        PilotDBRecord rec = database.createRecord();
        rec.setString(0, "test_string_1");
        rec.setString(1, "test_string_2");
        PilotDBRecordTest.assertEquals((String)"String Value", (Object)"test_string_1", (Object)rec.getString(0));
        PilotDBRecordTest.assertEquals((String)"String Value", (Object)"test_string_2", (Object)rec.getString(1));
    }

    public void testGetLinked() {
    }

    public void testGetLinkText() {
    }

    public void testGetSetDate() throws Exception {
        PilotDBSchema schema = new PilotDBSchema();
        PilotDBField field = new PilotDBField(3, "test1");
        schema.addField(field);
        PilotDBField field2 = new PilotDBField(0, "test2");
        field2.setStringDefaultValue("shick");
        schema.addField(field2);
        PilotDBDatabase database = new PilotDBDatabase("test1", "DB00", "DBOS", schema);
        PilotDBRecord rec = database.createRecord();
        rec.setDate(0, "03/10/10");
        rec.setString(1, "trever");
        PilotDBRecordTest.assertEquals((String)"Time Value", (Object)new PilotDBDate(2003, 10, 10), (Object)rec.getDate(0));
        PilotDBRecordTest.assertEquals((String)"String Value", (Object)"trever", (Object)rec.getString(1));
        rec.setDate(0, new PilotDBDate(2003, 10, 11));
        PilotDBRecordTest.assertEquals((String)"Date Value", (Object)new PilotDBDate(2003, 10, 11), (Object)rec.getDate(0));
    }

    public void testGetSetBoolean() throws Exception {
        PilotDBSchema schema = new PilotDBSchema();
        PilotDBField field = new PilotDBField(1, "test1");
        schema.addField(field);
        PilotDBField field2 = new PilotDBField(0, "test2");
        field2.setStringDefaultValue("shick");
        schema.addField(field2);
        PilotDBDatabase database = new PilotDBDatabase("test1", "DB00", "DBOS", schema);
        PilotDBRecord rec = database.createRecord();
        rec.setBoolean(0, true);
        rec.setString(1, "trever");
        PilotDBRecordTest.assertEquals((String)"Bool Value", (boolean)true, (boolean)rec.getBoolean(0));
        PilotDBRecordTest.assertEquals((String)"String Value", (Object)"trever", (Object)rec.getString(1));
        rec.setBoolean(0, false);
        rec.setBoolean(0, "true");
        PilotDBRecordTest.assertEquals((String)"Bool Value", (boolean)true, (boolean)rec.getBoolean(0));
    }

    public void testGetSetObject() {
    }

    public void testGetSetFloat() throws Exception {
        PilotDBSchema schema = new PilotDBSchema();
        PilotDBField field2 = new PilotDBField(8, "test2");
        schema.addField(field2);
        PilotDBField field = new PilotDBField(2, "test1");
        schema.addField(field);
        PilotDBDatabase database = new PilotDBDatabase("test1", "DB00", "DBOS", schema);
        PilotDBRecord rec = database.createRecord();
        rec.setFloat(0, 1.414);
        PilotDBRecordTest.assertEquals((String)"Double Value", (double)1.414, (double)rec.getFloat(0), (double)1.0E-4);
        rec.setFloat(0, "3.14529");
        PilotDBRecordTest.assertEquals((String)"Float Value", (double)3.14529, (double)rec.getFloat(0), (double)1.0E-4);
    }

    public void testGetSetInteger() throws Exception {
        PilotDBSchema schema = new PilotDBSchema();
        PilotDBField field2 = new PilotDBField(0, "test2");
        field2.setStringDefaultValue("shick");
        schema.addField(field2);
        PilotDBField field = new PilotDBField(2, "test1");
        schema.addField(field);
        PilotDBDatabase database = new PilotDBDatabase("test1", "DB00", "DBOS", schema);
        PilotDBRecord rec = database.createRecord();
        rec.setString(0, "trever");
        rec.setInteger(1, 103);
        PilotDBRecordTest.assertEquals((String)"String Value", (Object)"trever", (Object)rec.getString(0));
        PilotDBRecordTest.assertEquals((String)"Int Value", (int)103, (int)rec.getInteger(1));
        rec.setInteger(1, "105");
        PilotDBRecordTest.assertEquals((String)"Int Value", (int)105, (int)rec.getInteger(1));
    }

    public void testSetDelimitedNote() throws Exception {
        String title = "This is a Title";
        String note = "This is a Title\nThis is a note";
        PilotDBSchema schema = new PilotDBSchema();
        PilotDBField field2 = new PilotDBField(5, "test2");
        field2.setStringDefaultValue("shick");
        schema.addField(field2);
        PilotDBField field = new PilotDBField(2, "test1");
        schema.addField(field);
        PilotDBDatabase database = new PilotDBDatabase("test1", "DB00", "DBOS", schema);
        PilotDBRecord rec = database.createRecord();
        rec.setDelimitedNote(0, note);
        rec.setInteger(1, 107);
        PilotDBRecordTest.assertEquals((String)"Note Title", (Object)title, (Object)rec.getNoteTitle(0));
        PilotDBRecordTest.assertEquals((String)"Note", (Object)note, (Object)rec.getNote(0));
    }

    public void testGetSetTime() throws Exception {
        PilotDBSchema schema = new PilotDBSchema();
        PilotDBField field = new PilotDBField(4, "test1");
        schema.addField(field);
        PilotDBField field2 = new PilotDBField(0, "test2");
        field2.setStringDefaultValue("shick");
        schema.addField(field2);
        PilotDBDatabase database = new PilotDBDatabase("test1", "DB00", "DBOS", schema);
        PilotDBRecord rec = database.createRecord();
        rec.setTime(0, "10:10");
        rec.setString(1, "trever");
        PilotDBRecordTest.assertEquals((String)"Time Value", (Object)new PilotDBTime(10, 10), (Object)rec.getTime(0));
        PilotDBRecordTest.assertEquals((String)"String Value", (Object)"trever", (Object)rec.getString(1));
        rec.setTime(0, new PilotDBTime(10, 11));
        PilotDBRecordTest.assertEquals((String)"Time Value", (Object)new PilotDBTime(10, 11), (Object)rec.getTime(0));
    }

    public void testSetObject() {
    }

    public void testSetGetNoteString() throws Exception {
        PilotDBSchema schema = new PilotDBSchema();
        PilotDBField field = new PilotDBField(0, "test1");
        field.setStringDefaultValue("trever");
        schema.addField(field);
        PilotDBField field2 = new PilotDBField(0, "test2");
        field2.setStringDefaultValue("shick");
        schema.addField(field2);
        PilotDBDatabase database = new PilotDBDatabase("test1", "DB00", "DBOS", schema);
        PilotDBRecord rec = database.createRecord();
        PilotDBRecordTest.assertEquals((String)"String Value", (Object)"trever", (Object)rec.getString(0));
        PilotDBRecordTest.assertEquals((String)"String Value", (Object)"shick", (Object)rec.getString(1));
    }

    public void testGetSchema() {
    }
}

