/*
 * Decompiled with CFR 0.152.
 */
package pilotdb;

import palmdb.util.ByteArray;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBException;
import pilotdb.calc.ByteCodeExpressionParser;
import pilotdb.calc.EvaluationContext;
import pilotdb.calc.InvalidCodeException;
import pilotdb.calc.Script;

public class PilotDBGlobalScript {
    Script script;
    String name;
    short returnType;
    short accessRequirements;
    short version;
    PilotDBDatabase database;

    protected PilotDBGlobalScript() {
    }

    protected PilotDBGlobalScript(PilotDBDatabase database, ByteArray data) throws InvalidCodeException {
        this.database = database;
        this.name = data.SZ(32);
        short byteCodeSize = data.UBYTE();
        this.version = data.UBYTE();
        this.accessRequirements = data.UBYTE();
        this.returnType = data.UBYTE();
        ByteArray byteCode = data.BYTE_ARRAY(byteCodeSize);
        ByteCodeExpressionParser parser = new ByteCodeExpressionParser();
        EvaluationContext ctx = new EvaluationContext();
        try {
            this.script = parser.parse(ctx, byteCode);
        }
        catch (InvalidCodeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidCodeException(e.getMessage());
        }
    }

    void write(ByteArray data) throws PilotDBException {
        EvaluationContext ctx = new EvaluationContext();
        ctx.setSchema(this.database.getSchema());
        ByteArray byteCode = new ByteArray();
        this.script.toByteCode(ctx, byteCode);
        ByteArray chunk = new ByteArray();
        chunk.SZ(this.name, 32, true);
        chunk.BYTE((byte)byteCode.length(), true);
        chunk.BYTE((byte)this.version, true);
        chunk.BYTE((byte)this.accessRequirements, true);
        chunk.BYTE((byte)this.returnType, true);
        chunk.BYTE_ARRAY(byteCode.getBytes(), true);
        data.SHORT(512, true);
        data.SHORT(chunk.length(), true);
        data.BYTE_ARRAY(chunk.getBytes(), true);
    }
}

