/*
 * Decompiled with CFR 0.152.
 */
package pilotdb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import palmdb.PalmDbException;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBException;

public class PilotDBEnvironment {
    static final WeakReference[] envs = new WeakReference[32];
    static int references = 0;
    static int envNextEmpty = 0;
    DatabaseEntry[] entries = new DatabaseEntry[32];
    int nextEmptyEntry = 0;
    File baseDirectory = new File(".");

    public PilotDBEnvironment() {
        ++references;
        PilotDBEnvironment.envs[PilotDBEnvironment.envNextEmpty] = new WeakReference<PilotDBEnvironment>(this);
    }

    public static PilotDBEnvironment getEnvironment(File baseDirectory) throws IOException {
        int i = 0;
        while (i < envs.length) {
            PilotDBEnvironment env;
            if (envs[i] != null && (env = (PilotDBEnvironment)envs[i].get()).getBaseDirectory() != null && env.getBaseDirectory().equals(baseDirectory)) {
                return env;
            }
            ++i;
        }
        PilotDBEnvironment env = new PilotDBEnvironment();
        env.setBaseDirectory(baseDirectory);
        return env;
    }

    public static synchronized PilotDBEnvironment getEnvironment(PilotDBDatabase db) {
        int i = 0;
        while (i < envs.length) {
            if (envs[i] != null) {
                int j = 0;
                while (j < ((PilotDBEnvironment)PilotDBEnvironment.envs[i].get()).entries.length) {
                    if (((PilotDBEnvironment)PilotDBEnvironment.envs[i].get()).entries[j].db == db) {
                        return (PilotDBEnvironment)envs[i].get();
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public void add(PilotDBDatabase db) throws IOException, PalmDbException {
        File f = new File(this.getBaseDirectory(), String.valueOf(db.getTitle()) + ".pdb");
        FileOutputStream fos = new FileOutputStream(f);
        db.write(fos);
        fos.flush();
        fos.close();
        this.openDatabase(db.getTitle());
    }

    public void commit(PilotDBDatabase db) throws IOException, PalmDbException {
        File f = this.getFile(db);
        FileOutputStream fos = new FileOutputStream(f);
        db.write(fos);
        fos.flush();
        fos.close();
    }

    public File getFile(PilotDBDatabase db) {
        int i = 0;
        while (i < this.entries.length) {
            if (this.entries[i] != null && this.entries[i].db == db) {
                return this.entries[i].file;
            }
            ++i;
        }
        return null;
    }

    public void setBaseDirectory(File file) throws IOException {
        if (!file.canRead() || !file.isDirectory()) {
            throw new IOException(file + " is not a readable directory.");
        }
        this.baseDirectory = file;
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public boolean deleteDatabase(PilotDBDatabase db) throws IOException, PalmDbException {
        File f = this.getFile(db);
        boolean status = this.closeDatabase(db, true);
        if (!status) {
            throw new IOException("Unable to close database:" + db.getTitle());
        }
        f.delete();
        return true;
    }

    public boolean closeDatabase(PilotDBDatabase db) throws IOException, PalmDbException {
        return this.closeDatabase(db, false);
    }

    public boolean closeDatabase(PilotDBDatabase db, boolean force) throws IOException, PalmDbException {
        int i = 0;
        while (i < this.entries.length) {
            if (this.entries[i] == null) {
                return false;
            }
            if (this.entries[i].db == db) {
                this.entries[i].decrement();
                if (this.entries[i].referenceCount() == 0 || force) {
                    FileOutputStream fos = new FileOutputStream(this.entries[i].file);
                    this.entries[i].db.write(fos);
                    fos.close();
                    this.entries[i] = null;
                    if (this.entries[i + 1] != null) {
                        System.arraycopy(this.entries, i + 1, this.entries, i, this.nextEmptyEntry - (i + 1));
                        this.entries[this.nextEmptyEntry - 1] = null;
                    }
                    --this.nextEmptyEntry;
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public PilotDBDatabase openDatabaseByFilename(String filename) throws PalmDbException {
        File file = new File(this.baseDirectory, filename);
        int i = 0;
        while (i < this.entries.length) {
            if (this.entries[i] == null) break;
            if (this.entries[i].file.equals(file)) {
                this.entries[i].increment();
                return this.entries[i].db;
            }
            ++i;
        }
        try {
            PilotDBDatabase db = new PilotDBDatabase(new FileInputStream(file));
            if (!db.getType().equals("DB00")) {
                throw new IOException("Not a valid PilotDB database name:" + db.getTitle() + " type:" + db.getType());
            }
            DatabaseEntry entry = new DatabaseEntry(file, db);
            entry.increment();
            this.entries[this.nextEmptyEntry++] = entry;
            return db;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new PilotDBException("Error Opening " + file);
        }
    }

    public PilotDBDatabase openDatabase(String name) throws PalmDbException {
        return this.openDatabaseByFilename(String.valueOf(name) + ".pdb");
    }

    public int getDatabaseCount() {
        int count = 0;
        int i = 0;
        while (i < this.entries.length) {
            if (this.entries[i] == null) {
                return count;
            }
            ++count;
            ++i;
        }
        return this.entries.length;
    }

    public PilotDBDatabase getDatabase(int idx) {
        return this.entries[idx].db;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        --references;
        int j = 0;
        while (j < this.entries.length) {
            System.err.println(" database '" + this.entries[j].db.getTitle() + "' still has open references");
            ++j;
        }
    }

    public PilotDBDatabase getDatabaseByTitle(String string) {
        int i = 0;
        while (i < this.entries.length) {
            if (this.entries[i] == null) break;
            if (this.entries[i].db.getTitle().equals(string)) {
                return this.entries[i].db;
            }
            ++i;
        }
        return null;
    }

    public PilotDBDatabase[] getDirtyDatabases() {
        LinkedList<PilotDBDatabase> l = new LinkedList<PilotDBDatabase>();
        int i = 0;
        while (i < this.entries.length && this.entries[i] != null) {
            if (this.entries[i].db.isDirty()) {
                l.add(this.entries[i].db);
            }
            ++i;
        }
        return l.toArray(new PilotDBDatabase[0]);
    }

    private class DatabaseEntry {
        PilotDBDatabase db;
        File file;
        int referenceCount;

        DatabaseEntry(File file, PilotDBDatabase db) {
            this.file = file;
            this.db = db;
        }

        void increment() {
            ++this.referenceCount;
        }

        void decrement() {
            --this.referenceCount;
        }

        int referenceCount() {
            return this.referenceCount;
        }

        public String toString() {
            return "DB:" + this.db.getTitle() + "  file:" + this.file.getName() + " ref:" + this.referenceCount;
        }
    }
}

