/*
 * Decompiled with CFR 0.152.
 */
package pilotdb;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import palmdb.PalmPreferences;
import pilotdb.DateTimeFormatException;

public class PilotDBDate
implements Comparable,
Cloneable {
    int year;
    int month;
    int date;

    public PilotDBDate() {
        Calendar c = Calendar.getInstance();
        this.year = c.get(1);
        this.month = c.get(2) + 1;
        this.date = c.get(5);
    }

    public PilotDBDate(Date dt) {
        Calendar c = Calendar.getInstance();
        c.setTime(dt);
        this.year = c.get(1);
        this.month = c.get(2) + 1;
        this.date = c.get(5);
    }

    public PilotDBDate(int year, int month, int date) {
        this.year = year;
        this.month = month;
        this.date = date;
    }

    public PilotDBDate(String s) throws DateTimeFormatException {
        DateFormat df = PalmPreferences.getInstance().getPalmDateFormat().getJavaDateFormat();
        try {
            Date d = df.parse(s);
            Calendar c = Calendar.getInstance();
            c.setTime(d);
            this.year = c.get(1);
            this.month = c.get(2) + 1;
            this.date = c.get(5);
        }
        catch (ParseException pe) {
            throw new DateTimeFormatException(s, PalmPreferences.getInstance().getPalmDateFormat().getPalmDateFormat());
        }
        if (this.date < 1 || this.date > 31 || this.month < 1 || this.month > 12 || this.year < 0 || this.year > 9999) {
            throw new DateTimeFormatException(s, "yyyy/mm/dd");
        }
    }

    public Date toDate() {
        Calendar c = Calendar.getInstance();
        c.set(1, this.year);
        c.set(2, this.month - 1);
        c.set(5, this.date);
        return c.getTime();
    }

    public boolean isNullDate() {
        return this.date + this.month + this.year == 0;
    }

    public String toString() {
        if (this.date + this.month + this.year == 0) {
            return "n/a";
        }
        return PalmPreferences.getInstance().getPalmDateFormat().getJavaDateFormat().format(this.toDate());
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDate() {
        return this.date;
    }

    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (arg0 instanceof PilotDBDate) {
            PilotDBDate rhs = (PilotDBDate)arg0;
            return rhs.year == this.year && rhs.month == this.month && rhs.date == this.date;
        }
        return super.equals(arg0);
    }

    public int compareTo(Object o) {
        if (o instanceof PilotDBDate) {
            PilotDBDate rhs = (PilotDBDate)o;
            Calendar c1 = Calendar.getInstance();
            c1.set(this.year, this.month, this.date);
            Calendar c2 = Calendar.getInstance();
            c2.set(rhs.year, rhs.month, rhs.date);
            return c1.getTime().compareTo(c2.getTime());
        }
        return this.toString().compareTo(String.valueOf(o));
    }

    public Object clone() {
        PilotDBDate dt = new PilotDBDate();
        dt.year = this.year;
        dt.month = this.month;
        dt.date = this.date;
        return dt;
    }
}

