/*
 * Decompiled with CFR 0.152.
 */
package pilotdb;

import java.util.LinkedList;
import java.util.List;
import palmdb.AppInfo;
import palmdb.PalmDbException;
import palmdb.StringUtil;
import palmdb.util.ByteArray;
import pilotdb.PilotDBConstants;
import pilotdb.PilotDBDatabase;
import pilotdb.PilotDBDate;
import pilotdb.PilotDBException;
import pilotdb.PilotDBField;
import pilotdb.PilotDBGlobalScript;
import pilotdb.PilotDBLFindOptions;
import pilotdb.PilotDBSchema;
import pilotdb.PilotDBTime;
import pilotdb.PilotDBView;
import pilotdb.PilotDBViewOptions;
import pilotdb.calc.ByteCodeExpressionParser;
import pilotdb.calc.EvaluationContext;
import pilotdb.calc.InvalidCodeException;
import pilotdb.calc.Script;

public class PilotDBAppInfo
extends AppInfo
implements PilotDBConstants {
    private static final int FLAG_DB_READ_ONLY = 32768;
    private static final int FLAG_PROTECTED_BY_PASSWORD = 16384;
    private static final int FLAG_GLOBAL_FIND_ENABLE = 1;
    protected short flags;
    protected PilotDBSchema schema;
    protected List views = new LinkedList();
    private PilotDBViewOptions viewOptions;
    private PilotDBLFindOptions lfindOptions;
    private List globalScripts = new LinkedList();

    protected PilotDBAppInfo(PilotDBSchema schema) {
        this.schema = schema;
        this.viewOptions = new PilotDBViewOptions();
    }

    public void setProtected(boolean prot) {
        if (prot) {
            this.setFlag(16384);
        } else {
            this.clearFlag(16384);
        }
    }

    public void setGlobalFindEnable(boolean enabled) {
        if (enabled) {
            this.setFlag(1);
        } else {
            this.clearFlag(1);
        }
    }

    public void setReadOnly(boolean readOnly) {
        if (readOnly) {
            this.setFlag(32768);
        } else {
            this.clearFlag(32768);
        }
    }

    private void setFlag(int flag) {
        this.flags = (short)(this.flags | flag);
    }

    private void clearFlag(int flag) {
        this.flags = (short)(this.flags & ~flag);
    }

    public boolean isProtected() {
        return (this.flags & 0x4000) == 16384;
    }

    public boolean isReadOnly() {
        return (this.flags & 0x8000) == 32768;
    }

    public boolean isGlobalFindEnable() {
        return (this.flags & 1) == 1;
    }

    public PilotDBViewOptions getViewOptions() {
        if (this.viewOptions == null) {
            this.viewOptions = new PilotDBViewOptions();
        }
        return this.viewOptions;
    }

    public PilotDBLFindOptions getLFindOptions() {
        if (this.lfindOptions == null) {
            this.lfindOptions = new PilotDBLFindOptions();
        }
        return this.lfindOptions;
    }

    public void addView(PilotDBView view) {
        this.views.add(view);
        this.data = null;
    }

    public void removeView(int idx) {
        this.removeView(this.getView(idx));
    }

    public void removeView(String name) {
        this.removeView(this.getView(name));
    }

    public void removeView(PilotDBView view) {
        this.views.remove(view);
    }

    public List getViews() {
        return new LinkedList(this.views);
    }

    public PilotDBView getView(int idx) {
        return (PilotDBView)this.views.get(idx);
    }

    public int getViewCount() {
        return this.views.size();
    }

    public PilotDBView getView(String name) {
        int i = 0;
        while (i < this.views.size()) {
            if (this.getView(i).getName().equals(name)) {
                return this.getView(i);
            }
            ++i;
        }
        return null;
    }

    protected void parseFieldNamesChunk(byte[] dat) throws PilotDBException {
        String[] names = StringUtil.getStringArray(dat);
        int i = 0;
        while (i < names.length) {
            this.schema.getField((int)i).name = names[i];
            ++i;
        }
    }

    protected void parseFieldTypesChunk(byte[] dat) throws PilotDBException {
        ByteArray ba = new ByteArray(dat);
        int i = 0;
        while (i < dat.length / 2) {
            this.schema.getField((int)i).type = ba.SHORT();
            ++i;
        }
    }

    protected void parseFieldData(byte[] dat) throws PilotDBException {
        ByteArray ba = new ByteArray(dat);
        short fieldNum = ba.SHORT();
        PilotDBField field = this.schema.getField(fieldNum);
        switch (field.type) {
            case 6: {
                int numItems = ba.SHORT();
                ba.SHORT();
                int i = 0;
                while (i < numItems) {
                    String choice = ba.SZ();
                    field.addListChoice(choice);
                    ++i;
                }
                break;
            }
            case 2: {
                int defaultValue = ba.INT();
                short increment = ba.SHORT();
                field.integerDefaultValue = defaultValue;
                field.integerIncrement = increment;
                break;
            }
            case 0: {
                field.stringDefaultValue = ba.SZ().trim();
                break;
            }
            case 3: {
                byte valid = ba.BYTE();
                if (valid == 1) {
                    field.dateUseCurrent = true;
                    ba.SHORT();
                    ba.BYTE();
                    ba.BYTE();
                    break;
                }
                if (valid != 2) break;
                short year = ba.SHORT();
                byte month = ba.BYTE();
                byte date = ba.BYTE();
                field.dateDefault = new PilotDBDate(year, month, date);
                break;
            }
            case 4: {
                byte valid = ba.BYTE();
                if (valid == 1) {
                    field.timeUseCurrent = true;
                    ba.BYTE();
                    ba.BYTE();
                    break;
                }
                if (valid != 2) break;
                byte hour = ba.BYTE();
                byte minute = ba.BYTE();
                field.timeDefault = new PilotDBTime(hour, minute);
                break;
            }
            case 8: {
                double d;
                field.doubleDefaultValue = d = ba.DOUBLE();
                break;
            }
            case 7: {
                field.linkDbName = ba.SZ(32);
                short linkedFieldNumber = ba.SHORT();
                field.linkFieldNum = linkedFieldNumber;
                break;
            }
            case 10: {
                short linkFieldIndex = ba.SHORT();
                short linkedTableColumnIndex = ba.SHORT();
                field.linkedLinkFieldIndex = linkFieldIndex;
                field.linkedTableColumnIndex = linkedTableColumnIndex;
                break;
            }
            case 9: {
                short byteCodeSize = ba.UBYTE();
                short versionFlag = ba.UBYTE();
                short accessRequirements = ba.UBYTE();
                short returnType = ba.UBYTE();
                ByteArray byteCode = ba.BYTE_ARRAY(byteCodeSize);
                ByteCodeExpressionParser parser = new ByteCodeExpressionParser();
                EvaluationContext ctx = new EvaluationContext();
                try {
                    Script script;
                    field.script = script = parser.parse(ctx, byteCode);
                    field.scriptVersion = versionFlag;
                    field.scriptAccessReq = accessRequirements;
                    field.scriptReturnType = returnType;
                    break;
                }
                catch (InvalidCodeException ice) {
                    throw new PilotDBException(ice.getMessage());
                }
            }
            default: {
                throw new RuntimeException("not yet implemented");
            }
        }
    }

    protected PilotDBAppInfo(PilotDBDatabase db, byte[] data) throws PilotDBException, PalmDbException {
        super(data);
        this.schema = new PilotDBSchema();
        ByteArray ba = new ByteArray(data);
        this.flags = ba.SHORT();
        int fieldCount = ba.SHORT();
        int i = 0;
        while (i < fieldCount) {
            this.schema.addField(new PilotDBField());
            ++i;
        }
        block13: while (ba.hasMoreBytes()) {
            short chunkType = ba.SHORT();
            short dataSize = ba.SHORT();
            ByteArray chunk = ba.BYTE_ARRAY(dataSize);
            switch (chunkType) {
                case 0: {
                    this.parseFieldNamesChunk(chunk.getBytes());
                    break;
                }
                case 1: {
                    this.parseFieldTypesChunk(chunk.getBytes());
                    break;
                }
                case 2: {
                    this.parseFieldData(chunk.getBytes());
                    break;
                }
                case 64: {
                    this.views.add(new PilotDBView(db, chunk));
                    break;
                }
                case 65: {
                    this.viewOptions = new PilotDBViewOptions(chunk);
                    break;
                }
                case 128: {
                    this.lfindOptions = new PilotDBLFindOptions(chunk);
                    break;
                }
                case 512: {
                    try {
                        this.globalScripts.add(new PilotDBGlobalScript(db, chunk));
                    }
                    catch (InvalidCodeException ice) {
                        db.addWarning("The database could not load one of your global scripts. (" + ice.getMessage() + ")");
                        ice.printStackTrace();
                    }
                    continue block13;
                }
                case 1024: {
                    System.out.println("Advanced Filter : " + chunk.toString());
                    break;
                }
                default: {
                    throw new RuntimeException("not yet implemented-chunk type:" + chunkType);
                }
            }
        }
    }

    public List getGlobalScripts() {
        return this.globalScripts;
    }

    public int getDataLength() throws PalmDbException {
        if (this.data != null) {
            return super.getDataLength();
        }
        return this.getData().length;
    }

    public byte[] getData() throws PalmDbException {
        ByteArray ba = new ByteArray(4096);
        ba.SHORT(this.flags, true);
        ba.SHORT(this.schema.getFieldCount(), true);
        ba.SHORT(0, true);
        int len = 0;
        int i = 0;
        while (i < this.schema.getFieldCount()) {
            len += this.schema.getField(i).getName().length() + 1;
            ++i;
        }
        ba.SHORT(len, true);
        i = 0;
        while (i < this.schema.getFieldCount()) {
            ba.SZ(this.schema.getField(i).getName(), true);
            ++i;
        }
        ba.SHORT(1, true);
        ba.SHORT(2 * this.schema.getFieldCount(), true);
        i = 0;
        while (i < this.schema.getFieldCount()) {
            ba.SHORT(this.schema.getField((int)i).type, true);
            ++i;
        }
        this.writeFieldDataChunks(ba);
        i = 0;
        while (i < this.views.size()) {
            PilotDBView view = (PilotDBView)this.views.get(i);
            view.write(ba);
            ++i;
        }
        this.getLFindOptions().write(ba);
        this.getViewOptions().write(ba);
        i = 0;
        while (i < this.globalScripts.size()) {
            PilotDBGlobalScript script = (PilotDBGlobalScript)this.globalScripts.get(i);
            script.write(ba);
            ++i;
        }
        ba.truncate();
        return ba.getBytes();
    }

    protected void writeFieldDataChunks(ByteArray ba) throws PilotDBException {
        int i = 0;
        while (i < this.schema.getFieldCount()) {
            PilotDBField field = this.schema.getField(i);
            if (field.type == 2) {
                ba.SHORT(2, true);
                ba.SHORT(8, true);
                ba.SHORT(i, true);
                ba.INT(field.integerDefaultValue, true);
                ba.SHORT(field.integerIncrement, true);
            } else if (field.type == 0) {
                if (field.stringDefaultValue != null) {
                    ba.SHORT(2, true);
                    ba.SHORT(field.stringDefaultValue.length() + 3, true);
                    ba.SHORT(i, true);
                    ba.SZ(field.stringDefaultValue, true);
                }
            } else if (field.type == 3) {
                ba.SHORT(2, true);
                ba.SHORT(7, true);
                ba.SHORT(i, true);
                if (field.isDateUseCurrent()) {
                    ba.BYTE((byte)1, true).SHORT(0, true).BYTE((byte)0, true).BYTE((byte)0, true);
                } else if (field.getDateDefault() != null) {
                    ba.BYTE((byte)2, true);
                    ba.SHORT(field.dateDefault.year, true);
                    ba.BYTE((byte)field.dateDefault.month, true);
                    ba.BYTE((byte)field.dateDefault.date, true);
                } else {
                    ba.INT(0, true).BYTE((byte)0, true);
                }
            } else if (field.type == 4) {
                ba.SHORT(2, true).SHORT(5, true).SHORT(i, true);
                if (field.isTimeUseCurrent()) {
                    ba.BYTE((byte)1, true);
                    ba.BYTE((byte)0, true);
                    ba.BYTE((byte)0, true);
                } else if (field.getTimeDefault() != null) {
                    ba.BYTE((byte)2, true);
                    ba.BYTE((byte)field.timeDefault.hour, true);
                    ba.BYTE((byte)field.timeDefault.minute, true);
                } else {
                    ba.SHORT(0, true).BYTE((byte)0, true);
                }
            } else if (field.type == 8) {
                ba.SHORT(2, true).SHORT(10, true).SHORT(i, true);
                ba.DOUBLE(field.doubleDefaultValue, true);
            } else if (field.type == 7) {
                if (field.linkDbName != null) {
                    ba.SHORT(2, true).SHORT(36, true).SHORT(i, true);
                    ba.BYTE_ARRAY(StringUtil.getBytes(field.linkDbName, 32), true);
                    ba.SHORT(field.linkFieldNum, true);
                }
            } else if (field.type == 6) {
                if (field.getListChoiceCount() > 0) {
                    String choice;
                    ba.SHORT(2, true);
                    int choicesLen = 0;
                    int j = 0;
                    while (j < field.getListChoiceCount()) {
                        choice = field.getListChoice(j);
                        choicesLen += choice.length() + 1;
                        ++j;
                    }
                    ba.SHORT(6 + choicesLen, true);
                    ba.SHORT(i, true);
                    ba.SHORT(field.getListChoiceCount(), true);
                    ba.SHORT(0, true);
                    j = 0;
                    while (j < field.getListChoiceCount()) {
                        choice = field.getListChoice(j);
                        ba.SZ(choice, true);
                        ++j;
                    }
                }
            } else if (field.type == 10) {
                ba.SHORT(2, true).SHORT(6, true).SHORT(i, true);
                ba.SHORT(field.linkedLinkFieldIndex, true);
                ba.SHORT(field.linkedTableColumnIndex, true);
            } else if (field.type == 9) {
                EvaluationContext ctx = new EvaluationContext();
                ctx.setSchema(this.schema);
                ByteArray byteCode = new ByteArray();
                field.script.toByteCode(ctx, byteCode);
                ByteArray chunk = new ByteArray();
                chunk.SHORT(i, true);
                chunk.BYTE((byte)byteCode.length(), true);
                chunk.BYTE((byte)field.scriptVersion, true);
                chunk.BYTE((byte)field.scriptAccessReq, true);
                chunk.BYTE((byte)field.scriptReturnType, true);
                chunk.BYTE_ARRAY(byteCode.getBytes(), true);
                ba.SHORT(2, true);
                ba.SHORT(chunk.length(), true);
                ba.BYTE_ARRAY(chunk.getBytes(), true);
            }
            ++i;
        }
    }

    public void setViews(List list) {
        this.views = list;
    }
}

