/*
 * Decompiled with CFR 0.152.
 */
package palmdb.util;

public class ByteArray {
    byte[] bytes;
    int pos = -1;
    int mark = -1;

    public String toString() {
        return new String(this.bytes);
    }

    public ByteArray() {
        this.bytes = new byte[0];
        this.pos = 0;
    }

    public ByteArray(byte[] b) {
        this.bytes = b;
        this.pos = 0;
    }

    public ByteArray(int i) {
        this.bytes = new byte[i];
        this.pos = 0;
    }

    public int available() {
        return this.bytes.length - this.pos;
    }

    public boolean hasMoreBytes() {
        return this.pos < this.bytes.length;
    }

    public int length() {
        return this.bytes.length;
    }

    public int position() {
        return this.pos;
    }

    public void cut(int amount) {
        byte[] newBytes = new byte[this.bytes.length - amount];
        System.arraycopy(this.bytes, 0, newBytes, 0, this.pos);
        System.arraycopy(this.bytes, this.pos + amount, newBytes, this.pos, newBytes.length - this.pos);
        this.bytes = newBytes;
    }

    public ByteArray position(int newPosition) {
        this.pos = newPosition;
        return this;
    }

    public void mark() {
        this.mark = this.pos;
    }

    public void resetToMark() {
        if (this.mark == -1) {
            throw new RuntimeException("Mark is -1");
        }
        this.pos = this.mark;
    }

    public ByteArray reset() {
        this.pos = 0;
        return this;
    }

    public final ByteArray BYTE_ARRAY(byte[] b, boolean grow) {
        this.maybeGrow(b.length, grow);
        int i = 0;
        while (i < b.length) {
            this.bytes[this.pos++] = b[i];
            ++i;
        }
        return this;
    }

    public final ByteArray SZ(String string, boolean grow) {
        byte[] bstr = string.getBytes();
        int len = bstr.length;
        this.maybeGrow(len + 1, grow);
        int i = 0;
        while (i < len) {
            this.bytes[this.pos++] = bstr[i];
            ++i;
        }
        this.bytes[this.pos++] = 0;
        return this;
    }

    public final String SZ() {
        int start = this.pos;
        while (this.bytes[this.pos++] != 0) {
        }
        return new String(this.bytes, start, this.pos - 1 - start);
    }

    public final byte BYTE() {
        return this.bytes[this.pos++];
    }

    private void maybeGrow(int byteCount, boolean grow) {
        int trailing = byteCount - (this.bytes.length - this.pos);
        if (trailing > 0) {
            if (grow) {
                byte[] tmp = new byte[this.bytes.length + trailing];
                System.arraycopy(this.bytes, 0, tmp, 0, this.bytes.length);
                this.bytes = tmp;
            } else {
                throw new ArrayIndexOutOfBoundsException("no space for " + byteCount + " bytes");
            }
        }
    }

    public final ByteArray DOUBLE(double d, boolean grow) {
        long l = Double.doubleToRawLongBits(d);
        this.maybeGrow(8, grow);
        this.bytes[this.pos++] = (byte)((l & 0xFF00000000000000L) >> 56);
        this.bytes[this.pos++] = (byte)((l & 0xFF000000000000L) >> 48);
        this.bytes[this.pos++] = (byte)((l & 0xFF0000000000L) >> 40);
        this.bytes[this.pos++] = (byte)((l & 0xFF00000000L) >> 32);
        this.bytes[this.pos++] = (byte)((l & 0xFF000000L) >> 24);
        this.bytes[this.pos++] = (byte)((l & 0xFF0000L) >> 16);
        this.bytes[this.pos++] = (byte)((l & 0xFF00L) >> 8);
        this.bytes[this.pos++] = (byte)(l & 0xFFL);
        return this;
    }

    public final double DOUBLE() {
        long l = 0L;
        l += (long)this.UBYTE();
        l <<= 8;
        l += (long)this.UBYTE();
        l <<= 8;
        l += (long)this.UBYTE();
        l <<= 8;
        l += (long)this.UBYTE();
        l <<= 8;
        l += (long)this.UBYTE();
        l <<= 8;
        l += (long)this.UBYTE();
        l <<= 8;
        l += (long)this.UBYTE();
        l <<= 8;
        return Double.longBitsToDouble(l += (long)this.UBYTE());
    }

    public final ByteArray INT(int i, boolean grow) {
        this.maybeGrow(4, grow);
        this.bytes[this.pos++] = (byte)((i & 0xFF000000) >> 24);
        this.bytes[this.pos++] = (byte)((i & 0xFF0000) >> 16);
        this.bytes[this.pos++] = (byte)((i & 0xFF00) >> 8);
        this.bytes[this.pos++] = (byte)(i & 0xFF);
        return this;
    }

    public final ByteArray BYTE(byte b, boolean grow) {
        this.maybeGrow(1, grow);
        this.bytes[this.pos++] = b;
        return this;
    }

    public final ByteArray SHORT(int s, boolean grow) {
        this.maybeGrow(2, grow);
        this.bytes[this.pos++] = (byte)((s & 0xFF00) >> 8);
        this.bytes[this.pos++] = (byte)(s & 0xFF);
        return this;
    }

    public final int INT() {
        int i = 0;
        i += this.UBYTE();
        i <<= 8;
        i += this.UBYTE();
        i <<= 8;
        i += this.UBYTE();
        i <<= 8;
        return i += this.UBYTE();
    }

    public final short SHORT() {
        short s = 0;
        s = (short)(s + this.UBYTE());
        s = (short)(s << 8);
        s = (short)(s + this.UBYTE());
        return s;
    }

    public final short UBYTE() {
        short b;
        return (b = this.bytes[this.pos++]) < 0 ? (short)(256 + b) : b;
    }

    public static void main(String[] args) throws Exception {
        byte[] byArray = new byte[21];
        byArray[1] = 2;
        byArray[3] = 3;
        byArray[7] = 7;
        byArray[8] = 97;
        byArray[9] = 98;
        byArray[10] = 99;
        byArray[11] = 100;
        byArray[13] = 64;
        byArray[14] = 42;
        byte[] b = byArray;
        ByteArray ba = new ByteArray(b);
        System.out.println(ba.SHORT());
        System.out.println(ba.SHORT());
        System.out.println(ba.INT());
        ba.mark();
        System.out.println(ba.SZ());
        System.out.println(ba.DOUBLE());
        ba.reset();
        ba.INT(10, false);
        ba.reset();
        System.out.println(ba.INT());
        ba.resetToMark();
        System.out.println(ba.SZ());
        ba.pos = ba.length() - 1;
        ba.INT(15, true);
        ba.pos = ba.length() - 1;
        ba.mark();
        ba.SZ("trever", true);
        ba.resetToMark();
        System.out.println(ba.SZ());
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String SZ(int i) {
        int newPos = this.pos + i;
        String s = this.SZ();
        this.pos = newPos;
        return s;
    }

    public void trim() {
        byte[] newbytes = new byte[this.pos];
        System.arraycopy(this.bytes, 0, newbytes, 0, this.pos);
        this.bytes = newbytes;
        if (this.mark > this.pos) {
            this.mark = 0;
        }
    }

    public ByteArray BYTE_ARRAY(int length) {
        ByteArray newba = new ByteArray(length);
        System.arraycopy(this.bytes, this.pos, newba.bytes, 0, length);
        this.pos += length;
        return newba;
    }

    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (arg0 instanceof ByteArray) {
            ByteArray rhs = (ByteArray)arg0;
            if (this.bytes.length != rhs.bytes.length) {
                return false;
            }
            int i = 0;
            while (i < this.bytes.length) {
                if (this.bytes[i] != rhs.bytes[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return super.equals(arg0);
    }

    public void insertBlank(int i) {
        byte[] newbytes = new byte[this.bytes.length + i];
        System.arraycopy(this.bytes, 0, newbytes, 0, this.pos);
        System.arraycopy(this.bytes, this.pos, newbytes, this.pos + i, this.bytes.length - this.pos);
        this.bytes = newbytes;
    }

    public void setBytes(byte[] recordData) {
        this.bytes = recordData;
        this.reset();
    }

    public void truncate() {
        byte[] newbytes = new byte[this.pos];
        System.arraycopy(this.bytes, 0, newbytes, 0, this.pos);
        this.bytes = newbytes;
    }

    public void SZ(String text, int size, boolean grow) {
        if (text.length() > size - 1) {
            text = text.substring(0, size - 1);
        }
        this.mark();
        this.BYTE_ARRAY(new byte[size], grow);
        this.resetToMark();
        this.SZ(text, false);
        this.resetToMark();
        this.position(this.position() + size);
    }
}

