/*
 * Decompiled with CFR 0.152.
 */
package palmdb;

import java.io.IOException;
import java.util.LinkedList;
import palmdb.util.ByteArray;

public class StringUtil {
    public static final byte[] getNullTerminatedBytes(String in) {
        ByteArray buffer = new ByteArray(new byte[in.length() + 1]);
        buffer.SZ(in, false);
        return buffer.getBytes();
    }

    public static byte[] getZTArray(String[] s) throws IOException {
        ByteArray ba = new ByteArray();
        int i = 0;
        while (i < s.length) {
            ba.SZ(s[i], true);
            ++i;
        }
        return ba.getBytes();
    }

    public static final String getString(byte[] bytes) {
        ByteArray ba = new ByteArray(bytes);
        return ba.SZ();
    }

    public static final byte[] getBytes(String s, int limit) {
        if (s.length() > limit - 1) {
            s = s.substring(0, limit - 1);
        }
        ByteArray ba = new ByteArray(new byte[limit]);
        ba.SZ(s, false);
        return ba.getBytes();
    }

    public static String[] getStringArray(byte[] inputBytes) {
        ByteArray input = new ByteArray(inputBytes);
        LinkedList<String> list = new LinkedList<String>();
        while (input.hasMoreBytes()) {
            list.add(input.SZ());
        }
        return list.toArray(new String[0]);
    }
}

