/*
 * Decompiled with CFR 0.152.
 */
package palmdb;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import palmdb.BitOps;
import palmdb.PalmDbException;

public class RecordHeader {
    public static final byte ATTR_SECRET = 16;
    public static final byte ATTR_BUSY = 32;
    public static final byte ATTR_DIRTY = 64;
    public static final byte ATTR_DELETE = -128;
    public static final int RECORD_HEADER_LENGTH = 8;
    public int uniqueId;
    public int localChunkId;
    boolean isDeleted;
    boolean isDirty;
    boolean isSecret;
    boolean isBusy;
    private int category = 0;

    public void setDelete(boolean b) {
        this.isDeleted = b;
    }

    public boolean isDelete() {
        return this.isDeleted;
    }

    public void setDirty(boolean b) {
        this.isDirty = b;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setBusy(boolean b) {
        this.isBusy = b;
    }

    public boolean isBusy() {
        return this.isBusy;
    }

    public void setSecret(boolean b) {
        this.isSecret = b;
    }

    public boolean isSecret() {
        return this.isSecret;
    }

    public RecordHeader() {
    }

    public boolean isId(int id) {
        return this.uniqueId == id;
    }

    public RecordHeader(InputStream is) throws PalmDbException {
        try {
            DataInputStream dis = new DataInputStream(is);
            this.localChunkId = dis.readInt();
            byte attributes = dis.readByte();
            this.isBusy = (attributes & 0x20) == 32;
            this.isDirty = (attributes & 0x40) == 64;
            this.isSecret = (attributes & 0x10) == 16;
            this.isDeleted = (attributes & 0xFFFFFF80) == -128;
            this.category = attributes & 0xF;
            byte[] id = new byte[3];
            dis.read(id);
            this.uniqueId = BitOps.intFrom3ByteArray(id);
        }
        catch (IOException ioe) {
            throw new PalmDbException(ioe);
        }
    }

    public void write(OutputStream os) throws PalmDbException {
        try {
            DataOutputStream dos = new DataOutputStream(os);
            dos.writeInt(this.localChunkId);
            int attributes = 0;
            attributes = (byte)(attributes | (this.isBusy ? 32 : 0));
            attributes = (byte)(attributes | (this.isDirty ? 64 : 0));
            attributes = (byte)(attributes | (this.isSecret ? 16 : 0));
            attributes = (byte)(attributes | (this.isDeleted ? -128 : 0));
            attributes = (byte)(attributes | this.category & 0xF);
            dos.writeByte(attributes);
            dos.write(BitOps.intTo3ByteArray(this.uniqueId));
        }
        catch (IOException ioe) {
            throw new PalmDbException(ioe);
        }
    }

    public int getCategory() {
        return this.category;
    }

    public void setCategory(int category) {
        this.category = category;
    }
}

