/*
 * Decompiled with CFR 0.152.
 */
package palmdb;

import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class PalmPreferences {
    public static final PalmDateFormat[] PALM_DATE_FORMATS = new PalmDateFormat[]{new PalmDateFormat("M/D/Y", new SimpleDateFormat("MM/dd/yy")), new PalmDateFormat("D/M/Y", new SimpleDateFormat("dd/MM/yy")), new PalmDateFormat("D.M.Y", new SimpleDateFormat("dd.MM.yy")), new PalmDateFormat("D-M-Y", new SimpleDateFormat("dd-MM-yy")), new PalmDateFormat("Y/M/D", new SimpleDateFormat("yy/MM/dd")), new PalmDateFormat("Y.M.D", new SimpleDateFormat("yy.MM.dd")), new PalmDateFormat("Y-M-D", new SimpleDateFormat("yy-MM-dd"))};
    public static final PalmTimeFormat[] PALM_TIME_FORMATS = new PalmTimeFormat[]{new PalmTimeFormat("HH:MM am/pm", new SimpleDateFormat("hh:mm a")), new PalmTimeFormat("HH:MM", new SimpleDateFormat("HH:mm")), new PalmTimeFormat("HH.MM am/pm", new SimpleDateFormat("hh.mm a")), new PalmTimeFormat("HH.MM", new SimpleDateFormat("HH.mm")), new PalmTimeFormat("HH,MM", new SimpleDateFormat("HH,mm"))};
    private static PalmPreferences instance;
    private PalmDateFormat palmDateFormat = PALM_DATE_FORMATS[4];
    private PalmTimeFormat palmTimeFormat = PALM_TIME_FORMATS[1];

    public static final PalmPreferences getInstance() {
        if (instance == null) {
            instance = new PalmPreferences();
        }
        return instance;
    }

    public void setPalmTimeFormat(String format) {
        int i = 0;
        while (i < PALM_TIME_FORMATS.length) {
            if (PALM_TIME_FORMATS[i].getPalmTimeFormat().equals(format)) {
                this.palmTimeFormat = PALM_TIME_FORMATS[i];
                break;
            }
            ++i;
        }
    }

    public void setPalmDateFormat(String format) {
        int i = 0;
        while (i < PALM_DATE_FORMATS.length) {
            if (PALM_DATE_FORMATS[i].getPalmDateFormat().equals(format)) {
                this.palmDateFormat = PALM_DATE_FORMATS[i];
                break;
            }
            ++i;
        }
    }

    public PalmDateFormat getPalmDateFormat() {
        return this.palmDateFormat;
    }

    public PalmTimeFormat getPalmTimeFormat() {
        return this.palmTimeFormat;
    }

    public void setPalmDateFormat(PalmDateFormat palmDateFormat) {
        this.palmDateFormat = palmDateFormat;
    }

    public void setPalmTimeFormat(PalmTimeFormat palmTimeFormat) {
        this.palmTimeFormat = palmTimeFormat;
    }

    public static final class PalmDateFormat {
        String palmDateFormat;
        DateFormat javaDateFormat;

        private PalmDateFormat(String palmDateFormat, DateFormat javaDateFormat) {
            this.palmDateFormat = palmDateFormat;
            this.javaDateFormat = javaDateFormat;
        }

        public DateFormat getJavaDateFormat() {
            return this.javaDateFormat;
        }

        public String getPalmDateFormat() {
            return this.palmDateFormat;
        }

        public String toString() {
            return this.palmDateFormat;
        }
    }

    public static final class PalmTimeFormat {
        String palmTimeFormat;
        DateFormat javaTimeFormat;

        private PalmTimeFormat(String palmTimeFormat, DateFormat javaTimeFormat) {
            this.palmTimeFormat = palmTimeFormat;
            this.javaTimeFormat = javaTimeFormat;
        }

        public DateFormat getJavaTimeFormat() {
            return this.javaTimeFormat;
        }

        public String getPalmTimeFormat() {
            return this.palmTimeFormat;
        }

        public String toString() {
            return this.palmTimeFormat;
        }
    }
}

