/*
 * Decompiled with CFR 0.152.
 */
package palmdb;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import palmdb.util.ByteArray;

public class ByteArrayTest
extends TestCase {
    static /* synthetic */ Class class$0;

    public ByteArrayTest(String arg0) {
        super(arg0);
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite("Byte Array Test");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("palmdb.ByteArrayTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        testSuite.addTestSuite((Class)clazz);
        return testSuite;
    }

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("palmdb.ByteArrayTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAvailable() {
        byte[] byArray = new byte[6];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byte[] bytes = byArray;
        ByteArray ba = new ByteArray(bytes);
        ByteArrayTest.assertEquals((String)"Available", (int)6, (int)ba.available());
        ba.INT();
        ByteArrayTest.assertEquals((String)"Available", (int)2, (int)ba.available());
    }

    public void testHasMoreBytes() {
        byte[] byArray = new byte[6];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byte[] bytes = byArray;
        ByteArray ba = new ByteArray(bytes);
        ByteArrayTest.assertEquals((String)"Has More Bytes", (boolean)true, (boolean)ba.hasMoreBytes());
        ba.BYTE_ARRAY(6);
        ByteArrayTest.assertEquals((String)"Has More Bytes", (boolean)false, (boolean)ba.hasMoreBytes());
    }

    public void testCut() {
        byte[] byArray = new byte[6];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byte[] bytes = byArray;
        ByteArray ba = new ByteArray(bytes);
        ba.position(2);
        ba.cut(2);
        ba.mark();
        ByteArrayTest.assertEquals((String)"Next Byte", (int)4, (int)ba.BYTE());
        ba.resetToMark();
        ba.cut(1);
        ByteArrayTest.assertEquals((String)"Next Byte", (int)5, (int)ba.BYTE());
        ByteArrayTest.assertEquals((String)"Has More Bytes", (boolean)false, (boolean)ba.hasMoreBytes());
    }

    public void testTruncate() {
        byte[] byArray = new byte[6];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byte[] bytes = byArray;
        ByteArray ba = new ByteArray(bytes);
        ba.position(2);
        ba.truncate();
        ba.reset();
        ByteArrayTest.assertEquals((int)0, (int)ba.BYTE());
        ByteArrayTest.assertEquals((int)1, (int)ba.BYTE());
        ByteArrayTest.assertEquals((boolean)false, (boolean)ba.hasMoreBytes());
    }

    public void testInsertBlank() {
        byte[] byArray = new byte[6];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byte[] bytes = byArray;
        ByteArray ba = new ByteArray(bytes);
        ba.position(2);
        ba.insertBlank(3);
        ba.reset();
        ByteArrayTest.assertEquals((int)0, (int)ba.BYTE());
        ByteArrayTest.assertEquals((int)1, (int)ba.BYTE());
        ByteArrayTest.assertEquals((int)0, (int)ba.BYTE());
        ByteArrayTest.assertEquals((int)0, (int)ba.BYTE());
        ByteArrayTest.assertEquals((int)0, (int)ba.BYTE());
        ByteArrayTest.assertEquals((int)2, (int)ba.BYTE());
        ByteArrayTest.assertEquals((int)3, (int)ba.BYTE());
        ByteArrayTest.assertEquals((int)4, (int)ba.BYTE());
        ByteArrayTest.assertEquals((int)5, (int)ba.BYTE());
    }
}

