/*
 * Decompiled with CFR 0.152.
 */
package palmdb;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;

public class BitOps {
    static final Random random = new Random(System.currentTimeMillis());
    private static final int[] BYTE_BIT_POS_VALUE = new int[]{1, 2, 4, 8, 16, 32, 64, 128};

    public static final int generate3ByteId() {
        return BitOps.intTo3ByteInt(random.nextInt());
    }

    public static final String displayBits(byte b) {
        char[] buffer = new char[8];
        int remainder = b & 0xFF;
        int i = 7;
        while (i > -1) {
            if (remainder < BYTE_BIT_POS_VALUE[i]) {
                buffer[7 - i] = 48;
            } else {
                buffer[7 - i] = Character.forDigit(Math.min(remainder / BYTE_BIT_POS_VALUE[i], 1), 10);
                remainder %= BYTE_BIT_POS_VALUE[i];
            }
            --i;
        }
        return new String(buffer);
    }

    public static final String displayBits(int integer) {
        StringBuffer sb = new StringBuffer();
        sb.append(BitOps.displayBits((byte)((0xFF000000 & integer) >> 24)));
        sb.append('|');
        sb.append(BitOps.displayBits((byte)((0xFF0000 & integer) >> 16)));
        sb.append('|');
        sb.append(BitOps.displayBits((byte)((0xFF00 & integer) >> 8)));
        sb.append('|');
        sb.append(BitOps.displayBits((byte)((0xFF & integer) >> 0)));
        return sb.toString();
    }

    public static final String integerToString(int i) {
        byte[] b = new byte[4];
        b[3] = (byte)((i & 0xFF) >> 0);
        b[2] = (byte)((i & 0xFF00) >> 8);
        b[1] = (byte)((i & 0xFF0000) >> 16);
        b[0] = (byte)((i & 0xFF000000) >> 24);
        return new String(b);
    }

    public static final int intFrom3ByteArray(byte[] b) {
        int val = 0;
        val += b[2] & 0xFF;
        val += (b[1] & 0xFF) << 8;
        return val += (b[0] & 0xFF) << 16;
    }

    public static final byte[] intTo3ByteArray(int val) {
        int i = BitOps.intTo3ByteInt(val);
        byte[] b = new byte[3];
        b[2] = (byte)((i & 0xFF) >> 0);
        b[1] = (byte)((i & 0xFF00) >> 8);
        b[0] = (byte)((i & 0xFF0000) >> 16);
        return b;
    }

    public static final int intTo3ByteInt(int value) {
        return value & 0xFFFFFF;
    }

    public static void main(String[] args) throws IOException {
        System.out.println(BitOps.displayBits((byte)5));
        System.out.println(BitOps.displayBits((byte)33));
        System.out.println(BitOps.displayBits((byte)-127));
        System.out.println(BitOps.displayBits(256));
        System.out.println(BitOps.displayBits(257));
        int val = BitOps.stringToInteger("DBOS");
        System.out.println(val);
        String vals = BitOps.integerToString(val);
        System.out.println(vals);
        System.out.println(BitOps.intTo3ByteInt(-1));
        byte[] b = BitOps.intTo3ByteArray(-1);
        int i = 0;
        while (i < b.length) {
            if (i > 0) {
                System.out.print('|');
            }
            System.out.print(BitOps.byteToInt(b[i]));
            ++i;
        }
        System.out.println();
        System.out.println(BitOps.intFrom3ByteArray(b));
        byte[] bx = new byte[]{-1, -1, -1};
        System.out.println(BitOps.displayBits(BitOps.intFrom3ByteArray(bx)));
        FileOutputStream fos = new FileOutputStream("c:/out.bin");
        fos.write(b);
        fos.close();
    }

    public static final int stringToInteger(String in) {
        byte[] b = in.getBytes();
        int value = 0;
        value += (b[0] & 0xFF) << 24;
        value += (b[1] & 0xFF) << 16;
        value += (b[2] & 0xFF) << 8;
        return value += (b[3] & 0xFF) << 0;
    }

    public static int byteToInt(byte b) {
        return b & 0xFF;
    }

    public static final int swapLittleEndianToBigEndian(int i) {
        int val = 0;
        int b = 0;
        while (b < 4) {
            val <<= 8;
            val += i & 0xFF;
            i >>= 8;
            ++b;
        }
        return val;
    }
}

