/*
 * Decompiled with CFR 0.152.
 */
package palm.todo;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import palm.todo.ToDoAppInfo;
import palm.todo.ToDoRecord;
import palmdb.AppInfo;
import palmdb.Database;
import palmdb.PalmDbException;
import palmdb.Record;
import palmdb.RecordHeader;

public class ToDoDatabase
extends Database {
    public ToDoDatabase() {
        super("ToDoDB", "DATA", "todo");
        this.appInfo = new ToDoAppInfo();
    }

    public ToDoDatabase(InputStream is) throws IOException, PalmDbException {
        super(is);
    }

    public Collection getAllDescriptions() {
        LinkedList<String> list = new LinkedList<String>();
        Iterator iter = this.getRecordsIterator();
        while (iter.hasNext()) {
            ToDoRecord rec = (ToDoRecord)iter.next();
            list.add(rec.getDescription());
        }
        return list;
    }

    public Collection getAllByPriority(int priority) {
        LinkedList<ToDoRecord> list = new LinkedList<ToDoRecord>();
        Iterator iter = this.getRecordsIterator();
        while (iter.hasNext()) {
            ToDoRecord rec = (ToDoRecord)iter.next();
            if (rec.getPriority() != priority) continue;
            list.add(rec);
        }
        return list;
    }

    public Collection getAllByCategory(String cat) {
        LinkedList<ToDoRecord> list = new LinkedList<ToDoRecord>();
        Iterator iter = this.getRecordsIterator();
        while (iter.hasNext()) {
            ToDoRecord rec = (ToDoRecord)iter.next();
            if (cat == null && rec.getCategory() == null) {
                list.add(rec);
                continue;
            }
            if (!rec.getCategory().equals(cat)) continue;
            list.add(rec);
        }
        return list;
    }

    public ToDoRecord createToDoItem(String desc, String note, int priority, String category, Date date) throws Exception {
        ToDoRecord rec = new ToDoRecord(this);
        rec.setDescription(desc);
        rec.setNote(note);
        rec.setPriority(priority);
        rec.setDueDate(date);
        rec.setCategory(category);
        this.records.add(rec);
        return rec;
    }

    public ToDoRecord createToDoItem() {
        ToDoRecord rec = new ToDoRecord(this);
        this.records.add(rec);
        return rec;
    }

    protected Record buildRecord(RecordHeader header, byte[] data) throws PalmDbException {
        return new ToDoRecord(header, data);
    }

    protected AppInfo buildAppInfo(byte[] data) throws PalmDbException {
        return new ToDoAppInfo(data);
    }

    public static void main(String[] args) throws Exception {
        ToDoDatabase db = new ToDoDatabase();
        ToDoRecord record = db.createToDoItem();
        record.setDescription("test1");
        record.setNote("test2");
        record.setIsCompleted(true);
        record.setPriority(3);
        record.setCategory("Business");
        System.out.println(record.getCategory());
        FileOutputStream fos = new FileOutputStream("c:/fromscratch_todo.pdb");
        db.write(fos);
        Collection col = db.getAllByPriority(3);
        System.out.println(col.size() == 1);
        col = db.getAllByCategory("Business");
        System.out.println(col.size() == 1);
        col = db.getAllDescriptions();
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            System.out.println("Description:" + iter.next());
        }
    }
}

