/*
 * Decompiled with CFR 0.152.
 */
package palm.conduit;

import java.io.IOException;

public class SyncException
extends IOException {
    public int errorCode;
    public static final int NONE = 0;
    public static final int FIRST = 16384;
    public static final int UNKNOWN = 16385;
    public static final int MORE = 16386;
    public static final int FILE_NOT_FOUND = 16387;
    public static final int FILE_NOT_OPEN = 16388;
    public static final int FILE_OPEN = 16389;
    public static final int RECORD_BUSY = 16390;
    public static final int RECORD_DELETED = 16391;
    public static final int ROM_BASED = 16392;
    public static final int READ_ONLY = 16393;
    public static final int COMM_NOT_INIT = 16394;
    public static final int FILE_ALREADY_EXIST = 16395;
    public static final int FILE_ALREADY_OPEN = 16396;
    public static final int NO_FILES_OPEN = 16397;
    public static final int BAD_OPERATION = 16398;
    public static final int REMOTE_BAD_ARG = 16399;
    public static final int BAD_ARG_WRAPPER = 16400;
    public static final int ARG_MISSING = 16401;
    public static final int LOCAL_BUFF_TOO_SMALL = 16402;
    public static final int REMOTE_MEM = 16403;
    public static final int REMOTE_NO_SPACE = 16404;
    public static final int REMOTE_SYS = 16405;
    public static final int LOCAL_MEM = 16406;
    public static final int BAD_ARG = 16407;
    public static final int LIMIT_EXCEEDED = 16408;
    public static final int UNKNOWN_REQUEST = 16409;
    public static final int DEPRECATED = 16410;
    static final int LAST = 16411;
    static final int NUM = 27;
    static final String[] details = new String[]{"None", "First", "More", "File Not Found", "File Not Open", "File Open", "Record Busy", "Record Deleted", "Rom Based", "Read Only", "Comm Not Init", "File Already Exist", "File Already Open", "No Files Open", "Bad Operation", "Remote Bad Arg", "Bad Arg Wrapper", "Arg Missing", "Local Buff Too Small", "Remote Mem", "Remote No Space", "Remote Sys", "Local Memory Exceeded", "Invalid Parameter", "Data Limit Exceeded", "Unknown Request", "Function deprecated"};

    public SyncException(String string, int n) {
        super(string);
        this.errorCode = n;
    }

    public SyncException(String string) {
        super(string);
    }

    public String getMessage() {
        return this.getDetailMessage() + ": " + super.getMessage();
    }

    String getDetailMessage() {
        if (16384 <= this.errorCode && this.errorCode < 16411) {
            return details[this.errorCode - 16384];
        }
        return "Unknown";
    }

    String superGetMessage() {
        return super.getMessage();
    }
}

