/*
 * Decompiled with CFR 0.152.
 */
package palm.conduit;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import palm.conduit.AbstractRecord;

public class AddressRecord
extends AbstractRecord {
    private int[] phoneLabelId = new int[]{0, 0, 0, 0, 0};
    private int displayPhone = 0;
    private String name = null;
    private String firstName = null;
    private String company = null;
    private String[] phones = new String[]{null, null, null, null, null};
    private String address = null;
    private String city = null;
    private String state = null;
    private String zipCode = null;
    private String country = null;
    private String[] customs = new String[]{null, null, null, null, null};
    private String note = null;
    private static String[] phoneLabelText = new String[]{"Work", "Home", "Fax", "Other", "E-mail", "Main", "Pager", "Mobile"};

    public static String getPhoneLabelText(int n) {
        return phoneLabelText[n];
    }

    public int getPhoneLabelId(int n) {
        return this.phoneLabelId[n];
    }

    public void setPhoneLabelId(int n, int n2) {
        this.phoneLabelId[n] = n2;
    }

    public int getDisplayPhone() {
        return this.displayPhone;
    }

    public void setDisplayPhone(int n) {
        this.displayPhone = n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = this.nullIfEmpty(string);
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String string) {
        this.firstName = this.nullIfEmpty(string);
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String string) {
        this.company = this.nullIfEmpty(string);
    }

    public String getPhone(int n) {
        return this.phones[n];
    }

    public void setPhone(int n, String string) {
        this.phones[n] = this.nullIfEmpty(string);
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String string) {
        this.address = this.nullIfEmpty(string);
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String string) {
        this.city = this.nullIfEmpty(string);
    }

    public String getState() {
        return this.state;
    }

    public void setState(String string) {
        this.state = this.nullIfEmpty(string);
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public void setZipCode(String string) {
        this.zipCode = this.nullIfEmpty(string);
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String string) {
        this.country = this.nullIfEmpty(string);
    }

    public String getCustom(int n) {
        return this.customs[n];
    }

    public void setCustom(int n, String string) {
        this.customs[n] = this.nullIfEmpty(string);
    }

    public String getTitle() {
        return this.customs[0];
    }

    public void setTitle(String string) {
        this.setCustom(0, string);
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String string) {
        this.note = this.nullIfEmpty(string);
    }

    public void writeData(DataOutputStream dataOutputStream) throws IOException {
        int n = (this.displayPhone & 0xF) - 1;
        int n2 = 5;
        n2 = 0;
        while (n2 < 5) {
            n <<= 4;
            n |= this.phoneLabelId[4 - n2] & 0xF;
            ++n2;
        }
        dataOutputStream.writeInt(n);
        int n3 = 0;
        if (this.note != null) {
            n3 |= 1;
        }
        n3 <<= 1;
        n2 = 5;
        while (n2-- > 0) {
            if (this.customs[n2] != null) {
                n3 |= 1;
            }
            n3 <<= 1;
        }
        if (this.country != null) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.zipCode != null) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.state != null) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.city != null) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.address != null) {
            n3 |= 1;
        }
        n3 <<= 1;
        n2 = 5;
        while (n2-- > 0) {
            if (this.phones[n2] != null) {
                n3 |= 1;
            }
            n3 <<= 1;
        }
        if (this.company != null) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.firstName != null) {
            n3 |= 1;
        }
        n3 <<= 1;
        if (this.name != null) {
            n3 |= 1;
        }
        dataOutputStream.writeInt(n3);
        dataOutputStream.write(0);
        if (this.name != null) {
            dataOutputStream.write(this.name.getBytes());
            dataOutputStream.write(0);
        }
        if (this.firstName != null) {
            dataOutputStream.write(this.firstName.getBytes());
            dataOutputStream.write(0);
        }
        if (this.company != null) {
            dataOutputStream.write(this.company.getBytes());
            dataOutputStream.write(0);
        }
        n2 = 0;
        while (n2 < 5) {
            if (this.phones[n2] != null) {
                dataOutputStream.write(this.phones[n2].getBytes());
                dataOutputStream.write(0);
            }
            ++n2;
        }
        if (this.address != null) {
            dataOutputStream.write(this.address.getBytes());
            dataOutputStream.write(0);
        }
        if (this.city != null) {
            dataOutputStream.write(this.city.getBytes());
            dataOutputStream.write(0);
        }
        if (this.state != null) {
            dataOutputStream.write(this.state.getBytes());
            dataOutputStream.write(0);
        }
        if (this.zipCode != null) {
            dataOutputStream.write(this.zipCode.getBytes());
            dataOutputStream.write(0);
        }
        if (this.country != null) {
            dataOutputStream.write(this.country.getBytes());
            dataOutputStream.write(0);
        }
        n2 = 0;
        while (n2 < 5) {
            if (this.customs[n2] != null) {
                dataOutputStream.write(this.customs[n2].getBytes());
                dataOutputStream.write(0);
            }
            ++n2;
        }
        if (this.note != null) {
            AbstractRecord.writeCString(dataOutputStream, AbstractRecord.stringWithoutCarriageReturns(this.note));
        }
    }

    public void readData(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        int n2 = 0;
        while (n2 < 5) {
            this.phoneLabelId[n2] = n & 0xF;
            n >>>= 4;
            ++n2;
        }
        this.displayPhone = (n & 0xF) + 1;
        int n3 = dataInputStream.readInt();
        dataInputStream.read();
        this.name = (n3 & 1) == 1 ? AbstractRecord.readCString(dataInputStream) : null;
        this.firstName = ((n3 >>>= 1) & 1) == 1 ? AbstractRecord.readCString(dataInputStream) : null;
        this.company = ((n3 >>>= 1) & 1) == 1 ? AbstractRecord.readCString(dataInputStream) : null;
        n3 >>>= 1;
        n2 = 0;
        while (n2 < 5) {
            this.phones[n2] = (n3 & 1) == 1 ? AbstractRecord.readCString(dataInputStream) : null;
            n3 >>>= 1;
            ++n2;
        }
        this.address = (n3 & 1) == 1 ? AbstractRecord.readCString(dataInputStream) : null;
        this.city = ((n3 >>>= 1) & 1) == 1 ? AbstractRecord.readCString(dataInputStream) : null;
        this.state = ((n3 >>>= 1) & 1) == 1 ? AbstractRecord.readCString(dataInputStream) : null;
        this.zipCode = ((n3 >>>= 1) & 1) == 1 ? AbstractRecord.readCString(dataInputStream) : null;
        this.country = ((n3 >>>= 1) & 1) == 1 ? AbstractRecord.readCString(dataInputStream) : null;
        n3 >>>= 1;
        n2 = 0;
        while (n2 < 5) {
            this.customs[n2] = (n3 & 1) == 1 ? AbstractRecord.readCString(dataInputStream) : null;
            n3 >>>= 1;
            ++n2;
        }
        this.note = (n3 & 1) == 1 ? AbstractRecord.readCString(dataInputStream) : null;
        n3 >>>= 1;
    }

    public String toString() {
        return "Address record: " + this.getFirstName() + " " + this.getName() + " " + super.toString();
    }

    public String toFormattedString() {
        return "Address record: {\r\n  name: " + this.getName() + "\r\n" + "  firstName: " + this.getFirstName() + "\r\n" + "  title: " + this.getTitle() + "\r\n" + "  company: " + this.getCompany() + "\r\n" + "  " + AddressRecord.getPhoneLabelText(this.getPhoneLabelId(0)) + ": " + this.getPhone(0) + "\r\n" + "  " + AddressRecord.getPhoneLabelText(this.getPhoneLabelId(1)) + ": " + this.getPhone(1) + "\r\n" + "  " + AddressRecord.getPhoneLabelText(this.getPhoneLabelId(2)) + ": " + this.getPhone(2) + "\r\n" + "  " + AddressRecord.getPhoneLabelText(this.getPhoneLabelId(3)) + ": " + this.getPhone(3) + "\r\n" + "  " + AddressRecord.getPhoneLabelText(this.getPhoneLabelId(4)) + ": " + this.getPhone(4) + "\r\n" + "  displayPhone: " + AddressRecord.getPhoneLabelText(this.getDisplayPhone() - 1) + "\r\n" + "  address: " + this.getAddress() + "\r\n" + "  city: " + this.getCity() + "\r\n" + "  state: " + this.getState() + "\r\n" + "  zipCode: " + this.getZipCode() + "\r\n" + "  country: " + this.getCountry() + "\r\n" + "  custom1: " + this.getCustom(1) + "\r\n" + "  custom2: " + this.getCustom(2) + "\r\n" + "  custom3: " + this.getCustom(3) + "\r\n" + "  custom4: " + this.getCustom(4) + "\r\n" + "  note: " + this.getNote() + "\r\n" + "}\r\n" + super.toFormattedString();
    }
}

