/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.object;

import org.farng.mp3.object.AbstractMP3Object;
import org.farng.mp3.object.ObjectLyrics3TimeStamp;

public class ObjectLyrics3Image
extends AbstractMP3Object {
    private ObjectLyrics3TimeStamp time = null;
    private String description = "";
    private String filename = "";

    public ObjectLyrics3Image(String identifier) {
        this.identifier = identifier;
    }

    public ObjectLyrics3Image(ObjectLyrics3Image copyObject) {
        super(copyObject);
        this.time = new ObjectLyrics3TimeStamp(copyObject.time);
        this.description = new String(copyObject.description);
        this.filename = new String(copyObject.filename);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getSize() {
        int size = this.filename.length() + 2 + this.description.length() + 2;
        if (this.time != null) {
            size += this.time.getSize();
        }
        return size;
    }

    public void setTimeStamp(ObjectLyrics3TimeStamp time) {
        this.time = time;
    }

    public ObjectLyrics3TimeStamp getTimeStamp() {
        return this.time;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObjectLyrics3Image)) {
            return false;
        }
        ObjectLyrics3Image object = (ObjectLyrics3Image)obj;
        if (!this.description.equals(object.description)) {
            return false;
        }
        if (!this.filename.equals(object.filename)) {
            return false;
        }
        if (this.time == null ? object.time != null : !this.time.equals(object.time)) {
            return false;
        }
        return super.equals(obj);
    }

    public void readString(String imageString, int offset) {
        if (imageString == null) {
            throw new NullPointerException("Image string is null");
        }
        if (offset < 0 || offset >= imageString.length()) {
            throw new IndexOutOfBoundsException("Offset to image string is out of bounds: offset = " + offset + ", string.length()" + imageString.length());
        }
        if (imageString != null) {
            int delim = imageString.indexOf("||", offset);
            this.filename = imageString.substring(offset, delim);
            offset = delim + 2;
            delim = imageString.indexOf("||", offset);
            this.description = imageString.substring(offset, delim);
            offset = delim + 2;
            String timestamp = imageString.substring(offset);
            if (timestamp.length() == 7) {
                this.time = new ObjectLyrics3TimeStamp("Time Stamp");
                this.time.readString(timestamp);
            }
        }
    }

    public String toString() {
        String str = "filename = " + this.filename + ", description = " + this.description;
        if (this.time != null) {
            str = str + ", timestamp = " + this.time.toString();
        }
        return str + "\n";
    }

    public String writeString() {
        String str = "";
        str = this.filename == null ? "||" : this.filename + "||";
        str = this.description == null ? str + "||" : str + this.description + "||";
        if (this.time != null) {
            str = str + this.time.writeString();
        }
        return str;
    }
}

