/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.object;

import org.farng.mp3.object.AbstractMP3Object;

public class ObjectID3v2LyricLine
extends AbstractMP3Object {
    String text = "";
    long timeStamp = 0L;

    public ObjectID3v2LyricLine(String identifier) {
        this.identifier = identifier;
    }

    public ObjectID3v2LyricLine(ObjectID3v2LyricLine copyObject) {
        super(copyObject);
        this.text = new String(copyObject.text);
        this.timeStamp = copyObject.timeStamp;
    }

    public int getSize() {
        return this.text.length() + 1 + 4;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObjectID3v2LyricLine)) {
            return false;
        }
        ObjectID3v2LyricLine object = (ObjectID3v2LyricLine)obj;
        if (!this.text.equals(object.text)) {
            return false;
        }
        if (this.timeStamp != object.timeStamp) {
            return false;
        }
        return super.equals(obj);
    }

    public void readByteArray(byte[] arr, int offset) {
        if (arr == null) {
            throw new NullPointerException("Byte array is null");
        }
        if (offset < 0 || offset >= arr.length) {
            throw new IndexOutOfBoundsException("Offset to byte array is out of bounds: offset = " + offset + ", array.length = " + arr.length);
        }
        this.text = new String(arr, offset, arr.length - offset - 4);
        this.timeStamp = 0L;
        int i = arr.length - 4;
        while (i < arr.length) {
            this.timeStamp <<= 8;
            this.timeStamp += (long)arr[i];
            ++i;
        }
    }

    public String toString() {
        return this.timeStamp + " " + this.text;
    }

    public byte[] writeByteArray() {
        byte[] arr = new byte[this.getSize()];
        int i = 0;
        while (i < this.text.length()) {
            arr[i] = (byte)this.text.charAt(i);
            ++i;
        }
        arr[i++] = 0;
        arr[i++] = (byte)((this.timeStamp & 0xFFFFFFFFFF000000L) >> 24);
        arr[i++] = (byte)((this.timeStamp & 0xFF0000L) >> 16);
        arr[i++] = (byte)((this.timeStamp & 0xFF00L) >> 8);
        arr[i++] = (byte)(this.timeStamp & 0xFFL);
        return arr;
    }
}

