/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.object;

import java.util.ArrayList;
import java.util.ListIterator;
import org.farng.mp3.TagUtility;
import org.farng.mp3.object.AbstractMP3Object;

public class ObjectGroupRepeated
extends AbstractMP3Object {
    private ArrayList objectList;
    private ArrayList propertyList;

    public ObjectGroupRepeated(String identifier) {
        this.identifier = identifier;
        this.propertyList = new ArrayList();
        this.objectList = new ArrayList();
    }

    public ObjectGroupRepeated(ObjectGroupRepeated copyObject) {
        super(copyObject);
        AbstractMP3Object newObject;
        int i = 0;
        while (i < copyObject.objectList.size()) {
            newObject = (AbstractMP3Object)TagUtility.copyObject(copyObject.objectList.get(i));
            this.objectList.add(newObject);
            ++i;
        }
        int i2 = 0;
        while (i2 < copyObject.propertyList.size()) {
            newObject = (AbstractMP3Object)TagUtility.copyObject(copyObject.propertyList.get(i2));
            this.propertyList.add(newObject);
            ++i2;
        }
    }

    public ArrayList getObjectList() {
        return this.objectList;
    }

    public ArrayList getPropertyList() {
        return this.propertyList;
    }

    public int getSize() {
        int size = 0;
        ListIterator iterator = this.objectList.listIterator();
        while (iterator.hasNext()) {
            AbstractMP3Object object = (AbstractMP3Object)iterator.next();
            size += object.getSize();
        }
        return size;
    }

    public void addObject(AbstractMP3Object obj) {
        this.objectList.add(obj);
    }

    public void addProperty(AbstractMP3Object obj) {
        this.propertyList.add(obj);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObjectGroupRepeated)) {
            return false;
        }
        ObjectGroupRepeated object = (ObjectGroupRepeated)obj;
        if (!this.objectList.equals(object.objectList)) {
            return false;
        }
        if (!this.propertyList.equals(object.propertyList)) {
            return false;
        }
        return super.equals(obj);
    }

    public void readByteArray(byte[] arr, int offset) {
        if (arr == null) {
            throw new NullPointerException("Byte array is null");
        }
        if (offset < 0 || offset >= arr.length) {
            throw new IndexOutOfBoundsException("Offset to byte array is out of bounds: offset = " + offset + ", array.length = " + arr.length);
        }
        if (this.propertyList.size() > 0) {
            while (offset < arr.length) {
                ListIterator iterator = this.propertyList.listIterator();
                while (iterator.hasNext()) {
                    Class<?> className = iterator.next().getClass();
                    try {
                        AbstractMP3Object object = (AbstractMP3Object)className.newInstance();
                        this.objectList.add(object);
                        object.readByteArray(arr, offset);
                        offset += object.getSize();
                    }
                    catch (IllegalAccessException ex) {
                        ex.printStackTrace();
                    }
                    catch (InstantiationException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    public String toString() {
        String str = "";
        ListIterator iterator = this.objectList.listIterator();
        while (iterator.hasNext()) {
            AbstractMP3Object object = (AbstractMP3Object)iterator.next();
            str = str + object.toString() + "\n";
        }
        return str;
    }

    public byte[] writeByteArray() {
        byte[] totalArray = new byte[this.getSize()];
        ListIterator iterator = this.objectList.listIterator();
        while (iterator.hasNext()) {
            AbstractMP3Object object = (AbstractMP3Object)iterator.next();
            byte[] objectArray = object.writeByteArray();
            System.arraycopy(objectArray, 0, totalArray, 0, totalArray.length);
        }
        return totalArray;
    }
}

