/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.lyrics3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import org.farng.mp3.AbstractMP3Tag;
import org.farng.mp3.TagNotFoundException;
import org.farng.mp3.TagOptionSingleton;
import org.farng.mp3.TagUtility;
import org.farng.mp3.id3.ID3v1;
import org.farng.mp3.lyrics3.AbstractLyrics3;
import org.farng.mp3.lyrics3.FieldBodyLYR;
import org.farng.mp3.lyrics3.Lyrics3v2;

public class Lyrics3v1
extends AbstractLyrics3 {
    private String lyric = "";

    public Lyrics3v1() {
    }

    public Lyrics3v1(Lyrics3v1 copyObject) {
        super(copyObject);
        this.lyric = new String(copyObject.lyric);
    }

    public Lyrics3v1(AbstractMP3Tag mp3Tag) {
        if (mp3Tag != null) {
            if (mp3Tag instanceof Lyrics3v1) {
                throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
            }
            Lyrics3v2 lyricTag = mp3Tag instanceof Lyrics3v2 ? (Lyrics3v2)mp3Tag : new Lyrics3v2(mp3Tag);
            FieldBodyLYR lyricField = (FieldBodyLYR)lyricTag.getField("LYR").getBody();
            this.lyric = new String(lyricField.getLyric());
        }
    }

    public Lyrics3v1(RandomAccessFile file) throws TagNotFoundException, IOException {
        this.read(file);
    }

    public String getIdentifier() {
        return "Lyrics3v1.00";
    }

    public void setLyric(String lyric) {
        this.lyric = TagUtility.truncate(lyric, 5100);
    }

    public String getLyric() {
        return this.lyric;
    }

    public int getSize() {
        return "LYRICSBEGIN".length() + this.lyric.length() + "LYRICSEND".length();
    }

    public boolean isSubsetOf(Object obj) {
        if (!(obj instanceof Lyrics3v1)) {
            return false;
        }
        return ((Lyrics3v1)obj).lyric.indexOf(this.lyric) >= 0;
    }

    public void append(AbstractMP3Tag tag) {
        Lyrics3v1 oldTag = this;
        Lyrics3v1 newTag = null;
        if (tag != null) {
            newTag = tag instanceof Lyrics3v1 ? (Lyrics3v1)tag : new Lyrics3v1();
            this.lyric = oldTag.lyric + "\n" + newTag.lyric;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Lyrics3v1)) {
            return false;
        }
        Lyrics3v1 object = (Lyrics3v1)obj;
        if (!this.lyric.equals(object.lyric)) {
            return false;
        }
        return super.equals(obj);
    }

    public Iterator iterator() {
        throw new UnsupportedOperationException("Method iterator() not yet implemented.");
    }

    public void overwrite(AbstractMP3Tag tag) {
        Lyrics3v1 oldTag = this;
        Lyrics3v1 newTag = null;
        if (tag != null) {
            newTag = tag instanceof Lyrics3v1 ? (Lyrics3v1)tag : new Lyrics3v1();
            this.lyric = TagOptionSingleton.getInstance().isLyrics3Save() ? newTag.lyric : oldTag.lyric;
        }
    }

    public void read(RandomAccessFile file) throws TagNotFoundException, IOException {
        byte[] buffer = new byte[5120];
        if (!this.seek(file)) {
            throw new TagNotFoundException("ID3v1 tag not found");
        }
        file.read(buffer);
        String lyricBuffer = new String(buffer);
        this.lyric = lyricBuffer.substring(0, lyricBuffer.indexOf("LYRICSEND"));
    }

    public boolean seek(RandomAccessFile file) throws IOException {
        byte[] buffer = new byte[5120];
        String lyricsEnd = "";
        String lyricsStart = "";
        long offset = 0L;
        file.seek(file.length() - 128L - 9L);
        file.read(buffer, 0, 9);
        lyricsEnd = new String(buffer, 0, 9);
        if (lyricsEnd.equals("LYRICSEND")) {
            offset = file.getFilePointer();
        } else {
            file.seek(file.length() - 9L);
            file.read(buffer, 0, 9);
            lyricsEnd = new String(buffer, 0, 9);
            if (lyricsEnd.equals("LYRICSEND")) {
                offset = file.getFilePointer();
            } else {
                return false;
            }
        }
        file.seek(offset -= 5120L);
        file.read(buffer);
        lyricsStart = new String(buffer);
        int i = lyricsStart.indexOf("LYRICSBEGIN");
        if (i == -1) {
            return false;
        }
        file.seek(offset + (long)i + 11L);
        return true;
    }

    public String toString() {
        String str = this.getIdentifier() + " " + this.getSize() + "\n";
        return str + this.lyric;
    }

    public void write(AbstractMP3Tag tag) {
        Lyrics3v1 newTag = null;
        if (tag != null) {
            newTag = tag instanceof Lyrics3v1 ? (Lyrics3v1)tag : new Lyrics3v1();
            this.lyric = newTag.lyric;
        }
    }

    public void write(RandomAccessFile file) throws IOException {
        String str = "";
        int offset = 0;
        ID3v1 id3v1tag = null;
        id3v1tag = id3v1tag.getID3tag(file);
        this.delete(file);
        file.seek(file.length());
        byte[] buffer = new byte[this.lyric.length() + 11 + 9];
        str = "LYRICSBEGIN";
        int i = 0;
        while (i < str.length()) {
            buffer[i] = (byte)str.charAt(i);
            ++i;
        }
        offset = str.length();
        str = TagUtility.truncate(this.lyric, 5100);
        int i2 = 0;
        while (i2 < str.length()) {
            buffer[i2 + offset] = (byte)str.charAt(i2);
            ++i2;
        }
        offset += str.length();
        str = "LYRICSEND";
        int i3 = 0;
        while (i3 < str.length()) {
            buffer[i3 + offset] = (byte)str.charAt(i3);
            ++i3;
        }
        file.write(buffer, 0, offset += str.length());
        if (id3v1tag != null) {
            id3v1tag.write(file);
        }
    }
}

