/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.TagUtility;
import org.farng.mp3.id3.AbstractID3v2;
import org.farng.mp3.id3.AbstractID3v2Frame;
import org.farng.mp3.id3.AbstractID3v2FrameBody;
import org.farng.mp3.id3.ID3v2_2Frame;

public class ID3v2_3Frame
extends ID3v2_2Frame {
    protected boolean compression = false;
    protected boolean encryption = false;
    protected boolean fileAlterPreservation = false;
    protected boolean groupingIdentity = false;
    protected boolean readOnly = false;
    protected boolean tagAlterPreservation = false;

    public ID3v2_3Frame() {
        this.setAlterPreservation();
    }

    public ID3v2_3Frame(ID3v2_3Frame copyObject) {
        super(copyObject);
        this.compression = copyObject.compression;
        this.encryption = copyObject.encryption;
        this.fileAlterPreservation = copyObject.fileAlterPreservation;
        this.groupingIdentity = copyObject.groupingIdentity;
        this.readOnly = copyObject.readOnly;
        this.tagAlterPreservation = copyObject.tagAlterPreservation;
    }

    public ID3v2_3Frame(boolean readOnly, boolean groupingIdentity, boolean compression, boolean encryption, AbstractID3v2FrameBody body) {
        this.body = body;
        this.readOnly = readOnly;
        this.groupingIdentity = groupingIdentity;
        this.compression = compression;
        this.encryption = encryption;
        this.setAlterPreservation();
    }

    public ID3v2_3Frame(AbstractID3v2Frame frame) {
        if (frame instanceof ID3v2_3Frame) {
            ID3v2_3Frame f = (ID3v2_3Frame)frame;
            this.tagAlterPreservation = f.tagAlterPreservation;
            this.fileAlterPreservation = f.fileAlterPreservation;
            this.readOnly = f.readOnly;
            this.groupingIdentity = f.groupingIdentity;
            this.compression = f.compression;
            this.encryption = f.encryption;
        }
        if (frame instanceof ID3v2_2Frame) {
            // empty if block
        }
        if (frame.getBody() != null && TagUtility.isID3v2_3FrameIdentifier(frame.getIdentifier())) {
            this.body = (AbstractID3v2FrameBody)TagUtility.copyObject(frame.getBody());
        }
    }

    public ID3v2_3Frame(RandomAccessFile file) throws IOException, InvalidTagException {
        this.read(file);
    }

    public int getSize() {
        return this.body.getSize() + 4 + 2 + 4;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ID3v2_3Frame)) {
            return false;
        }
        ID3v2_3Frame object = (ID3v2_3Frame)obj;
        if (this.compression != object.compression) {
            return false;
        }
        if (this.encryption != object.encryption) {
            return false;
        }
        if (this.fileAlterPreservation != object.fileAlterPreservation) {
            return false;
        }
        if (this.groupingIdentity != object.groupingIdentity) {
            return false;
        }
        if (this.readOnly != object.readOnly) {
            return false;
        }
        if (this.tagAlterPreservation != object.tagAlterPreservation) {
            return false;
        }
        return super.equals(obj);
    }

    public void read(RandomAccessFile file) throws IOException, InvalidTagException {
        long filePointer;
        byte b;
        byte[] buffer = new byte[4];
        do {
            filePointer = file.getFilePointer();
            b = file.readByte();
            ++AbstractID3v2.paddingCounter;
        } while (b == 0);
        file.seek(filePointer);
        --AbstractID3v2.paddingCounter;
        file.read(buffer, 0, 4);
        String identifier = new String(buffer, 0, 4);
        if (!this.isValidID3v2FrameIdentifier(identifier)) {
            file.seek(file.getFilePointer() - 3L);
            throw new InvalidTagException(identifier + " is not a valid ID3v2.30 frame");
        }
        filePointer = file.getFilePointer();
        file.skipBytes(4);
        file.read(buffer, 0, 2);
        this.tagAlterPreservation = (buffer[0] & 0x80) != 0;
        this.fileAlterPreservation = (buffer[0] & 0x40) != 0;
        this.readOnly = (buffer[0] & 0x20) != 0;
        this.compression = (buffer[1] & 0x80) != 0;
        this.encryption = (buffer[1] & 0x40) != 0;
        this.groupingIdentity = (buffer[1] & 0x20) != 0;
        file.seek(filePointer);
        this.body = this.readBody(identifier, file);
    }

    public void write(RandomAccessFile file) throws IOException {
        byte[] buffer = new byte[4];
        String str = TagUtility.truncate(this.getIdentifier(), 4);
        int i = 0;
        while (i < str.length()) {
            buffer[i] = (byte)str.charAt(i);
            ++i;
        }
        file.write(buffer, 0, str.length());
        long filePointer = file.getFilePointer();
        file.skipBytes(4);
        this.setAlterPreservation();
        buffer[0] = 0;
        buffer[1] = 0;
        if (this.tagAlterPreservation) {
            buffer[0] = (byte)(buffer[0] | 0x80);
        }
        if (this.fileAlterPreservation) {
            buffer[0] = (byte)(buffer[0] | 0x40);
        }
        if (this.readOnly) {
            buffer[0] = (byte)(buffer[0] | 0x20);
        }
        if (this.compression) {
            buffer[1] = (byte)(buffer[1] | 0x80);
        }
        if (this.encryption) {
            buffer[1] = (byte)(buffer[1] | 0x40);
        }
        if (this.groupingIdentity) {
            buffer[1] = (byte)(buffer[1] | 0x20);
        }
        file.write(buffer, 0, 2);
        file.seek(filePointer);
        this.body.write(file);
    }

    protected void setAlterPreservation() {
        String str = this.getIdentifier();
        if (str.equals("ETCO") || str.equals("EQUA") || str.equals("MLLT") || str.equals("POSS") || str.equals("SYLT") || str.equals("SYTC") || str.equals("RVAD") || str.equals("TENC") || str.equals("TLEN") || str.equals("TSIZ")) {
            this.tagAlterPreservation = false;
            this.fileAlterPreservation = true;
        } else {
            this.tagAlterPreservation = false;
            this.fileAlterPreservation = true;
        }
    }
}

