/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Iterator;
import org.farng.mp3.AbstractMP3Tag;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.MP3File;
import org.farng.mp3.TagException;
import org.farng.mp3.TagNotFoundException;
import org.farng.mp3.id3.AbstractID3v2Frame;
import org.farng.mp3.id3.ID3v2_2;
import org.farng.mp3.id3.ID3v2_3Frame;
import org.farng.mp3.id3.ID3v2_4;

public class ID3v2_3
extends ID3v2_2 {
    protected boolean crcDataFlag = false;
    protected boolean experimental = false;
    protected boolean extended = false;
    protected int crcData = 0;
    protected int paddingSize = 0;

    public ID3v2_3() {
        this.majorVersion = (byte)2;
        this.revision = (byte)3;
    }

    public ID3v2_3(ID3v2_3 copyObject) {
        super(copyObject);
        this.crcDataFlag = copyObject.crcDataFlag;
        this.experimental = copyObject.experimental;
        this.extended = copyObject.extended;
        this.crcData = copyObject.crcData;
        this.paddingSize = copyObject.paddingSize;
    }

    public ID3v2_3(AbstractMP3Tag mp3tag) {
        if (mp3tag != null) {
            if (!(mp3tag instanceof ID3v2_4) && mp3tag instanceof ID3v2_3) {
                throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
            }
            ID3v2_4 convertedTag = mp3tag instanceof ID3v2_4 ? (ID3v2_4)mp3tag : new ID3v2_4(mp3tag);
            this.extended = convertedTag.extended;
            this.experimental = convertedTag.experimental;
            this.crcDataFlag = convertedTag.crcDataFlag;
            this.crcData = convertedTag.crcData;
            this.paddingSize = convertedTag.paddingSize;
            this.compression = convertedTag.compression;
            this.unsynchronization = convertedTag.unsynchronization;
            ID3v2_4 id3tag = convertedTag;
            Iterator iterator = id3tag.frameMap.values().iterator();
            while (iterator.hasNext()) {
                AbstractID3v2Frame frame = (AbstractID3v2Frame)iterator.next();
                ID3v2_3Frame newFrame = new ID3v2_3Frame(frame);
                this.frameMap.put(newFrame.getIdentifier(), newFrame);
            }
        }
    }

    public ID3v2_3(RandomAccessFile file) throws TagException, IOException {
        this.read(file);
    }

    public String getIdentifier() {
        return "ID3v2.30";
    }

    public int getSize() {
        int size = 10;
        if (this.extended) {
            size = this.crcDataFlag ? (size += 14) : (size += 10);
        }
        Iterator iterator = this.frameMap.values().iterator();
        while (iterator.hasNext()) {
            AbstractID3v2Frame frame = (AbstractID3v2Frame)iterator.next();
            size += frame.getSize();
        }
        return size;
    }

    public void append(AbstractMP3Tag tag) {
        if (tag instanceof ID3v2_3) {
            this.experimental = ((ID3v2_3)tag).experimental;
            this.extended = ((ID3v2_3)tag).extended;
            this.crcDataFlag = ((ID3v2_3)tag).crcDataFlag;
            this.paddingSize = ((ID3v2_3)tag).paddingSize;
            this.crcData = ((ID3v2_3)tag).crcData;
        }
        super.append(tag);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ID3v2_3)) {
            return false;
        }
        ID3v2_3 object = (ID3v2_3)obj;
        if (this.crcData != object.crcData) {
            return false;
        }
        if (this.crcDataFlag != object.crcDataFlag) {
            return false;
        }
        if (this.experimental != object.experimental) {
            return false;
        }
        if (this.extended != object.extended) {
            return false;
        }
        if (this.paddingSize != object.paddingSize) {
            return false;
        }
        return super.equals(obj);
    }

    public void overwrite(AbstractMP3Tag tag) {
        if (tag instanceof ID3v2_3) {
            this.experimental = ((ID3v2_3)tag).experimental;
            this.extended = ((ID3v2_3)tag).extended;
            this.crcDataFlag = ((ID3v2_3)tag).crcDataFlag;
            this.paddingSize = ((ID3v2_3)tag).paddingSize;
            this.crcData = ((ID3v2_3)tag).crcData;
        }
        super.overwrite(tag);
    }

    public void read(RandomAccessFile file) throws TagException, IOException {
        byte[] buffer = new byte[4];
        if (!this.seek(file)) {
            throw new TagNotFoundException(this.getIdentifier() + " tag not found");
        }
        file.read(buffer, 0, 3);
        if (buffer[0] != 3 || buffer[1] != 0) {
            throw new TagNotFoundException(this.getIdentifier() + " tag not found");
        }
        this.majorVersion = buffer[0];
        this.revision = buffer[1];
        this.unsynchronization = (buffer[2] & 0x80) != 0;
        this.extended = (buffer[2] & 0x40) != 0;
        this.experimental = (buffer[2] & 0x20) != 0;
        file.read(buffer, 0, 4);
        int size = this.byteArrayToSize(buffer);
        long filePointer = file.getFilePointer();
        if (this.extended) {
            int extendedHeaderSize = file.readInt();
            if (extendedHeaderSize != 6 || extendedHeaderSize != 10) {
                throw new InvalidTagException("Invalid Extended Header Size.");
            }
            file.read(buffer, 0, 2);
            boolean bl = this.crcDataFlag = (buffer[0] & 0x80) != 0;
            if (extendedHeaderSize == 10 && !this.crcDataFlag || extendedHeaderSize == 6 && this.crcDataFlag) {
                throw new InvalidTagException("CRC Data flag not set correctly.");
            }
            this.paddingSize = file.readInt();
            if (extendedHeaderSize == 10 && this.crcDataFlag) {
                this.crcData = file.readInt();
            }
        }
        this.frameMap = new HashMap();
        this.fileReadSize = size;
        ID3v2_2.paddingCounter = 0;
        while (file.getFilePointer() - filePointer <= (long)size) {
            try {
                ID3v2_3Frame next = new ID3v2_3Frame(file);
                String id = next.getIdentifier();
                if (this.frameMap.containsKey(id)) {
                    this.duplicateFrameId = this.duplicateFrameId + id + "; ";
                    this.duplicateBytes += ((AbstractID3v2Frame)this.frameMap.get(id)).getSize();
                }
                this.frameMap.put(id, next);
            }
            catch (InvalidTagException ex) {
                if (ex.getMessage().equals("Found empty frame")) {
                    this.emptyFrameBytes += 10;
                } else {
                    ++this.invalidFrameBytes;
                }
                if (file.getFilePointer() - filePointer > (long)size) continue;
            }
        }
        this.padding = ID3v2_2.paddingCounter;
    }

    public boolean seek(RandomAccessFile file) throws IOException {
        byte[] buffer = new byte[3];
        file.seek(0L);
        file.read(buffer, 0, 3);
        String tag = new String(buffer, 0, 3);
        if (!tag.equals("ID3")) {
            return false;
        }
        file.read(buffer, 0, 2);
        file.seek(file.getFilePointer() - 2L);
        return buffer[0] == 3 && buffer[1] == 0;
    }

    public String toString() {
        Iterator iterator = this.frameMap.values().iterator();
        String str = this.getIdentifier() + " " + this.getSize() + "\n";
        str = str + "compression        = " + this.compression + "\n";
        str = str + "unsynchronization  = " + this.unsynchronization + "\n";
        str = str + "crcData            = " + this.crcData + "\n";
        str = str + "crcDataFlag        = " + this.crcDataFlag + "\n";
        str = str + "experimental       = " + this.experimental + "\n";
        str = str + "extended           = " + this.extended + "\n";
        str = str + "paddingSize        = " + this.paddingSize + "\n";
        while (iterator.hasNext()) {
            ID3v2_3Frame frame = (ID3v2_3Frame)iterator.next();
            str = str + frame.toString() + "\n";
        }
        return str + "\n";
    }

    public void write(AbstractMP3Tag tag) {
        if (tag instanceof ID3v2_3) {
            this.experimental = ((ID3v2_3)tag).experimental;
            this.extended = ((ID3v2_3)tag).extended;
            this.crcDataFlag = ((ID3v2_3)tag).crcDataFlag;
            this.paddingSize = ((ID3v2_3)tag).paddingSize;
            this.crcData = ((ID3v2_3)tag).crcData;
        }
        super.write(tag);
    }

    public void write(RandomAccessFile file) throws IOException {
        byte[] buffer = new byte[6];
        MP3File mp3 = new MP3File();
        mp3.seekMP3Frame(file);
        long mp3start = file.getFilePointer();
        file.seek(0L);
        String str = "ID3";
        int i = 0;
        while (i < str.length()) {
            buffer[i] = (byte)str.charAt(i);
            ++i;
        }
        buffer[3] = 3;
        buffer[4] = 0;
        if (this.unsynchronization) {
            buffer[5] = (byte)(buffer[5] | 0x80);
        }
        if (this.extended) {
            buffer[5] = (byte)(buffer[5] | 0x40);
        }
        if (this.experimental) {
            buffer[5] = (byte)(buffer[5] | 0x20);
        }
        file.write(buffer);
        file.write(this.sizeToByteArray((int)mp3start - 10));
        if (this.extended) {
            if (this.crcDataFlag) {
                file.writeInt(10);
                buffer[0] = 0;
                buffer[0] = (byte)(buffer[0] | 0x80);
                file.write(buffer, 0, 2);
                file.writeInt(this.paddingSize);
                file.writeInt(this.crcData);
            } else {
                file.writeInt(6);
                file.write(buffer, 0, 2);
                file.writeInt(this.paddingSize);
            }
        }
        Iterator iterator = this.frameMap.values().iterator();
        while (iterator.hasNext()) {
            ID3v2_3Frame frame = (ID3v2_3Frame)iterator.next();
            frame.write(file);
        }
        if ((long)this.getSize() != file.getFilePointer()) {
            // empty if block
        }
    }
}

